/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.importer.AccessRecord;
import com.tngtech.archunit.core.importer.ClassFileImportRecord;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class ClassGraphCreator
implements ImportContext {
    private final ImportedClasses classes;
    private final ClassFileImportRecord importRecord;
    private final SetMultimap<JavaCodeUnit, AccessRecord.FieldAccessRecord> processedFieldAccessRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.MethodCallTarget>> processedMethodCallRecords = HashMultimap.create();
    private final SetMultimap<JavaCodeUnit, AccessRecord<AccessTarget.ConstructorCallTarget>> processedConstructorCallRecords = HashMultimap.create();
    private final Function<JavaClass, Set<String>> superClassStrategy;
    private final Function<JavaClass, Set<String>> interfaceStrategy;
    private final MemberDependenciesByTarget memberDependenciesByTarget = new MemberDependenciesByTarget();

    ClassGraphCreator(ClassFileImportRecord importRecord, ClassResolver classResolver) {
        this.importRecord = importRecord;
        this.classes = new ImportedClasses(importRecord.getClasses(), classResolver);
        this.superClassStrategy = this.createSuperClassStrategy();
        this.interfaceStrategy = this.createInterfaceStrategy();
    }

    private Function<JavaClass, Set<String>> createSuperClassStrategy() {
        return new Function<JavaClass, Set<String>>(){

            @Override
            public Set<String> apply(JavaClass input) {
                return ClassGraphCreator.this.importRecord.getSuperClassFor(input.getName()).asSet();
            }
        };
    }

    private Function<JavaClass, Set<String>> createInterfaceStrategy() {
        return new Function<JavaClass, Set<String>>(){

            @Override
            public Set<String> apply(JavaClass input) {
                return ClassGraphCreator.this.importRecord.getInterfaceNamesFor(input.getName());
            }
        };
    }

    JavaClasses complete() {
        this.ensureCallTargetsArePresent();
        this.ensureClassHierarchies();
        this.completeMembers();
        this.completeAnnotations();
        for (RawAccessRecord.ForField fieldAccessRecord : this.importRecord.getRawFieldAccessRecords()) {
            this.tryProcess(fieldAccessRecord, AccessRecord.Factory.forFieldAccessRecord(), this.processedFieldAccessRecords);
        }
        for (RawAccessRecord methodCallRecord : this.importRecord.getRawMethodCallRecords()) {
            this.tryProcess(methodCallRecord, AccessRecord.Factory.forMethodCallRecord(), this.processedMethodCallRecords);
        }
        for (RawAccessRecord constructorCallRecord : this.importRecord.getRawConstructorCallRecords()) {
            this.tryProcess(constructorCallRecord, AccessRecord.Factory.forConstructorCallRecord(), this.processedConstructorCallRecords);
        }
        return DomainObjectCreationContext.createJavaClasses(this.classes.getDirectlyImported(), this.classes.getAll(), this);
    }

    private void ensureCallTargetsArePresent() {
        for (RawAccessRecord record : this.importRecord.getAccessRecords()) {
            this.classes.ensurePresent(record.target.owner.getName());
        }
    }

    private void ensureClassHierarchies() {
        this.ensureClassesOfHierarchyInContext();
        for (JavaClass javaClass : this.classes.getAll().values()) {
            DomainObjectCreationContext.completeClassHierarchy(javaClass, this);
        }
    }

    private void ensureClassesOfHierarchyInContext() {
        for (String superClassName : ImmutableSet.copyOf(this.importRecord.getSuperClassNamesBySubClass().values())) {
            this.resolveInheritance(superClassName, this.superClassStrategy);
        }
        for (String superInterfaceName : ImmutableSet.copyOf(this.importRecord.getInterfaceNamesBySubInterface().values())) {
            this.resolveInheritance(superInterfaceName, this.interfaceStrategy);
        }
    }

    private void resolveInheritance(String currentTypeName, Function<JavaClass, Set<String>> inheritanceStrategy) {
        for (String parent : inheritanceStrategy.apply(this.classes.getOrResolve(currentTypeName))) {
            this.resolveInheritance(parent, inheritanceStrategy);
        }
    }

    private void completeMembers() {
        for (JavaClass javaClass : this.classes.getAll().values()) {
            DomainObjectCreationContext.completeMembers(javaClass, this);
        }
    }

    private void completeAnnotations() {
        for (JavaClass javaClass : this.classes.getAll().values()) {
            DomainObjectCreationContext.completeAnnotations(javaClass, this);
            for (JavaMember javaMember : Iterables.concat(javaClass.getFields(), javaClass.getMethods(), javaClass.getConstructors())) {
                this.memberDependenciesByTarget.registerAnnotations(javaMember.getAnnotations());
            }
        }
    }

    private <T extends AccessRecord<?>, B extends RawAccessRecord> void tryProcess(B rawRecord, AccessRecord.Factory<B, T> factory, Multimap<JavaCodeUnit, T> processedAccessRecords) {
        AccessRecord processed = (AccessRecord)factory.create(rawRecord, this.classes);
        processedAccessRecords.put(processed.getCaller(), processed);
    }

    @Override
    public Set<JavaFieldAccess> getFieldAccessesFor(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord.FieldAccessRecord record : this.processedFieldAccessRecords.get(codeUnit)) {
            result.add(this.accessBuilderFrom(new DomainBuilders.JavaFieldAccessBuilder(), record).withAccessType(record.getAccessType()).build());
        }
        return result.build();
    }

    @Override
    public Set<JavaMethodCall> getMethodCallsFor(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord<AccessTarget.MethodCallTarget> record : this.processedMethodCallRecords.get(codeUnit)) {
            result.add(this.accessBuilderFrom(new DomainBuilders.JavaMethodCallBuilder(), record).build());
        }
        return result.build();
    }

    @Override
    public Set<JavaConstructorCall> getConstructorCallsFor(JavaCodeUnit codeUnit) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AccessRecord<AccessTarget.ConstructorCallTarget> record : this.processedConstructorCallRecords.get(codeUnit)) {
            result.add(this.accessBuilderFrom(new DomainBuilders.JavaConstructorCallBuilder(), record).build());
        }
        return result.build();
    }

    @Override
    public Set<JavaField> getFieldsOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getFieldsOfType(javaClass);
    }

    @Override
    public Set<JavaMethod> getMethodsWithParameterOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getMethodsWithParameterOfType(javaClass);
    }

    @Override
    public Set<JavaMethod> getMethodsWithReturnType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getMethodsWithReturnType(javaClass);
    }

    @Override
    public Set<ThrowsDeclaration<JavaMethod>> getMethodThrowsDeclarationsOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getMethodThrowsDeclarationsOfType(javaClass);
    }

    @Override
    public Set<JavaConstructor> getConstructorsWithParameterOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getConstructorsWithParameterOfType(javaClass);
    }

    @Override
    public Set<ThrowsDeclaration<JavaConstructor>> getConstructorThrowsDeclarationsOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getConstructorThrowsDeclarationsOfType(javaClass);
    }

    @Override
    public Set<JavaAnnotation<?>> getAnnotationsOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getAnnotationsOfType(javaClass);
    }

    @Override
    public Set<JavaAnnotation<?>> getAnnotationsWithParameterOfType(JavaClass javaClass) {
        return this.memberDependenciesByTarget.getAnnotationsWithParameterOfType(javaClass);
    }

    private <T extends AccessTarget, B extends DomainBuilders.JavaAccessBuilder<T, B>> B accessBuilderFrom(B builder, AccessRecord<T> record) {
        return ((DomainBuilders.JavaAccessBuilder)((DomainBuilders.JavaAccessBuilder)builder.withOrigin(record.getCaller())).withTarget(record.getTarget())).withLineNumber(record.getLineNumber());
    }

    @Override
    public Optional<JavaClass> createSuperClass(JavaClass owner) {
        Optional<String> superClassName = this.importRecord.getSuperClassFor(owner.getName());
        return superClassName.isPresent() ? Optional.of(this.classes.getOrResolve(superClassName.get())) : Optional.absent();
    }

    @Override
    public Set<JavaClass> createInterfaces(JavaClass owner) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String interfaceName : this.importRecord.getInterfaceNamesFor(owner.getName())) {
            result.add(this.classes.getOrResolve(interfaceName));
        }
        return result.build();
    }

    @Override
    public Set<JavaField> createFields(JavaClass owner) {
        Set<JavaField> fields = DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getFieldBuildersFor(owner.getName()), owner, this.classes.byTypeName());
        this.memberDependenciesByTarget.registerFields(fields);
        return fields;
    }

    @Override
    public Set<JavaMethod> createMethods(JavaClass owner) {
        Set<JavaMethod> methods = DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getMethodBuildersFor(owner.getName()), owner, this.classes.byTypeName());
        this.memberDependenciesByTarget.registerMethods(methods);
        return methods;
    }

    @Override
    public Set<JavaConstructor> createConstructors(JavaClass owner) {
        Set<JavaConstructor> constructors = DomainBuilders.BuilderWithBuildParameter.BuildFinisher.build(this.importRecord.getConstructorBuildersFor(owner.getName()), owner, this.classes.byTypeName());
        this.memberDependenciesByTarget.registerConstructors(constructors);
        return constructors;
    }

    @Override
    public Optional<JavaStaticInitializer> createStaticInitializer(JavaClass owner) {
        Optional<DomainBuilders.JavaStaticInitializerBuilder> builder = this.importRecord.getStaticInitializerBuilderFor(owner.getName());
        return builder.isPresent() ? Optional.of(builder.get().build(owner, this.classes.byTypeName())) : Optional.absent();
    }

    @Override
    public Map<String, JavaAnnotation<JavaClass>> createAnnotations(JavaClass owner) {
        Map<String, JavaAnnotation<JavaClass>> annotations = DomainBuilders.buildAnnotations(owner, this.importRecord.getAnnotationsFor(owner.getName()), this.classes.byTypeName());
        this.memberDependenciesByTarget.registerAnnotations(annotations.values());
        return annotations;
    }

    @Override
    public Optional<JavaClass> createEnclosingClass(JavaClass owner) {
        Optional<String> enclosingClassName = this.importRecord.getEnclosingClassFor(owner.getName());
        return enclosingClassName.isPresent() ? Optional.of(this.classes.getOrResolve(enclosingClassName.get())) : Optional.absent();
    }

    @Override
    public JavaClass resolveClass(String fullyQualifiedClassName) {
        return this.classes.getOrResolve(fullyQualifiedClassName);
    }

    private static class MemberDependenciesByTarget {
        private final SetMultimap<JavaClass, JavaField> fieldTypeDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, JavaMethod> methodParameterTypeDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, JavaMethod> methodReturnTypeDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, ThrowsDeclaration<JavaMethod>> methodsThrowsDeclarationDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, JavaConstructor> constructorParameterTypeDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, ThrowsDeclaration<JavaConstructor>> constructorThrowsDeclarationDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, JavaAnnotation<?>> annotationTypeDependencies = HashMultimap.create();
        private final SetMultimap<JavaClass, JavaAnnotation<?>> annotationParameterTypeDependencies = HashMultimap.create();

        private MemberDependenciesByTarget() {
        }

        void registerFields(Set<JavaField> fields) {
            for (JavaField field : fields) {
                this.fieldTypeDependencies.put(field.getRawType(), field);
            }
        }

        void registerMethods(Set<JavaMethod> methods) {
            for (JavaMethod method : methods) {
                for (JavaClass javaClass : method.getRawParameterTypes()) {
                    this.methodParameterTypeDependencies.put(javaClass, method);
                }
                this.methodReturnTypeDependencies.put(method.getRawReturnType(), method);
                for (ThrowsDeclaration throwsDeclaration : method.getThrowsClause()) {
                    this.methodsThrowsDeclarationDependencies.put(throwsDeclaration.getRawType(), throwsDeclaration);
                }
            }
        }

        void registerConstructors(Set<JavaConstructor> constructors) {
            for (JavaConstructor constructor : constructors) {
                for (JavaClass javaClass : constructor.getRawParameterTypes()) {
                    this.constructorParameterTypeDependencies.put(javaClass, constructor);
                }
                for (ThrowsDeclaration throwsDeclaration : constructor.getThrowsClause()) {
                    this.constructorThrowsDeclarationDependencies.put(throwsDeclaration.getRawType(), throwsDeclaration);
                }
            }
        }

        void registerAnnotations(Collection<? extends JavaAnnotation<?>> annotations) {
            for (final JavaAnnotation<?> annotation : annotations) {
                this.annotationTypeDependencies.put(annotation.getRawType(), annotation);
                annotation.accept(new JavaAnnotation.DefaultParameterVisitor(){

                    @Override
                    public void visitClass(String propertyName, JavaClass javaClass) {
                        MemberDependenciesByTarget.this.annotationParameterTypeDependencies.put(javaClass, annotation);
                    }

                    @Override
                    public void visitEnumConstant(String propertyName, JavaEnumConstant enumConstant) {
                        MemberDependenciesByTarget.this.annotationParameterTypeDependencies.put(enumConstant.getDeclaringClass(), annotation);
                    }

                    @Override
                    public void visitAnnotation(String propertyName, JavaAnnotation<?> memberAnnotation) {
                        MemberDependenciesByTarget.this.annotationParameterTypeDependencies.put(memberAnnotation.getRawType(), annotation);
                        memberAnnotation.accept(this);
                    }
                });
            }
        }

        Set<JavaField> getFieldsOfType(JavaClass javaClass) {
            return this.fieldTypeDependencies.get(javaClass);
        }

        Set<JavaMethod> getMethodsWithParameterOfType(JavaClass javaClass) {
            return this.methodParameterTypeDependencies.get(javaClass);
        }

        Set<JavaMethod> getMethodsWithReturnType(JavaClass javaClass) {
            return this.methodReturnTypeDependencies.get(javaClass);
        }

        Set<ThrowsDeclaration<JavaMethod>> getMethodThrowsDeclarationsOfType(JavaClass javaClass) {
            return this.methodsThrowsDeclarationDependencies.get(javaClass);
        }

        Set<JavaConstructor> getConstructorsWithParameterOfType(JavaClass javaClass) {
            return this.constructorParameterTypeDependencies.get(javaClass);
        }

        Set<ThrowsDeclaration<JavaConstructor>> getConstructorThrowsDeclarationsOfType(JavaClass javaClass) {
            return this.constructorThrowsDeclarationDependencies.get(javaClass);
        }

        Set<JavaAnnotation<?>> getAnnotationsOfType(JavaClass javaClass) {
            return this.annotationTypeDependencies.get(javaClass);
        }

        Set<JavaAnnotation<?>> getAnnotationsWithParameterOfType(JavaClass javaClass) {
            return this.annotationParameterTypeDependencies.get(javaClass);
        }
    }
}

