/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassFileImportRecord {
    private static final Logger LOG = LoggerFactory.getLogger(ClassFileImportRecord.class);
    private final Map<String, JavaClass> classes = new HashMap<String, JavaClass>();
    private final Map<String, String> superClassNamesByOwner = new HashMap<String, String>();
    private final SetMultimap<String, String> interfaceNamesByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaFieldBuilder> fieldBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaMethodBuilder> methodBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaConstructorBuilder> constructorBuildersByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaStaticInitializerBuilder> staticInitializerBuildersByOwner = new HashMap<String, DomainBuilders.JavaStaticInitializerBuilder>();
    private final SetMultimap<String, DomainBuilders.JavaAnnotationBuilder> annotationsByOwner = HashMultimap.create();
    private final EnclosingClassesByInnerClasses enclosingClassNamesByOwner = new EnclosingClassesByInnerClasses();
    private final Set<RawAccessRecord.ForField> rawFieldAccessRecords = new HashSet<RawAccessRecord.ForField>();
    private final Set<RawAccessRecord> rawMethodCallRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawConstructorCallRecords = new HashSet<RawAccessRecord>();

    ClassFileImportRecord() {
    }

    void setSuperClass(String ownerName, String superClassName) {
        Preconditions.checkState(!this.superClassNamesByOwner.containsKey(ownerName), "Attempted to add %s as a second superclass to %s, this is most likely a bug", (Object)superClassName, (Object)ownerName);
        this.superClassNamesByOwner.put(ownerName, superClassName);
    }

    void addInterfaces(String ownerName, Set<String> interfaceNames) {
        this.interfaceNamesByOwner.putAll(ownerName, interfaceNames);
    }

    void addField(String ownerName, DomainBuilders.JavaFieldBuilder fieldBuilder) {
        this.fieldBuildersByOwner.put(ownerName, fieldBuilder);
    }

    void addMethod(String ownerName, DomainBuilders.JavaMethodBuilder methodBuilder) {
        this.methodBuildersByOwner.put(ownerName, methodBuilder);
    }

    void addConstructor(String ownerName, DomainBuilders.JavaConstructorBuilder constructorBuilder) {
        this.constructorBuildersByOwner.put(ownerName, constructorBuilder);
    }

    void setStaticInitializer(String ownerName, DomainBuilders.JavaStaticInitializerBuilder builder) {
        Preconditions.checkState(!this.staticInitializerBuildersByOwner.containsKey(ownerName), "Tried to add a second static initializer to %s, this is most likely a bug", (Object)ownerName);
        this.staticInitializerBuildersByOwner.put(ownerName, builder);
    }

    void addAnnotations(String ownerName, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ownerName, annotations);
    }

    void setEnclosingClass(String ownerName, String enclosingClassName) {
        this.enclosingClassNamesByOwner.register(ownerName, enclosingClassName);
    }

    Optional<String> getSuperClassFor(String name) {
        return Optional.fromNullable(this.superClassNamesByOwner.get(name));
    }

    Set<String> getInterfaceNamesFor(String ownerName) {
        return this.interfaceNamesByOwner.get(ownerName);
    }

    Set<DomainBuilders.JavaFieldBuilder> getFieldBuildersFor(String ownerName) {
        return this.fieldBuildersByOwner.get(ownerName);
    }

    Set<DomainBuilders.JavaMethodBuilder> getMethodBuildersFor(String ownerName) {
        return this.methodBuildersByOwner.get(ownerName);
    }

    Set<DomainBuilders.JavaConstructorBuilder> getConstructorBuildersFor(String ownerName) {
        return this.constructorBuildersByOwner.get(ownerName);
    }

    Optional<DomainBuilders.JavaStaticInitializerBuilder> getStaticInitializerBuilderFor(String ownerName) {
        return Optional.fromNullable(this.staticInitializerBuildersByOwner.get(ownerName));
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(String ownerName) {
        return this.annotationsByOwner.get(ownerName);
    }

    Optional<String> getEnclosingClassFor(String ownerName) {
        return this.enclosingClassNamesByOwner.get(ownerName);
    }

    void registerFieldAccess(RawAccessRecord.ForField record) {
        this.rawFieldAccessRecords.add(record);
    }

    void registerMethodCall(RawAccessRecord record) {
        this.rawMethodCallRecords.add(record);
    }

    void registerConstructorCall(RawAccessRecord record) {
        this.rawConstructorCallRecords.add(record);
    }

    Set<RawAccessRecord.ForField> getRawFieldAccessRecords() {
        return ImmutableSet.copyOf(this.rawFieldAccessRecords);
    }

    Set<RawAccessRecord> getRawMethodCallRecords() {
        return ImmutableSet.copyOf(this.rawMethodCallRecords);
    }

    Set<RawAccessRecord> getRawConstructorCallRecords() {
        return ImmutableSet.copyOf(this.rawConstructorCallRecords);
    }

    void addAll(Collection<JavaClass> javaClasses) {
        for (JavaClass javaClass : javaClasses) {
            this.classes.put(javaClass.getName(), javaClass);
        }
    }

    Map<String, JavaClass> getClasses() {
        return this.classes;
    }

    Set<RawAccessRecord> getAccessRecords() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.rawFieldAccessRecords)).addAll(this.rawMethodCallRecords)).addAll(this.rawConstructorCallRecords)).build();
    }

    Map<String, String> getSuperClassNamesBySubClass() {
        return this.superClassNamesByOwner;
    }

    SetMultimap<String, String> getInterfaceNamesBySubInterface() {
        return this.interfaceNamesByOwner;
    }

    private static class EnclosingClassesByInnerClasses {
        private final Map<String, String> innerToOuter = new HashMap<String, String>();

        private EnclosingClassesByInnerClasses() {
        }

        void register(String innerName, String outerName) {
            if (this.registeringAllowed(innerName, outerName)) {
                this.innerToOuter.put(innerName, outerName);
            }
        }

        private boolean registeringAllowed(String innerName, String outerName) {
            boolean registeringAllowed;
            boolean bl = registeringAllowed = !this.innerToOuter.containsKey(innerName) || this.innerToOuter.get(innerName).equals(outerName);
            if (!registeringAllowed) {
                LOG.warn("Skipping registering outer class {} for inner class {}, since already outer class {} was registered", new Object[]{outerName, innerName, this.innerToOuter.get(innerName)});
            }
            return registeringAllowed;
        }

        public Optional<String> get(String ownerName) {
            return Optional.fromNullable(this.innerToOuter.get(ownerName));
        }
    }
}

