/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassList;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasDescriptor;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaTypeImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

interface AccessRecord<TARGET extends AccessTarget> {
    public JavaCodeUnit getCaller();

    public TARGET getTarget();

    public int getLineNumber();

    @Internal
    public static abstract class Factory<RAW_RECORD, PROCESSED_RECORD> {
        abstract PROCESSED_RECORD create(RAW_RECORD var1, ImportedClasses var2);

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorCallTarget>> forConstructorCallRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.ConstructorCallTarget>>(){

                @Override
                AccessRecord<AccessTarget.ConstructorCallTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawConstructorCallRecordProcessed(record, classes);
                }
            };
        }

        static Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodCallTarget>> forMethodCallRecord() {
            return new Factory<RawAccessRecord, AccessRecord<AccessTarget.MethodCallTarget>>(){

                @Override
                AccessRecord<AccessTarget.MethodCallTarget> create(RawAccessRecord record, ImportedClasses classes) {
                    return new RawMethodCallRecordProcessed(record, classes);
                }
            };
        }

        static Factory<RawAccessRecord.ForField, FieldAccessRecord> forFieldAccessRecord() {
            return new Factory<RawAccessRecord.ForField, FieldAccessRecord>(){

                @Override
                FieldAccessRecord create(RawAccessRecord.ForField record, ImportedClasses classes) {
                    return new RawFieldAccessRecordProcessed(record, classes);
                }
            };
        }

        private static Supplier<JavaCodeUnit> createCallerSupplier(final RawAccessRecord.CodeUnit caller, final ImportedClasses classes) {
            return Suppliers.memoize(new Supplier<JavaCodeUnit>(){

                @Override
                public JavaCodeUnit get() {
                    return Factory.getCaller(caller, classes);
                }
            });
        }

        private static JavaCodeUnit getCaller(RawAccessRecord.CodeUnit caller, ImportedClasses classes) {
            for (JavaCodeUnit method : classes.getOrResolve(caller.getDeclaringClassName()).getCodeUnits()) {
                if (!caller.is(method)) continue;
                return method;
            }
            throw new IllegalStateException("Never found a " + JavaCodeUnit.class.getSimpleName() + " that matches supposed caller " + caller);
        }

        private static <T extends HasName & HasDescriptor> Set<T> tryFindMatchingTargets(Set<T> possibleTargets, RawAccessRecord.TargetInfo targetInfo) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (HasName possibleTarget : possibleTargets) {
                if (!targetInfo.matches(possibleTarget)) continue;
                result.add(possibleTarget);
            }
            return result.build();
        }

        private static <T> Optional<T> uniqueTargetIn(Collection<T> collection) {
            return collection.size() == 1 ? Optional.of(Iterables.getOnlyElement(collection)) : Optional.absent();
        }

        private static JavaClassList getArgumentTypesFrom(String descriptor, ImportedClasses classes) {
            ArrayList<JavaClass> paramTypes = new ArrayList<JavaClass>();
            for (JavaType type : JavaTypeImporter.importAsmMethodArgumentTypes(descriptor)) {
                paramTypes.add(classes.getOrResolve(type.getName()));
            }
            return DomainObjectCreationContext.createJavaClassList(paramTypes);
        }

        private static class RawFieldAccessRecordProcessed
        implements FieldAccessRecord {
            private final RawAccessRecord.ForField record;
            final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final Supplier<JavaCodeUnit> callerSupplier;

            RawFieldAccessRecordProcessed(RawAccessRecord.ForField record, ImportedClasses classes) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getName());
                this.callerSupplier = Factory.createCallerSupplier(record.caller, classes);
            }

            @Override
            public JavaFieldAccess.AccessType getAccessType() {
                return this.record.accessType;
            }

            @Override
            public JavaCodeUnit getCaller() {
                return this.callerSupplier.get();
            }

            @Override
            public AccessTarget.FieldAccessTarget getTarget() {
                FieldTargetSupplier fieldSupplier = new FieldTargetSupplier(this.targetOwner.getAllFields(), this.record.target);
                JavaClass fieldType = this.classes.getOrResolve(JavaTypeImporter.importAsmType(this.record.target.desc).getName());
                return ((DomainBuilders.FieldAccessTargetBuilder)((DomainBuilders.FieldAccessTargetBuilder)new DomainBuilders.FieldAccessTargetBuilder().withOwner(this.targetOwner)).withName(this.record.target.name)).withType(fieldType).withField(fieldSupplier).build();
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            private static class FieldTargetSupplier
            implements Supplier<Optional<JavaField>> {
                private final Set<JavaField> allFields;
                private final RawAccessRecord.TargetInfo target;

                FieldTargetSupplier(Set<JavaField> allFields, RawAccessRecord.TargetInfo target) {
                    this.allFields = allFields;
                    this.target = target;
                }

                @Override
                public Optional<JavaField> get() {
                    return Factory.uniqueTargetIn(Factory.tryFindMatchingTargets(this.allFields, this.target));
                }
            }
        }

        private static class RawMethodCallRecordProcessed
        implements AccessRecord<AccessTarget.MethodCallTarget> {
            private final RawAccessRecord record;
            final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final Supplier<JavaCodeUnit> callerSupplier;

            RawMethodCallRecordProcessed(RawAccessRecord record, ImportedClasses classes) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getName());
                this.callerSupplier = Factory.createCallerSupplier(record.caller, classes);
            }

            @Override
            public JavaCodeUnit getCaller() {
                return this.callerSupplier.get();
            }

            @Override
            public AccessTarget.MethodCallTarget getTarget() {
                MethodTargetSupplier methodsSupplier = new MethodTargetSupplier(this.targetOwner.getAllMethods(), this.record.target);
                JavaClassList parameters = Factory.getArgumentTypesFrom(this.record.target.desc, this.classes);
                JavaClass returnType = this.classes.getOrResolve(JavaTypeImporter.importAsmMethodReturnType(this.record.target.desc).getName());
                return ((DomainBuilders.MethodCallTargetBuilder)((DomainBuilders.MethodCallTargetBuilder)((DomainBuilders.MethodCallTargetBuilder)((DomainBuilders.MethodCallTargetBuilder)new DomainBuilders.MethodCallTargetBuilder().withOwner(this.targetOwner)).withName(this.record.target.name)).withParameters(parameters)).withReturnType(returnType)).withMethods(methodsSupplier).build();
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            private static class MethodTargetSupplier
            implements Supplier<Set<JavaMethod>> {
                private final Set<JavaMethod> allMethods;
                private final RawAccessRecord.TargetInfo target;

                MethodTargetSupplier(Set<JavaMethod> allMethods, RawAccessRecord.TargetInfo target) {
                    this.allMethods = allMethods;
                    this.target = target;
                }

                @Override
                public Set<JavaMethod> get() {
                    return Factory.tryFindMatchingTargets(this.allMethods, this.target);
                }
            }
        }

        private static class RawConstructorCallRecordProcessed
        implements AccessRecord<AccessTarget.ConstructorCallTarget> {
            private final RawAccessRecord record;
            private final ImportedClasses classes;
            private final JavaClass targetOwner;
            private final Supplier<JavaCodeUnit> callerSupplier;

            RawConstructorCallRecordProcessed(RawAccessRecord record, ImportedClasses classes) {
                this.record = record;
                this.classes = classes;
                this.targetOwner = this.classes.getOrResolve(record.target.owner.getName());
                this.callerSupplier = Factory.createCallerSupplier(record.caller, classes);
            }

            @Override
            public JavaCodeUnit getCaller() {
                return this.callerSupplier.get();
            }

            @Override
            public AccessTarget.ConstructorCallTarget getTarget() {
                ConstructorTargetSupplier constructorSupplier = new ConstructorTargetSupplier(this.targetOwner, this.record.target);
                JavaClassList paramTypes = Factory.getArgumentTypesFrom(this.record.target.desc, this.classes);
                JavaClass returnType = this.classes.getOrResolve(Void.TYPE.getName());
                return ((DomainBuilders.ConstructorCallTargetBuilder)((DomainBuilders.ConstructorCallTargetBuilder)((DomainBuilders.ConstructorCallTargetBuilder)new DomainBuilders.ConstructorCallTargetBuilder().withOwner(this.targetOwner)).withParameters(paramTypes)).withReturnType(returnType)).withConstructor(constructorSupplier).build();
            }

            @Override
            public int getLineNumber() {
                return this.record.lineNumber;
            }

            private static class ConstructorTargetSupplier
            implements Supplier<Optional<JavaConstructor>> {
                private final JavaClass targetOwner;
                private final RawAccessRecord.TargetInfo target;

                ConstructorTargetSupplier(JavaClass targetOwner, RawAccessRecord.TargetInfo target) {
                    this.targetOwner = targetOwner;
                    this.target = target;
                }

                @Override
                public Optional<JavaConstructor> get() {
                    return Factory.uniqueTargetIn(Factory.tryFindMatchingTargets(this.targetOwner.getAllConstructors(), this.target));
                }
            }
        }
    }

    @Internal
    public static interface FieldAccessRecord
    extends AccessRecord<AccessTarget.FieldAccessTarget> {
        public JavaFieldAccess.AccessType getAccessType();
    }
}

