/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassList;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;

public interface HasThrowsClause<LOCATION extends HasParameterTypes & HasReturnType & CanBeAnnotated> {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ThrowsClause<? extends LOCATION> getThrowsClause();

    public static final class Predicates {
        private Predicates() {
        }

        @SafeVarargs
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClauseWithTypes(Class<? extends Throwable> ... types) {
            return Predicates.throwsClauseWithTypes(JavaClass.namesOf(types));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClauseWithTypes(String ... typeNames) {
            return Predicates.throwsClauseWithTypes(ImmutableList.copyOf(typeNames));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClauseWithTypes(List<String> typeNames) {
            return Predicates.throwsClause(DescribedPredicate.equalTo(typeNames).onResultOf(ThrowsClause.Functions.GET_TYPES.then(JavaClassList.GET_NAMES)).as("[%s]", Formatters.formatThrowsDeclarationTypeNames(typeNames)));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClauseContainingType(Class<? extends Throwable> type) {
            return Predicates.throwsClauseContainingType(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClauseContainingType(String typeName) {
            return Predicates.throwsClauseContainingType(HasName.Predicates.name(typeName).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClauseContainingType(DescribedPredicate<? super JavaClass> predicate) {
            DescribedPredicate declarationPredicate = HasType.Functions.GET_RAW_TYPE.is(predicate).forSubType();
            return Predicates.throwsClause(DescribedPredicate.anyElementThat(declarationPredicate)).as("throws clause containing type " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasThrowsClause<?>> throwsClause(DescribedPredicate<? super ThrowsClause<?>> predicate) {
            return new ThrowsTypesPredicate(predicate);
        }

        private static class ThrowsTypesPredicate
        extends DescribedPredicate<HasThrowsClause<?>> {
            private final DescribedPredicate<? super ThrowsClause<?>> predicate;

            ThrowsTypesPredicate(DescribedPredicate<? super ThrowsClause<?>> predicate) {
                super("throws types " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(HasThrowsClause<?> input) {
                return this.predicate.apply(input.getThrowsClause());
            }
        }
    }
}

