/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;

public interface HasParameterTypes {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClassList getRawParameterTypes();

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(Class<?> ... types) {
            return Predicates.rawParameterTypes(JavaClass.namesOf(types));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(String ... types) {
            return Predicates.rawParameterTypes(ImmutableList.copyOf(types));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(List<String> typeNames) {
            return new RawParameterTypesPredicate(DescribedPredicate.equalTo(typeNames).onResultOf(JavaClassList.GET_NAMES).as("[%s]", Formatters.formatMethodParameterTypeNames(typeNames)));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(DescribedPredicate<? super List<JavaClass>> predicate) {
            return new RawParameterTypesPredicate(predicate);
        }

        private static class RawParameterTypesPredicate
        extends DescribedPredicate<HasParameterTypes> {
            private final DescribedPredicate<? super JavaClassList> predicate;

            RawParameterTypesPredicate(DescribedPredicate<? super JavaClassList> predicate) {
                super("raw parameter types " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(HasParameterTypes input) {
                return this.predicate.apply(input.getRawParameterTypes());
            }
        }
    }
}

