/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import java.util.regex.Pattern;

public interface HasName {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName();

    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<HasName, String> GET_NAME = new ChainableFunction<HasName, String>(){

            @Override
            public String apply(HasName input) {
                return input.getName();
            }
        };

        private Functions() {
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> name(String name) {
            return new NameEqualsPredicate(name);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasName> nameMatching(String regex) {
            return new NameMatchingPredicate(regex);
        }

        private static class NameMatchingPredicate
        extends DescribedPredicate<HasName> {
            private final Pattern pattern;

            NameMatchingPredicate(String regex) {
                super(String.format("name matching '%s'", regex), new Object[0]);
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public boolean apply(HasName input) {
                return this.pattern.matcher(input.getName()).matches();
            }
        }

        private static class NameEqualsPredicate
        extends DescribedPredicate<HasName> {
            private final String name;

            NameEqualsPredicate(String name) {
                super(String.format("name '%s'", name), new Object[0]);
                this.name = name;
            }

            @Override
            public boolean apply(HasName input) {
                return input.getName().equals(this.name);
            }
        }
    }

    public static interface AndFullName
    extends HasName {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getFullName();

        public static final class Functions {
            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static final ChainableFunction<AndFullName, String> GET_FULL_NAME = new ChainableFunction<AndFullName, String>(){

                @Override
                public String apply(AndFullName input) {
                    return input.getFullName();
                }
            };

            private Functions() {
            }
        }

        public static final class Predicates {
            private Predicates() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static DescribedPredicate<AndFullName> fullName(String fullName) {
                return new FullNameEqualsPredicate(fullName);
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static DescribedPredicate<AndFullName> fullNameMatching(String regex) {
                return new FullNameMatchingPredicate(regex);
            }

            private static class FullNameMatchingPredicate
            extends DescribedPredicate<AndFullName> {
                private final Pattern pattern;

                FullNameMatchingPredicate(String regex) {
                    super(String.format("full name matching '%s'", regex), new Object[0]);
                    this.pattern = Pattern.compile(regex);
                }

                @Override
                public boolean apply(AndFullName input) {
                    return this.pattern.matcher(input.getFullName()).matches();
                }
            }

            private static class FullNameEqualsPredicate
            extends DescribedPredicate<AndFullName> {
                private final String fullName;

                FullNameEqualsPredicate(String fullName) {
                    super(String.format("full name '%s'", fullName), new Object[0]);
                    this.fullName = fullName;
                }

                @Override
                public boolean apply(AndFullName input) {
                    return input.getFullName().equals(this.fullName);
                }
            }
        }
    }
}

