/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasType;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;

public interface CanBeAnnotated {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> var1);

    public static final class Utils {
        private Utils() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static boolean isAnnotatedWith(Collection<? extends JavaAnnotation<?>> annotations, DescribedPredicate<? super JavaAnnotation<?>> predicate) {
            for (JavaAnnotation<?> annotation : annotations) {
                if (!predicate.apply(annotation)) continue;
                return true;
            }
            return false;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static boolean isMetaAnnotatedWith(Collection<? extends JavaAnnotation<?>> annotations, DescribedPredicate<? super JavaAnnotation<?>> predicate) {
            for (JavaAnnotation<?> annotation : annotations) {
                if (!annotation.getRawType().isAnnotatedWith(predicate) && !annotation.getRawType().isMetaAnnotatedWith(predicate)) continue;
                return true;
            }
            return false;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static <A extends Annotation> Function<JavaAnnotation<?>, A> toAnnotationOfType(final Class<A> type) {
            return new Function<JavaAnnotation<?>, A>(){

                @Override
                public A apply(JavaAnnotation<?> input) {
                    return input.as(type);
                }
            };
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<CanBeAnnotated> annotatedWith(Class<? extends Annotation> annotationType) {
            Predicates.checkAnnotationHasReasonableRetention(annotationType);
            return Predicates.annotatedWith(annotationType.getName());
        }

        private static void checkAnnotationHasReasonableRetention(Class<? extends Annotation> annotationType) {
            if (Predicates.isRetentionSource(annotationType)) {
                throw new ArchUnitException.InvalidSyntaxUsageException(String.format("Annotation type %s has @%s(%s), thus the information is gone after compile. So checking this with ArchUnit is useless.", new Object[]{annotationType.getName(), Retention.class.getSimpleName(), RetentionPolicy.SOURCE}));
            }
        }

        private static boolean isRetentionSource(Class<? extends Annotation> annotationType) {
            return annotationType.getAnnotation(Retention.class) != null && annotationType.getAnnotation(Retention.class).value() == RetentionPolicy.SOURCE;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<CanBeAnnotated> annotatedWith(String annotationTypeName) {
            DescribedPredicate<HasType> typeNameMatches = HasType.Functions.GET_RAW_TYPE.then(HasName.Functions.GET_NAME).is(DescribedPredicate.equalTo(annotationTypeName));
            return Predicates.annotatedWith(typeNameMatches.as("@" + Formatters.ensureSimpleName(annotationTypeName), new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<CanBeAnnotated> annotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
            return new AnnotatedPredicate(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<CanBeAnnotated> metaAnnotatedWith(Class<? extends Annotation> annotationType) {
            Predicates.checkAnnotationHasReasonableRetention(annotationType);
            return Predicates.metaAnnotatedWith(annotationType.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<CanBeAnnotated> metaAnnotatedWith(String annotationTypeName) {
            DescribedPredicate<HasType> typeNameMatches = HasType.Functions.GET_RAW_TYPE.then(HasName.Functions.GET_NAME).is(DescribedPredicate.equalTo(annotationTypeName));
            return Predicates.metaAnnotatedWith(typeNameMatches.as("@" + Formatters.ensureSimpleName(annotationTypeName), new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<CanBeAnnotated> metaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
            return new MetaAnnotatedPredicate(predicate);
        }

        private static class MetaAnnotatedPredicate
        extends DescribedPredicate<CanBeAnnotated> {
            private final DescribedPredicate<? super JavaAnnotation<?>> predicate;

            MetaAnnotatedPredicate(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
                super("meta-annotated with " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(CanBeAnnotated input) {
                return input.isMetaAnnotatedWith(this.predicate);
            }
        }

        private static class AnnotatedPredicate
        extends DescribedPredicate<CanBeAnnotated> {
            private final DescribedPredicate<? super JavaAnnotation<?>> predicate;

            AnnotatedPredicate(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
                super("annotated with " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(CanBeAnnotated input) {
                return input.isAnnotatedWith(this.predicate);
            }
        }
    }
}

