/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Objects;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class SourceCodeLocation {
    private static final String LOCATION_TEMPLATE = "(%s:%d)";
    private final JavaClass sourceClass;
    private final int lineNumber;
    private final String description;

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static SourceCodeLocation of(JavaClass sourceClass) {
        return new SourceCodeLocation(sourceClass, 0);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static SourceCodeLocation of(JavaClass sourceClass, int lineNumber) {
        return new SourceCodeLocation(sourceClass, lineNumber);
    }

    private static String formatLocation(JavaClass sourceClass, int lineNumber) {
        Optional recordedSourceFileName = sourceClass.getSource().isPresent() ? sourceClass.getSource().get().getFileName() : Optional.absent();
        String sourceFileName = recordedSourceFileName.isPresent() ? (String)recordedSourceFileName.get() : SourceCodeLocation.guessSourceFileName(sourceClass);
        return String.format(LOCATION_TEMPLATE, sourceFileName, lineNumber);
    }

    private static String guessSourceFileName(JavaClass location) {
        while (location.getEnclosingClass().isPresent()) {
            location = location.getEnclosingClass().get();
        }
        return location.getSimpleName() + ".java";
    }

    private SourceCodeLocation(JavaClass sourceClass, int lineNumber) {
        this.sourceClass = Preconditions.checkNotNull(sourceClass);
        this.lineNumber = lineNumber;
        Preconditions.checkArgument(lineNumber >= 0, "Line number must be non-negative but was " + lineNumber);
        this.description = SourceCodeLocation.formatLocation(sourceClass, lineNumber);
    }

    public int hashCode() {
        return Objects.hash(this.sourceClass, this.lineNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceCodeLocation other = (SourceCodeLocation)obj;
        return Objects.equals(this.sourceClass, other.sourceClass) && Objects.equals(this.lineNumber, other.lineNumber);
    }

    public String toString() {
        return this.description;
    }
}

