/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.ResolvesTypesViaReflection;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.base.CharMatcher;
import com.tngtech.archunit.thirdparty.com.google.common.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheLoader;
import com.tngtech.archunit.thirdparty.com.google.common.cache.LoadingCache;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableBiMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Maps;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Primitives;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Type;
import java.util.Map;
import java.util.Objects;

@Internal
public interface JavaType {
    public String getName();

    public String getSimpleName();

    public String getPackageName();

    @ResolvesTypesViaReflection
    public Class<?> resolveClass();

    @ResolvesTypesViaReflection
    public Class<?> resolveClass(ClassLoader var1);

    public Optional<JavaType> tryGetComponentType();

    public boolean isPrimitive();

    public boolean isArray();

    public JavaType withSimpleName(String var1);

    @Internal
    public static final class From {
        private static final LoadingCache<String, JavaType> typeCache = CacheBuilder.newBuilder().build(new CacheLoader<String, JavaType>(){

            @Override
            public JavaType load(String typeName) {
                if (primitiveClassesByNameOrDescriptor.containsKey(typeName)) {
                    return new PrimitiveType(Type.getType((Class)primitiveClassesByNameOrDescriptor.get(typeName)).getClassName());
                }
                if (From.isArray(typeName)) {
                    return new ArrayType(From.ensureCorrectArrayTypeName(typeName));
                }
                return new ObjectType(typeName);
            }
        });
        private static final ImmutableMap<String, Class<?>> primitiveClassesByName = Maps.uniqueIndex(Primitives.allPrimitiveTypes(), new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> input) {
                return input.getName();
            }
        });
        private static final ImmutableBiMap<String, Class<?>> primitiveClassesByDescriptor = ImmutableBiMap.copyOf(Maps.uniqueIndex(Primitives.allPrimitiveTypes(), new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> input) {
                return Type.getType(input).getDescriptor();
            }
        }));
        private static final Map<String, Class<?>> primitiveClassesByNameOrDescriptor = ImmutableMap.builder().putAll(primitiveClassesByName).putAll(primitiveClassesByDescriptor).build();

        public static JavaType name(String typeName) {
            return typeCache.getUnchecked(typeName);
        }

        private static boolean isArray(String typeName) {
            return typeName.startsWith("[") || typeName.endsWith("]");
        }

        private static String ensureCorrectArrayTypeName(String name) {
            return name.endsWith("[]") ? From.convertCanonicalArrayNameToClassName(name) : name;
        }

        private static String convertCanonicalArrayNameToClassName(String name) {
            String arrayDesignator = Strings.repeat("[", CharMatcher.is('[').countIn(name));
            return arrayDesignator + From.createComponentTypeName(name);
        }

        private static String createComponentTypeName(String name) {
            String baseName = name.substring(0, name.indexOf("[]"));
            return primitiveClassesByName.containsKey(baseName) ? From.createPrimitiveComponentType(baseName) : From.createObjectComponentType(baseName);
        }

        private static String createPrimitiveComponentType(String componentTypeName) {
            return (String)((ImmutableMap)((Object)primitiveClassesByDescriptor.inverse())).get(primitiveClassesByName.get(componentTypeName));
        }

        private static String createObjectComponentType(String componentTypeName) {
            return "L" + componentTypeName + ";";
        }

        static JavaType javaClass(JavaClass javaClass) {
            return From.name(javaClass.getName());
        }

        private static String createPackage(String fullName) {
            int packageEnd = fullName.lastIndexOf(46);
            return packageEnd >= 0 ? fullName.substring(0, packageEnd) : "";
        }

        private static class ArrayType
        extends AbstractType {
            ArrayType(String fullName) {
                this(fullName, ArrayType.createSimpleName(fullName), ArrayType.createPackageOfComponentType(fullName));
            }

            private ArrayType(String fullName, String simpleName, String packageName) {
                super(fullName, simpleName, packageName);
            }

            private static String createPackageOfComponentType(String fullName) {
                String componentType = ArrayType.getCanonicalName(fullName).replace("[]", "");
                return From.createPackage(componentType);
            }

            private static String createSimpleName(String fullName) {
                return Formatters.ensureSimpleName(ArrayType.getCanonicalName(fullName));
            }

            private static String getCanonicalName(String fullName) {
                return Type.getType(fullName).getClassName();
            }

            @Override
            public boolean isArray() {
                return true;
            }

            @Override
            public JavaType withSimpleName(String simpleName) {
                return new ArrayType(this.getName(), simpleName, this.getPackageName());
            }

            @Override
            public Optional<JavaType> tryGetComponentType() {
                String canonicalName = ArrayType.getCanonicalName(this.getName());
                String componentTypeName = canonicalName.substring(0, canonicalName.lastIndexOf("["));
                return Optional.of(From.name(componentTypeName));
            }
        }

        private static class PrimitiveType
        extends AbstractType {
            PrimitiveType(String fullName) {
                super(fullName, fullName, "");
                Preconditions.checkArgument(primitiveClassesByName.containsKey(fullName), "'%s' must be a primitive name", (Object)fullName);
            }

            @Override
            Class<?> classForName(ClassLoader classLoader) {
                return (Class)primitiveClassesByName.get(this.getName());
            }

            @Override
            public boolean isPrimitive() {
                return true;
            }

            @Override
            public JavaType withSimpleName(String simpleName) {
                throw new UnsupportedOperationException("It should never make sense to override the simple type of a primitive");
            }
        }

        private static class ObjectType
        extends AbstractType {
            ObjectType(String fullName) {
                this(fullName, Formatters.ensureSimpleName(fullName), From.createPackage(fullName));
            }

            private ObjectType(String fullName, String simpleName, String packageName) {
                super(fullName, simpleName, packageName);
            }

            @Override
            public JavaType withSimpleName(String simpleName) {
                return new ObjectType(this.getName(), simpleName, this.getPackageName());
            }
        }

        private static abstract class AbstractType
        implements JavaType {
            private final String name;
            private final String simpleName;
            private final String javaPackage;

            private AbstractType(String name, String simpleName, String javaPackage) {
                this.name = name;
                this.simpleName = simpleName;
                this.javaPackage = javaPackage;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getSimpleName() {
                return this.simpleName;
            }

            @Override
            public String getPackageName() {
                return this.javaPackage;
            }

            @Override
            public Class<?> resolveClass() {
                return this.resolveClass(ClassLoaders.getCurrentClassLoader(this.getClass()));
            }

            @Override
            public Class<?> resolveClass(ClassLoader classLoader) {
                try {
                    return this.classForName(classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new ArchUnitException.ReflectionException(e);
                }
            }

            @MayResolveTypesViaReflection(reason="This method is one of the known sources for resolving via reflection")
            Class<?> classForName(ClassLoader classLoader) throws ClassNotFoundException {
                return Class.forName(this.getName(), false, classLoader);
            }

            @Override
            public Optional<JavaType> tryGetComponentType() {
                return Optional.absent();
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.getName());
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                JavaType other = (JavaType)obj;
                return Objects.equals(this.getName(), other.getName());
            }

            public String toString() {
                return this.getClass().getSimpleName() + "{" + this.getName() + "}";
            }
        }
    }
}

