/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.ResolvesTypesViaReflection;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

public class JavaMethod
extends JavaCodeUnit {
    private final Supplier<Method> methodSupplier;
    private final ThrowsClause<JavaMethod> throwsClause;
    private Supplier<Set<JavaMethodCall>> callsToSelf = Suppliers.ofInstance(Collections.emptySet());
    private final Supplier<Optional<Object>> annotationDefaultValue;

    JavaMethod(DomainBuilders.JavaMethodBuilder builder) {
        super(builder);
        this.throwsClause = builder.getThrowsClause(this);
        this.methodSupplier = Suppliers.memoize(new ReflectMethodSupplier());
        this.annotationDefaultValue = builder.getAnnotationDefaultValue();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ThrowsClause<JavaMethod> getThrowsClause() {
        return this.throwsClause;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<Object> getDefaultValue() {
        return this.annotationDefaultValue.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getCallsOfSelf() {
        return this.getAccessesToSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getAccessesToSelf() {
        return this.callsToSelf.get();
    }

    @Override
    public Set<JavaAnnotation<JavaMethod>> getAnnotations() {
        return super.getAnnotations();
    }

    @Override
    public JavaAnnotation<JavaMethod> getAnnotationOfType(String typeName) {
        return super.getAnnotationOfType(typeName);
    }

    @Override
    public Optional<JavaAnnotation<JavaMethod>> tryGetAnnotationOfType(String typeName) {
        return super.tryGetAnnotationOfType(typeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="This is not part of the import and a specific decision to rely on the classpath")
    public Method reflect() {
        return this.methodSupplier.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return "Method <" + this.getFullName() + ">";
    }

    void registerCallsToMethod(Supplier<Set<JavaMethodCall>> calls) {
        this.callsToSelf = Preconditions.checkNotNull(calls);
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    private class ReflectMethodSupplier
    implements Supplier<Method> {
        private ReflectMethodSupplier() {
        }

        @Override
        public Method get() {
            Class<?> reflectedOwner = JavaMethod.this.getOwner().reflect();
            try {
                return reflectedOwner.getDeclaredMethod(JavaMethod.this.getName(), JavaCodeUnit.reflect(JavaMethod.this.getRawParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                throw new ArchUnitException.InconsistentClassPathException("Can't resolve method " + Formatters.formatMethod(reflectedOwner.getName(), JavaMethod.this.getName(), JavaMethod.this.getRawParameterTypes()), e);
            }
        }
    }
}

