/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasDescriptor;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Set;

public abstract class JavaMember
implements HasName.AndFullName,
HasDescriptor,
HasAnnotations<JavaMember>,
HasModifiers,
HasOwner<JavaClass>,
HasSourceCodeLocation {
    private final String name;
    private final String descriptor;
    private final Supplier<Map<String, JavaAnnotation<JavaMember>>> annotations;
    private final JavaClass owner;
    private final SourceCodeLocation sourceCodeLocation;
    private final Set<JavaModifier> modifiers;

    JavaMember(DomainBuilders.JavaMemberBuilder<?, ?> builder) {
        this.name = Preconditions.checkNotNull(builder.getName());
        this.descriptor = Preconditions.checkNotNull(builder.getDescriptor());
        this.annotations = builder.getAnnotations(this);
        this.owner = Preconditions.checkNotNull(builder.getOwner());
        this.sourceCodeLocation = SourceCodeLocation.of(this.owner, builder.getFirstLineNumber());
        this.modifiers = Preconditions.checkNotNull(builder.getModifiers());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<? extends JavaAnnotation<? extends JavaMember>> getAnnotations() {
        return ImmutableSet.copyOf(this.annotations.get().values());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> A getAnnotationOfType(Class<A> type) {
        return this.getAnnotationOfType(type.getName()).as(type);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaAnnotation<? extends JavaMember> getAnnotationOfType(String typeName) {
        return this.tryGetAnnotationOfType(typeName).getOrThrow(new IllegalArgumentException(String.format("Member %s is not annotated with @%s", this.getFullName(), typeName)));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> Optional<A> tryGetAnnotationOfType(Class<A> type) {
        return this.tryGetAnnotationOfType(type.getName()).transform(CanBeAnnotated.Utils.toAnnotationOfType(type));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<? extends JavaAnnotation<? extends JavaMember>> tryGetAnnotationOfType(String typeName) {
        return Optional.fromNullable(this.annotations.get().get(typeName));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> type) {
        return this.isAnnotatedWith(type.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String typeName) {
        return this.annotations.get().containsKey(typeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isAnnotatedWith(this.annotations.get().values(), predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> type) {
        return this.isMetaAnnotatedWith(type.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String typeName) {
        return this.isMetaAnnotatedWith(HasType.Functions.GET_RAW_TYPE.then(HasName.Functions.GET_NAME).is(DescribedPredicate.equalTo(typeName)));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isMetaAnnotatedWith(this.annotations.get().values(), predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOwner() {
        return this.owner;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.name;
    }

    @Override
    @Internal
    public String getDescriptor() {
        return this.descriptor;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Set<? extends JavaAccess<?>> getAccessesToSelf();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Member reflect();

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.getFullName() + '}';
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaMember> declaredIn(Class<?> clazz) {
            return Predicates.declaredIn(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaMember> declaredIn(String className) {
            return Predicates.declaredIn(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(className)).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaMember> declaredIn(DescribedPredicate<? super JavaClass> predicate) {
            return HasOwner.Functions.Get.owner().is(predicate).as("declared in %s", predicate.getDescription()).forSubType();
        }
    }
}

