/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Objects;

public final class JavaEnumConstant {
    private final JavaClass declaringClass;
    private final String name;

    JavaEnumConstant(DomainBuilders.JavaEnumConstantBuilder builder) {
        this(builder.getDeclaringClass(), builder.getName());
    }

    JavaEnumConstant(JavaClass declaringClass, String name) {
        this.declaringClass = Preconditions.checkNotNull(declaringClass);
        this.name = Preconditions.checkNotNull(name);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getDeclaringClass() {
        return this.declaringClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String name() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.declaringClass, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaEnumConstant other = (JavaEnumConstant)obj;
        return Objects.equals(this.declaringClass, other.declaringClass) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.declaringClass.getSimpleName() + "." + this.name;
    }
}

