/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.ResolvesTypesViaReflection;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassList;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasThrowsClause;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public abstract class JavaCodeUnit
extends JavaMember
implements HasParameterTypes,
HasReturnType,
HasThrowsClause<JavaCodeUnit> {
    private final JavaClass returnType;
    private final JavaClassList parameters;
    private final String fullName;
    private Set<JavaFieldAccess> fieldAccesses = Collections.emptySet();
    private Set<JavaMethodCall> methodCalls = Collections.emptySet();
    private Set<JavaConstructorCall> constructorCalls = Collections.emptySet();

    JavaCodeUnit(DomainBuilders.JavaCodeUnitBuilder<?, ?> builder) {
        super(builder);
        this.returnType = builder.getReturnType();
        this.parameters = builder.getParameters();
        this.fullName = Formatters.formatMethod(this.getOwner().getName(), this.getName(), this.getRawParameterTypes());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClassList getRawParameterTypes() {
        return this.parameters;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract ThrowsClause<? extends JavaCodeUnit> getThrowsClause();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClassList getExceptionTypes() {
        return this.getThrowsClause().getTypes();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawReturnType() {
        return this.returnType;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getFieldAccesses() {
        return this.fieldAccesses;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getMethodCallsFromSelf() {
        return this.methodCalls;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getConstructorCallsFromSelf() {
        return this.constructorCalls;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCall<?>> getCallsFromSelf() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getMethodCallsFromSelf())).addAll(this.getConstructorCallsFromSelf())).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesFromSelf() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getCallsFromSelf())).addAll(this.getFieldAccesses())).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isConstructor() {
        return false;
    }

    @Override
    public Set<? extends JavaAnnotation<? extends JavaCodeUnit>> getAnnotations() {
        return super.getAnnotations();
    }

    @Override
    public JavaAnnotation<? extends JavaCodeUnit> getAnnotationOfType(String typeName) {
        return super.getAnnotationOfType(typeName);
    }

    @Override
    public Optional<? extends JavaAnnotation<? extends JavaCodeUnit>> tryGetAnnotationOfType(String typeName) {
        return super.tryGetAnnotationOfType(typeName);
    }

    DomainObjectCreationContext.AccessContext.Part completeFrom(ImportContext context) {
        this.fieldAccesses = context.getFieldAccessesFor(this);
        this.methodCalls = context.getMethodCallsFor(this);
        this.constructorCalls = context.getConstructorCallsFor(this);
        return new DomainObjectCreationContext.AccessContext.Part(this);
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    static Class<?>[] reflect(JavaClassList parameters) {
        ArrayList result = new ArrayList();
        for (JavaClass parameter : parameters) {
            result.add(parameter.reflect());
        }
        return result.toArray(new Class[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        private Functions() {
        }

        public static final class Get {
            private Get() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static <T extends JavaCodeUnit> ChainableFunction<T, ThrowsClause<T>> throwsClause() {
                return new ChainableFunction<T, ThrowsClause<T>>(){

                    @Override
                    public ThrowsClause<T> apply(T input) {
                        return ((JavaCodeUnit)input).getThrowsClause();
                    }
                };
            }
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaCodeUnit> constructor() {
            return new DescribedPredicate<JavaCodeUnit>("constructor", new Object[0]){

                @Override
                public boolean apply(JavaCodeUnit input) {
                    return input.isConstructor();
                }
            };
        }
    }
}

