/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

class JavaClassDependencies {
    private final JavaClass javaClass;
    private final Set<JavaField> fieldsWithTypeOfClass;
    private final Set<JavaMethod> methodsWithParameterTypeOfClass;
    private final Set<JavaMethod> methodsWithReturnTypeOfClass;
    private final Set<ThrowsDeclaration<JavaMethod>> methodsWithThrowsDeclarationTypeOfClass;
    private final Set<JavaConstructor> constructorsWithParameterTypeOfClass;
    private final Set<ThrowsDeclaration<JavaConstructor>> constructorsWithThrowsDeclarationTypeOfClass;
    private final Set<JavaAnnotation<?>> annotationsWithTypeOfClass;
    private final Set<JavaAnnotation<?>> annotationsWithParameterTypeOfClass;
    private final Supplier<Set<Dependency>> directDependenciesFromClass;
    private final Supplier<Set<Dependency>> directDependenciesToClass;

    JavaClassDependencies(JavaClass javaClass, ImportContext context) {
        this.javaClass = javaClass;
        this.fieldsWithTypeOfClass = context.getFieldsOfType(javaClass);
        this.methodsWithParameterTypeOfClass = context.getMethodsWithParameterOfType(javaClass);
        this.methodsWithReturnTypeOfClass = context.getMethodsWithReturnType(javaClass);
        this.methodsWithThrowsDeclarationTypeOfClass = context.getMethodThrowsDeclarationsOfType(javaClass);
        this.constructorsWithParameterTypeOfClass = context.getConstructorsWithParameterOfType(javaClass);
        this.constructorsWithThrowsDeclarationTypeOfClass = context.getConstructorThrowsDeclarationsOfType(javaClass);
        this.annotationsWithTypeOfClass = context.getAnnotationsOfType(javaClass);
        this.annotationsWithParameterTypeOfClass = context.getAnnotationsWithParameterOfType(javaClass);
        this.directDependenciesFromClass = this.getDirectDependenciesFromClassSupplier();
        this.directDependenciesToClass = this.getDirectDependenciesToClassSupplier();
    }

    private Supplier<Set<Dependency>> getDirectDependenciesFromClassSupplier() {
        return Suppliers.memoize(new Supplier<Set<Dependency>>(){

            @Override
            public Set<Dependency> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                result.addAll((Iterable)JavaClassDependencies.this.dependenciesFromAccesses(JavaClassDependencies.this.javaClass.getAccessesFromSelf()));
                result.addAll((Iterable)JavaClassDependencies.this.inheritanceDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.fieldDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.returnTypeDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.methodParameterDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.throwsDeclarationDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.constructorParameterDependenciesFromSelf());
                result.addAll((Iterable)JavaClassDependencies.this.annotationDependenciesFromSelf());
                return result.build();
            }
        });
    }

    private Supplier<Set<Dependency>> getDirectDependenciesToClassSupplier() {
        return Suppliers.memoize(new Supplier<Set<Dependency>>(){

            @Override
            public Set<Dependency> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                result.addAll((Iterable)JavaClassDependencies.this.dependenciesFromAccesses(JavaClassDependencies.this.javaClass.getAccessesToSelf()));
                result.addAll((Iterable)JavaClassDependencies.this.inheritanceDependenciesToSelf());
                result.addAll((Iterable)JavaClassDependencies.this.fieldDependenciesToSelf());
                result.addAll((Iterable)JavaClassDependencies.this.returnTypeDependenciesToSelf());
                result.addAll((Iterable)JavaClassDependencies.this.methodParameterDependenciesToSelf());
                result.addAll((Iterable)JavaClassDependencies.this.throwsDeclarationDependenciesToSelf());
                result.addAll((Iterable)JavaClassDependencies.this.constructorParameterDependenciesToSelf());
                result.addAll(JavaClassDependencies.this.annotationDependenciesToSelf());
                return result.build();
            }
        });
    }

    Set<Dependency> getDirectDependenciesFromClass() {
        return this.directDependenciesFromClass.get();
    }

    Set<Dependency> getDirectDependenciesToClass() {
        return this.directDependenciesToClass.get();
    }

    Set<JavaField> getFieldsWithTypeOfClass() {
        return this.fieldsWithTypeOfClass;
    }

    Set<JavaMethod> getMethodsWithParameterTypeOfClass() {
        return this.methodsWithParameterTypeOfClass;
    }

    Set<JavaMethod> getMethodsWithReturnTypeOfClass() {
        return this.methodsWithReturnTypeOfClass;
    }

    Set<ThrowsDeclaration<JavaMethod>> getMethodThrowsDeclarationsWithTypeOfClass() {
        return this.methodsWithThrowsDeclarationTypeOfClass;
    }

    Set<JavaConstructor> getConstructorsWithParameterTypeOfClass() {
        return this.constructorsWithParameterTypeOfClass;
    }

    Set<ThrowsDeclaration<JavaConstructor>> getConstructorsWithThrowsDeclarationTypeOfClass() {
        return this.constructorsWithThrowsDeclarationTypeOfClass;
    }

    private Set<ThrowsDeclaration<? extends JavaCodeUnit>> getThrowsDeclarationsWithTypeOfClass() {
        return Sets.union(this.methodsWithThrowsDeclarationTypeOfClass, this.constructorsWithThrowsDeclarationTypeOfClass);
    }

    Set<JavaAnnotation<?>> getAnnotationsWithTypeOfClass() {
        return this.annotationsWithTypeOfClass;
    }

    private Set<Dependency> dependenciesFromAccesses(Set<JavaAccess<?>> accesses) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaAccess<?> access : accesses) {
            result.addAll(Dependency.tryCreateFromAccess(access).asSet());
        }
        return result.build();
    }

    private Set<Dependency> inheritanceDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass superType : FluentIterable.from(this.javaClass.getInterfaces()).append((Iterable<JavaClass>)this.javaClass.getSuperClass().asSet())) {
            result.add(Dependency.fromInheritance(this.javaClass, superType));
        }
        return result.build();
    }

    private Set<Dependency> fieldDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaField field : this.javaClass.getFields()) {
            result.addAll(Dependency.tryCreateFromField(field).asSet());
        }
        return result.build();
    }

    private Set<Dependency> returnTypeDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaMethod method : this.javaClass.getMethods()) {
            result.addAll(Dependency.tryCreateFromReturnType(method).asSet());
        }
        return result.build();
    }

    private Set<Dependency> methodParameterDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaMethod method : this.javaClass.getMethods()) {
            for (JavaClass parameter : method.getRawParameterTypes()) {
                result.addAll(Dependency.tryCreateFromParameter(method, parameter).asSet());
            }
        }
        return result.build();
    }

    private Set<Dependency> throwsDeclarationDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.javaClass.getCodeUnits()) {
            for (ThrowsDeclaration<? extends JavaCodeUnit> throwsDeclaration : codeUnit.getThrowsClause()) {
                result.addAll(Dependency.tryCreateFromThrowsDeclaration(throwsDeclaration).asSet());
            }
        }
        return result.build();
    }

    private Set<Dependency> constructorParameterDependenciesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaConstructor constructor : this.javaClass.getConstructors()) {
            for (JavaClass parameter : constructor.getRawParameterTypes()) {
                result.addAll(Dependency.tryCreateFromParameter(constructor, parameter).asSet());
            }
        }
        return result.build();
    }

    private Set<Dependency> annotationDependenciesFromSelf() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll(this.annotationDependencies(this.javaClass))).addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getFields()))).addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getMethods()))).addAll(this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getConstructors()))).build();
    }

    private <T extends HasDescription & HasAnnotations<?>> Set<Dependency> annotationDependencies(Set<T> annotatedObjects) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (HasDescription annotated : annotatedObjects) {
            result.addAll(this.annotationDependencies(annotated));
        }
        return result.build();
    }

    private <T extends HasDescription & HasAnnotations<?>> Set<Dependency> annotationDependencies(T annotated) {
        final ImmutableSet.Builder result = ImmutableSet.builder();
        for (final JavaAnnotation<?> annotation : ((HasAnnotations<?>)annotated).getAnnotations()) {
            result.addAll(Dependency.tryCreateFromAnnotation(annotation).asSet());
            annotation.accept(new JavaAnnotation.DefaultParameterVisitor(){

                @Override
                public void visitClass(String propertyName, JavaClass javaClass) {
                    result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, javaClass).asSet());
                }

                @Override
                public void visitEnumConstant(String propertyName, JavaEnumConstant enumConstant) {
                    result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, enumConstant.getDeclaringClass()).asSet());
                }

                @Override
                public void visitAnnotation(String propertyName, JavaAnnotation<?> memberAnnotation) {
                    result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, memberAnnotation.getRawType()).asSet());
                    memberAnnotation.accept(this);
                }
            });
        }
        return result.build();
    }

    private Set<Dependency> inheritanceDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (JavaClass subClass : this.javaClass.getSubClasses()) {
            result.add(Dependency.fromInheritance(subClass, this.javaClass));
        }
        return result;
    }

    private Set<Dependency> fieldDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (JavaField field : this.javaClass.getFieldsWithTypeOfSelf()) {
            result.addAll(Dependency.tryCreateFromField(field).asSet());
        }
        return result;
    }

    private Set<Dependency> returnTypeDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (JavaMethod method : this.javaClass.getMethodsWithReturnTypeOfSelf()) {
            result.addAll(Dependency.tryCreateFromReturnType(method).asSet());
        }
        return result;
    }

    private Set<Dependency> methodParameterDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (JavaMethod method : this.javaClass.getMethodsWithParameterTypeOfSelf()) {
            result.addAll(Dependency.tryCreateFromParameter(method, this.javaClass).asSet());
        }
        return result;
    }

    private Set<Dependency> throwsDeclarationDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (ThrowsDeclaration<? extends JavaCodeUnit> throwsDeclaration : this.getThrowsDeclarationsWithTypeOfClass()) {
            result.addAll(Dependency.tryCreateFromThrowsDeclaration(throwsDeclaration).asSet());
        }
        return result;
    }

    private Set<Dependency> constructorParameterDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (JavaConstructor constructor : this.javaClass.getConstructorsWithParameterTypeOfSelf()) {
            result.addAll(Dependency.tryCreateFromParameter(constructor, this.javaClass).asSet());
        }
        return result;
    }

    private Iterable<? extends Dependency> annotationDependenciesToSelf() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (JavaAnnotation<?> annotation : this.annotationsWithTypeOfClass) {
            result.addAll(Dependency.tryCreateFromAnnotation(annotation).asSet());
        }
        for (JavaAnnotation<?> annotation : this.annotationsWithParameterTypeOfClass) {
            result.addAll(Dependency.tryCreateFromAnnotationMember(annotation, this.javaClass).asSet());
        }
        return result;
    }
}

