/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.base.PackageMatcher;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.ResolvesTypesViaReflection;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClassDependencies;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaClass
implements HasName.AndFullName,
HasAnnotations<JavaClass>,
HasModifiers,
HasSourceCodeLocation {
    private final Optional<Source> source;
    private final SourceCodeLocation sourceCodeLocation;
    private final JavaType javaType;
    private JavaPackage javaPackage;
    private final boolean isInterface;
    private final boolean isEnum;
    private final boolean isAnonymousClass;
    private final boolean isMemberClass;
    private final Set<JavaModifier> modifiers;
    private final Supplier<Class<?>> reflectSupplier;
    private Set<JavaField> fields = Collections.emptySet();
    private Set<JavaCodeUnit> codeUnits = Collections.emptySet();
    private Set<JavaMethod> methods = Collections.emptySet();
    private Set<JavaMember> members = Collections.emptySet();
    private Set<JavaConstructor> constructors = Collections.emptySet();
    private Optional<JavaStaticInitializer> staticInitializer = Optional.absent();
    private Optional<JavaClass> superClass = Optional.absent();
    private final Set<JavaClass> interfaces = new HashSet<JavaClass>();
    private final Set<JavaClass> subClasses = new HashSet<JavaClass>();
    private Optional<JavaClass> enclosingClass = Optional.absent();
    private Optional<JavaClass> componentType = Optional.absent();
    private Map<String, JavaAnnotation<JavaClass>> annotations = Collections.emptyMap();
    private Supplier<Set<JavaMethod>> allMethods;
    private Supplier<Set<JavaConstructor>> allConstructors;
    private Supplier<Set<JavaField>> allFields;
    private final Supplier<Set<JavaMember>> allMembers = Suppliers.memoize(new Supplier<Set<JavaMember>>(){

        @Override
        public Set<JavaMember> get() {
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(JavaClass.this.getAllFields())).addAll(JavaClass.this.getAllMethods())).addAll(JavaClass.this.getAllConstructors())).build();
        }
    });
    private JavaClassDependencies javaClassDependencies;

    JavaClass(DomainBuilders.JavaClassBuilder builder) {
        this.source = Preconditions.checkNotNull(builder.getSource());
        this.javaType = Preconditions.checkNotNull(builder.getJavaType());
        this.isInterface = builder.isInterface();
        this.isEnum = builder.isEnum();
        this.isAnonymousClass = builder.isAnonymousClass();
        this.isMemberClass = builder.isMemberClass();
        this.modifiers = Preconditions.checkNotNull(builder.getModifiers());
        this.reflectSupplier = Suppliers.memoize(new ReflectClassSupplier());
        this.sourceCodeLocation = SourceCodeLocation.of(this);
        this.javaPackage = JavaPackage.simple(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<Source> getSource() {
        return this.source;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return "Class <" + this.getName() + ">";
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.javaType.getName();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getSimpleName() {
        return this.javaType.getSimpleName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaPackage getPackage() {
        return this.javaPackage;
    }

    void setPackage(JavaPackage javaPackage) {
        this.javaPackage = Preconditions.checkNotNull(javaPackage);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getPackageName() {
        return this.javaType.getPackageName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isPrimitive() {
        return this.javaType.isPrimitive();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isInterface() {
        return this.isInterface;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isEnum() {
        return this.isEnum;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaEnumConstant> tryGetEnumConstant(String name) {
        Optional<JavaField> field = this.tryGetField(name);
        if (!field.isPresent() || !field.get().getModifiers().contains((Object)JavaModifier.ENUM)) {
            return Optional.absent();
        }
        return Optional.of(new JavaEnumConstant(this, field.get().getName()));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaEnumConstant getEnumConstant(String name) {
        Optional<JavaEnumConstant> enumConstant = this.tryGetEnumConstant(name);
        Preconditions.checkArgument(enumConstant.isPresent(), "There exists no enum constant with name '%s' in class %s", (Object)name, (Object)this.getName());
        return enumConstant.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaEnumConstant> getEnumConstants() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaField field : this.fields) {
            if (!field.getModifiers().contains((Object)JavaModifier.ENUM)) continue;
            result.add(new JavaEnumConstant(this, field.getName()));
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isArray() {
        return this.javaType.isArray();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getComponentType() {
        return this.tryGetComponentType().getOrThrow(new IllegalArgumentException(String.format("Type %s is no array", this.getSimpleName())));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    Optional<JavaClass> tryGetComponentType() {
        return this.componentType;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isTopLevelClass() {
        return !this.isNestedClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isNestedClass() {
        return this.enclosingClass.isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMemberClass() {
        return this.isNestedClass() && this.isMemberClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isInnerClass() {
        return this.isNestedClass() && !this.getModifiers().contains((Object)JavaModifier.STATIC);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isLocalClass() {
        return this.isNestedClass() && !this.isMemberClass() && !this.getSimpleName().isEmpty();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnonymousClass() {
        return this.isAnonymousClass;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isAnnotatedWith(annotationType.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String annotationTypeName) {
        return this.annotations.containsKey(annotationTypeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isAnnotatedWith(this.annotations.values(), predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> type) {
        return this.isMetaAnnotatedWith(type.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String typeName) {
        return this.isMetaAnnotatedWith(HasType.Functions.GET_RAW_TYPE.then(HasName.Functions.GET_NAME).is(DescribedPredicate.equalTo(typeName)));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isMetaAnnotatedWith(this.annotations.values(), predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> A getAnnotationOfType(Class<A> type) {
        return this.getAnnotationOfType(type.getName()).as(type);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaAnnotation<JavaClass> getAnnotationOfType(String typeName) {
        return this.tryGetAnnotationOfType(typeName).getOrThrow(new IllegalArgumentException(String.format("Type %s is not annotated with @%s", this.getSimpleName(), typeName)));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAnnotation<JavaClass>> getAnnotations() {
        return ImmutableSet.copyOf(this.annotations.values());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> Optional<A> tryGetAnnotationOfType(Class<A> type) {
        return this.tryGetAnnotationOfType(type.getName()).transform(CanBeAnnotated.Utils.toAnnotationOfType(type));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaAnnotation<JavaClass>> tryGetAnnotationOfType(String typeName) {
        return Optional.fromNullable(this.annotations.get(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaClass> getSuperClass() {
        return this.superClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getClassHierarchy() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add(this);
        result.addAll(this.getAllSuperClasses());
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getAllSuperClasses() {
        ImmutableList.Builder result = ImmutableList.builder();
        JavaClass current = this;
        while (current.getSuperClass().isPresent()) {
            current = current.getSuperClass().get();
            result.add(current);
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getSubClasses() {
        return this.subClasses;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getInterfaces() {
        return this.interfaces;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllInterfaces() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass i : this.interfaces) {
            result.add(i);
            result.addAll(i.getAllInterfaces());
        }
        if (this.superClass.isPresent()) {
            result.addAll(this.superClass.get().getAllInterfaces());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllClassesSelfIsAssignableTo() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(this)).addAll(this.getAllSuperClasses())).addAll(this.getAllInterfaces())).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaClass> getEnclosingClass() {
        return this.enclosingClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllSubClasses() {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        for (JavaClass subClass : this.subClasses) {
            result.add(subClass);
            result.addAll(subClass.getAllSubClasses());
        }
        return result;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMember> getMembers() {
        return this.members;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMember> getAllMembers() {
        return this.allMembers.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaField> getFields() {
        return this.fields;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaField> getAllFields() {
        Preconditions.checkNotNull(this.allFields, "Method may not be called before construction of hierarchy is complete");
        return this.allFields.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaField getField(String name) {
        return this.tryGetField(name).getOrThrow(new IllegalArgumentException("No field with name '" + name + " in class " + this.getName()));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaField> tryGetField(String name) {
        for (JavaField field : this.fields) {
            if (!name.equals(field.getName())) continue;
            return Optional.of(field);
        }
        return Optional.absent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnit> getCodeUnits() {
        return this.codeUnits;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypes(String name, Class<?> ... parameters) {
        return this.getCodeUnitWithParameterTypes(name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypeNames(String name, String ... parameters) {
        return this.getCodeUnitWithParameterTypeNames(name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypes(String name, List<Class<?>> parameters) {
        return this.getCodeUnitWithParameterTypeNames(name, JavaClass.namesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypeNames(String name, List<String> parameters) {
        return this.findMatchingCodeUnit(this.codeUnits, name, parameters);
    }

    private <T extends JavaCodeUnit> T findMatchingCodeUnit(Set<T> codeUnits, String name, List<String> parameters) {
        Optional<T> codeUnit = this.tryFindMatchingCodeUnit(codeUnits, name, parameters);
        if (!codeUnit.isPresent()) {
            throw new IllegalArgumentException(String.format("No code unit with name '%s' and parameters %s in codeUnits %s of class %s", name, parameters, codeUnits, this.getName()));
        }
        return (T)((JavaCodeUnit)codeUnit.get());
    }

    private <T extends JavaCodeUnit> Optional<T> tryFindMatchingCodeUnit(Set<T> codeUnits, String name, List<String> parameters) {
        for (JavaCodeUnit codeUnit : codeUnits) {
            if (!name.equals(codeUnit.getName()) || !parameters.equals(codeUnit.getRawParameterTypes().getNames())) continue;
            return Optional.of(codeUnit);
        }
        return Optional.absent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaMethod getMethod(String name) {
        return this.findMatchingCodeUnit(this.methods, name, Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaMethod getMethod(String name, Class<?> ... parameters) {
        return this.findMatchingCodeUnit(this.methods, name, JavaClass.namesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaMethod getMethod(String name, String ... parameters) {
        return this.findMatchingCodeUnit(this.methods, name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaMethod> tryGetMethod(String name) {
        return this.tryFindMatchingCodeUnit(this.methods, name, Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaMethod> tryGetMethod(String name, Class<?> ... parameters) {
        return this.tryFindMatchingCodeUnit(this.methods, name, JavaClass.namesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaMethod> tryGetMethod(String name, String ... parameters) {
        return this.tryFindMatchingCodeUnit(this.methods, name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getMethods() {
        return this.methods;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getAllMethods() {
        Preconditions.checkNotNull(this.allMethods, "Method may not be called before construction of hierarchy is complete");
        return this.allMethods.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaConstructor getConstructor() {
        return this.findMatchingCodeUnit(this.constructors, "<init>", Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaConstructor getConstructor(Class<?> ... parameters) {
        return this.findMatchingCodeUnit(this.constructors, "<init>", JavaClass.namesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaConstructor getConstructor(String ... parameters) {
        return this.findMatchingCodeUnit(this.constructors, "<init>", ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructor> getConstructors() {
        return this.constructors;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructor> getAllConstructors() {
        Preconditions.checkNotNull(this.allConstructors, "Method may not be called before construction of hierarchy is complete");
        return this.allConstructors.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaStaticInitializer> getStaticInitializer() {
        return this.staticInitializer;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesFromSelf() {
        return Sets.union(this.getFieldAccessesFromSelf(), this.getCallsFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAllAccessesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass clazz : this.getClassHierarchy()) {
            result.addAll(clazz.getAccessesFromSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getFieldAccessesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getFieldAccesses());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCall<?>> getCallsFromSelf() {
        return Sets.union(this.getMethodCallsFromSelf(), this.getConstructorCallsFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getMethodCallsFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getMethodCallsFromSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getConstructorCallsFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.codeUnits) {
            result.addAll(codeUnit.getConstructorCallsFromSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getDirectDependenciesFromSelf() {
        return this.javaClassDependencies.getDirectDependenciesFromClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getDirectDependenciesToSelf() {
        return this.javaClassDependencies.getDirectDependenciesToClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getFieldAccessesToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaField field : this.fields) {
            result.addAll(field.getAccessesToSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getMethodCallsToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaMethod method : this.methods) {
            result.addAll(method.getCallsOfSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getConstructorCallsToSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaConstructor constructor : this.constructors) {
            result.addAll(constructor.getCallsOfSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesToSelf() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getFieldAccessesToSelf())).addAll(this.getMethodCallsToSelf())).addAll(this.getConstructorCallsToSelf())).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaField> getFieldsWithTypeOfSelf() {
        return this.javaClassDependencies.getFieldsWithTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getMethodsWithParameterTypeOfSelf() {
        return this.javaClassDependencies.getMethodsWithParameterTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getMethodsWithReturnTypeOfSelf() {
        return this.javaClassDependencies.getMethodsWithReturnTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ThrowsDeclaration<JavaMethod>> getMethodThrowsDeclarationsWithTypeOfSelf() {
        return this.javaClassDependencies.getMethodThrowsDeclarationsWithTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructor> getConstructorsWithParameterTypeOfSelf() {
        return this.javaClassDependencies.getConstructorsWithParameterTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ThrowsDeclaration<JavaConstructor>> getConstructorsWithThrowsDeclarationTypeOfSelf() {
        return this.javaClassDependencies.getConstructorsWithThrowsDeclarationTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAnnotation<?>> getAnnotationsWithTypeOfSelf() {
        return this.javaClassDependencies.getAnnotationsWithTypeOfClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isEquivalentTo(Class<?> clazz) {
        return this.getName().equals(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableFrom(Class<?> type) {
        return this.isAssignableFrom(type.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableFrom(String typeName) {
        return this.isAssignableFrom(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableFrom(DescribedPredicate<? super JavaClass> predicate) {
        ImmutableCollection possibleTargets = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this)).addAll(this.getAllSubClasses())).build();
        return this.anyMatches((List<JavaClass>)((Object)possibleTargets), predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableTo(Class<?> type) {
        return this.isAssignableTo(type.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableTo(String typeName) {
        return this.isAssignableTo(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableTo(DescribedPredicate<? super JavaClass> predicate) {
        ImmutableCollection possibleTargets = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getClassHierarchy())).addAll(this.getAllInterfaces())).build();
        return this.anyMatches((List<JavaClass>)((Object)possibleTargets), predicate);
    }

    private boolean anyMatches(List<JavaClass> possibleTargets, DescribedPredicate<? super JavaClass> predicate) {
        for (JavaClass javaClass : possibleTargets) {
            if (!predicate.apply(javaClass)) continue;
            return true;
        }
        return false;
    }

    @ResolvesTypesViaReflection
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Class<?> reflect() {
        return this.reflectSupplier.get();
    }

    void completeClassHierarchyFrom(ImportContext context) {
        this.completeSuperClassFrom(context);
        this.completeInterfacesFrom(context);
        this.allFields = Suppliers.memoize(new Supplier<Set<JavaField>>(){

            @Override
            public Set<JavaField> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : Iterables.concat(JavaClass.this.getClassHierarchy(), JavaClass.this.getAllInterfaces())) {
                    result.addAll(javaClass.getFields());
                }
                return result.build();
            }
        });
        this.allMethods = Suppliers.memoize(new Supplier<Set<JavaMethod>>(){

            @Override
            public Set<JavaMethod> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : Iterables.concat(JavaClass.this.getClassHierarchy(), JavaClass.this.getAllInterfaces())) {
                    result.addAll(javaClass.getMethods());
                }
                return result.build();
            }
        });
        this.allConstructors = Suppliers.memoize(new Supplier<Set<JavaConstructor>>(){

            @Override
            public Set<JavaConstructor> get() {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaClass javaClass : JavaClass.this.getClassHierarchy()) {
                    result.addAll(javaClass.getConstructors());
                }
                return result.build();
            }
        });
    }

    private void completeSuperClassFrom(ImportContext context) {
        this.superClass = context.createSuperClass(this);
        if (this.superClass.isPresent()) {
            this.superClass.get().subClasses.add(this);
        }
    }

    private void completeInterfacesFrom(ImportContext context) {
        this.interfaces.addAll(context.createInterfaces(this));
        for (JavaClass i : this.interfaces) {
            i.subClasses.add(this);
        }
    }

    void completeMembers(ImportContext context) {
        this.fields = context.createFields(this);
        this.methods = context.createMethods(this);
        this.constructors = context.createConstructors(this);
        this.staticInitializer = context.createStaticInitializer(this);
        this.codeUnits = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.methods)).addAll(this.constructors)).addAll(this.staticInitializer.asSet())).build();
        this.members = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.fields)).addAll(this.methods)).addAll(this.constructors)).build();
    }

    void completeAnnotations(ImportContext context) {
        this.annotations = context.createAnnotations(this);
    }

    CompletionProcess completeFrom(ImportContext context) {
        this.completeComponentType(context);
        this.enclosingClass = context.createEnclosingClass(this);
        this.javaClassDependencies = new JavaClassDependencies(this, context);
        return new CompletionProcess();
    }

    private void completeComponentType(ImportContext context) {
        JavaClass current = this;
        while (current.isArray() && !current.componentType.isPresent()) {
            JavaClass componentType = context.resolveClass(current.javaType.tryGetComponentType().get().getName());
            current.componentType = Optional.of(componentType);
            current = componentType;
        }
    }

    public String toString() {
        return "JavaClass{name='" + this.javaType.getName() + "'}";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static List<String> namesOf(Class<?> ... paramTypes) {
        return JavaClass.namesOf(ImmutableList.copyOf(paramTypes));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static List<String> namesOf(List<Class<?>> paramTypes) {
        ArrayList<String> result = new ArrayList<String>();
        for (Class<?> paramType : paramTypes) {
            result.add(paramType.getName());
        }
        return result;
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnonymous() {
        return this.isAnonymousClass();
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    private class ReflectClassSupplier
    implements Supplier<Class<?>> {
        private ReflectClassSupplier() {
        }

        @Override
        public Class<?> get() {
            return JavaClass.this.javaType.resolveClass(ClassLoaders.getCurrentClassLoader(this.getClass()));
        }
    }

    class CompletionProcess {
        CompletionProcess() {
        }

        DomainObjectCreationContext.AccessContext.Part completeCodeUnitsFrom(ImportContext context) {
            DomainObjectCreationContext.AccessContext.Part part = new DomainObjectCreationContext.AccessContext.Part();
            for (JavaCodeUnit codeUnit : JavaClass.this.codeUnits) {
                part.mergeWith(codeUnit.completeFrom(context));
            }
            return part;
        }
    }

    public static final class Predicates {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> INTERFACES = new DescribedPredicate<JavaClass>("interfaces", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isInterface();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> ENUMS = new DescribedPredicate<JavaClass>("enums", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isEnum();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> TOP_LEVEL_CLASSES = new DescribedPredicate<JavaClass>("top level classes", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isTopLevelClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> NESTED_CLASSES = new DescribedPredicate<JavaClass>("nested classes", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isNestedClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> MEMBER_CLASSES = new DescribedPredicate<JavaClass>("member classes", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isMemberClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> INNER_CLASSES = new DescribedPredicate<JavaClass>("inner classes", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isInnerClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> LOCAL_CLASSES = new DescribedPredicate<JavaClass>("local classes", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isLocalClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> ANONYMOUS_CLASSES = new DescribedPredicate<JavaClass>("anonymous classes", new Object[0]){

            @Override
            public boolean apply(JavaClass input) {
                return input.isAnonymousClass();
            }
        };

        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> type(Class<?> type) {
            return DescribedPredicate.equalTo(type.getName()).onResultOf(HasName.Functions.GET_NAME).as("type " + type.getName(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleName(String name) {
            return DescribedPredicate.equalTo(name).onResultOf(Functions.GET_SIMPLE_NAME).as("simple name '%s'", name);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleNameStartingWith(String prefix) {
            return new SimpleNameStartingWithPredicate(prefix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleNameContaining(String infix) {
            return new SimpleNameContainingPredicate(infix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleNameEndingWith(String suffix) {
            return new SimpleNameEndingWithPredicate(suffix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableTo(Class<?> type) {
            return Predicates.assignableTo(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableFrom(Class<?> type) {
            return Predicates.assignableFrom(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableTo(String typeName) {
            return Predicates.assignableTo(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableFrom(String typeName) {
            return Predicates.assignableFrom(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableTo(DescribedPredicate<? super JavaClass> predicate) {
            return new AssignableToPredicate(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableFrom(DescribedPredicate<? super JavaClass> predicate) {
            return new AssignableFromPredicate(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> implement(Class<?> type) {
            if (!type.isInterface()) {
                throw new ArchUnitException.InvalidSyntaxUsageException(String.format("implement(type) can only ever be true, if type is an interface, but type %s is not", type.getName()));
            }
            return Predicates.implement(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> implement(String typeName) {
            return Predicates.implement(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> implement(DescribedPredicate<? super JavaClass> predicate) {
            DescribedPredicate<JavaClass> selfIsImplementation = DescribedPredicate.not(INTERFACES);
            DescribedPredicate<JavaClass> interfacePredicate = predicate.forSubType().and(INTERFACES);
            return selfIsImplementation.and(Predicates.assignableTo(interfacePredicate)).as("implement " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideInAPackage(String packageIdentifier) {
            return Predicates.resideInAnyPackage(new String[]{packageIdentifier}, String.format("reside in a package '%s'", packageIdentifier));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideInAnyPackage(String ... packageIdentifiers) {
            return Predicates.resideInAnyPackage(packageIdentifiers, String.format("reside in any package ['%s']", Joiner.on("', '").join(packageIdentifiers)));
        }

        private static DescribedPredicate<JavaClass> resideInAnyPackage(String[] packageIdentifiers, String description) {
            HashSet<PackageMatcher> packageMatchers = new HashSet<PackageMatcher>();
            for (String identifier : packageIdentifiers) {
                packageMatchers.add(PackageMatcher.of(identifier));
            }
            return new PackageMatchesPredicate(packageMatchers, description);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideOutsideOfPackage(String packageIdentifier) {
            return DescribedPredicate.not(Predicates.resideInAPackage(packageIdentifier)).as("reside outside of package '%s'", packageIdentifier);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideOutsideOfPackages(String ... packageIdentifiers) {
            return DescribedPredicate.not(Predicates.resideInAnyPackage(packageIdentifiers)).as("reside outside of packages ['%s']", Joiner.on("', '").join(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> equivalentTo(Class<?> clazz) {
            return new EquivalentToPredicate(clazz);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> belongToAnyOf(Class<?> ... classes) {
            return new BelongToAnyOfPredicate(classes);
        }

        private static class EquivalentToPredicate
        extends DescribedPredicate<JavaClass> {
            private final Class<?> clazz;

            EquivalentToPredicate(Class<?> clazz) {
                super("equivalent to %s", clazz.getName());
                this.clazz = clazz;
            }

            @Override
            public boolean apply(JavaClass input) {
                return input.isEquivalentTo(this.clazz);
            }
        }

        private static class PackageMatchesPredicate
        extends DescribedPredicate<JavaClass> {
            private final Set<PackageMatcher> packageMatchers;

            PackageMatchesPredicate(Set<PackageMatcher> packageMatchers, String description) {
                super(description, new Object[0]);
                this.packageMatchers = packageMatchers;
            }

            @Override
            public boolean apply(JavaClass input) {
                for (PackageMatcher matcher : this.packageMatchers) {
                    if (!matcher.matches(input.getPackageName())) continue;
                    return true;
                }
                return false;
            }
        }

        private static class AssignableFromPredicate
        extends DescribedPredicate<JavaClass> {
            private final DescribedPredicate<? super JavaClass> predicate;

            AssignableFromPredicate(DescribedPredicate<? super JavaClass> predicate) {
                super("assignable from " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(JavaClass input) {
                return input.isAssignableFrom(this.predicate);
            }
        }

        private static class AssignableToPredicate
        extends DescribedPredicate<JavaClass> {
            private final DescribedPredicate<? super JavaClass> predicate;

            AssignableToPredicate(DescribedPredicate<? super JavaClass> predicate) {
                super("assignable to " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(JavaClass input) {
                return input.isAssignableTo(this.predicate);
            }
        }

        private static class SimpleNameEndingWithPredicate
        extends DescribedPredicate<JavaClass> {
            private final String suffix;

            SimpleNameEndingWithPredicate(String suffix) {
                super(String.format("simple name ending with '%s'", suffix), new Object[0]);
                this.suffix = suffix;
            }

            @Override
            public boolean apply(JavaClass input) {
                return input.getSimpleName().endsWith(this.suffix);
            }
        }

        private static class SimpleNameContainingPredicate
        extends DescribedPredicate<JavaClass> {
            private final String infix;

            SimpleNameContainingPredicate(String infix) {
                super(String.format("simple name containing '%s'", infix), new Object[0]);
                this.infix = infix;
            }

            @Override
            public boolean apply(JavaClass input) {
                return input.getSimpleName().contains(this.infix);
            }
        }

        private static class SimpleNameStartingWithPredicate
        extends DescribedPredicate<JavaClass> {
            private final String prefix;

            SimpleNameStartingWithPredicate(String prefix) {
                super(String.format("simple name starting with '%s'", prefix), new Object[0]);
                this.prefix = prefix;
            }

            @Override
            public boolean apply(JavaClass input) {
                return input.getSimpleName().startsWith(this.prefix);
            }
        }

        private static class BelongToAnyOfPredicate
        extends DescribedPredicate<JavaClass> {
            private final Class<?>[] classes;

            BelongToAnyOfPredicate(Class<?> ... classes) {
                super("belong to any of " + JavaClass.namesOf(classes), new Object[0]);
                this.classes = classes;
            }

            @Override
            public boolean apply(JavaClass input) {
                for (Class<?> clazz : this.classes) {
                    if (!this.belongsTo(input, clazz)) continue;
                    return true;
                }
                return false;
            }

            private boolean belongsTo(JavaClass input, Class<?> clazz) {
                JavaClass toTest = input;
                while (!toTest.isEquivalentTo(clazz) && toTest.getEnclosingClass().isPresent()) {
                    toTest = toTest.getEnclosingClass().get();
                }
                return toTest.isEquivalentTo(clazz);
            }
        }
    }

    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, String> GET_SIMPLE_NAME = new ChainableFunction<JavaClass, String>(){

            @Override
            public String apply(JavaClass input) {
                return input.getSimpleName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, String> GET_PACKAGE_NAME = new ChainableFunction<JavaClass, String>(){

            @Override
            public String apply(JavaClass input) {
                return input.getPackageName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, JavaPackage> GET_PACKAGE = new ChainableFunction<JavaClass, JavaPackage>(){

            @Override
            public JavaPackage apply(JavaClass input) {
                return input.getPackage();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMember>> GET_MEMBERS = new ChainableFunction<JavaClass, Set<JavaMember>>(){

            @Override
            public Set<JavaMember> apply(JavaClass input) {
                return input.getMembers();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaField>> GET_FIELDS = new ChainableFunction<JavaClass, Set<JavaField>>(){

            @Override
            public Set<JavaField> apply(JavaClass input) {
                return input.getFields();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaCodeUnit>> GET_CODE_UNITS = new ChainableFunction<JavaClass, Set<JavaCodeUnit>>(){

            @Override
            public Set<JavaCodeUnit> apply(JavaClass input) {
                return input.getCodeUnits();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMethod>> GET_METHODS = new ChainableFunction<JavaClass, Set<JavaMethod>>(){

            @Override
            public Set<JavaMethod> apply(JavaClass input) {
                return input.getMethods();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaConstructor>> GET_CONSTRUCTORS = new ChainableFunction<JavaClass, Set<JavaConstructor>>(){

            @Override
            public Set<JavaConstructor> apply(JavaClass input) {
                return input.getConstructors();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaFieldAccess>> GET_FIELD_ACCESSES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaFieldAccess>>(){

            @Override
            public Set<JavaFieldAccess> apply(JavaClass input) {
                return input.getFieldAccessesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMethodCall>> GET_METHOD_CALLS_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaMethodCall>>(){

            @Override
            public Set<JavaMethodCall> apply(JavaClass input) {
                return input.getMethodCallsFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaConstructorCall>> GET_CONSTRUCTOR_CALLS_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaConstructorCall>>(){

            @Override
            public Set<JavaConstructorCall> apply(JavaClass input) {
                return input.getConstructorCallsFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaCall<?>>> GET_CALLS_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaCall<?>>>(){

            @Override
            public Set<JavaCall<?>> apply(JavaClass input) {
                return input.getCallsFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaAccess<?>>> GET_ACCESSES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaAccess<?>>>(){

            @Override
            public Set<JavaAccess<?>> apply(JavaClass input) {
                return input.getAccessesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<Dependency>> GET_DIRECT_DEPENDENCIES_FROM_SELF = new ChainableFunction<JavaClass, Set<Dependency>>(){

            @Override
            public Set<Dependency> apply(JavaClass input) {
                return input.getDirectDependenciesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaAccess<?>>> GET_ACCESSES_TO_SELF = new ChainableFunction<JavaClass, Set<JavaAccess<?>>>(){

            @Override
            public Set<JavaAccess<?>> apply(JavaClass input) {
                return input.getAccessesToSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<Dependency>> GET_DIRECT_DEPENDENCIES_TO_SELF = new ChainableFunction<JavaClass, Set<Dependency>>(){

            @Override
            public Set<Dependency> apply(JavaClass input) {
                return input.getDirectDependenciesToSelf();
            }
        };

        private Functions() {
        }
    }
}

