/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AnnotationProxy;
import com.tngtech.archunit.core.domain.JavaAnnotationParameterVisitorAcceptor;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.Map;

public final class JavaAnnotation<OWNER extends HasDescription>
implements HasType,
HasOwner<OWNER>,
HasDescription {
    private final JavaClass type;
    private final OWNER owner;
    private final CanBeAnnotated annotatedElement;
    private final String description;
    private final Map<String, Object> values;

    private JavaAnnotation(JavaClass type, OWNER owner, CanBeAnnotated annotatedElement, String description, Map<String, Object> values) {
        this.type = Preconditions.checkNotNull(type);
        this.owner = (HasDescription)Preconditions.checkNotNull(owner);
        this.annotatedElement = Preconditions.checkNotNull(annotatedElement);
        this.description = Preconditions.checkNotNull(description);
        this.values = Preconditions.checkNotNull(values);
    }

    JavaAnnotation(OWNER owner, DomainBuilders.JavaAnnotationBuilder builder) {
        this.type = Preconditions.checkNotNull(builder.getType());
        this.owner = (HasDescription)Preconditions.checkNotNull(owner);
        this.annotatedElement = JavaAnnotation.getAnnotatedElement(owner);
        this.description = this.createDescription();
        this.values = Preconditions.checkNotNull(builder.getValues(this));
    }

    private static CanBeAnnotated getAnnotatedElement(Object owner) {
        Object candiate = owner;
        while (!(candiate instanceof JavaClass) && !(candiate instanceof JavaMember) && candiate instanceof HasOwner) {
            candiate = ((HasOwner)candiate).getOwner();
        }
        if (!(candiate instanceof CanBeAnnotated)) {
            throw new IllegalArgumentException("Cannot derive annotated element from annotation owner: " + owner);
        }
        return (CanBeAnnotated)candiate;
    }

    private String createDescription() {
        CanBeAnnotated annotatedElement = this.getAnnotatedElement();
        String descriptionSuffix = annotatedElement instanceof HasDescription ? " on " + this.startWithLowerCase((HasDescription)((Object)annotatedElement)) : "";
        return "Annotation <" + this.type.getName() + ">" + descriptionSuffix;
    }

    private String startWithLowerCase(HasDescription annotatedElement) {
        return annotatedElement.getDescription().substring(0, 1).toLowerCase() + annotatedElement.getDescription().substring(1);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawType() {
        return this.type;
    }

    @Override
    public OWNER getOwner() {
        return this.owner;
    }

    <NEW_OWNER extends HasDescription> JavaAnnotation<NEW_OWNER> withOwner(NEW_OWNER newOwner) {
        return new JavaAnnotation<NEW_OWNER>(this.type, newOwner, this.annotatedElement, this.description, this.values);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public CanBeAnnotated getAnnotatedElement() {
        return this.annotatedElement;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<Object> get(String property) {
        return Optional.fromNullable(this.values.get(property));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Map<String, Object> getProperties() {
        return this.values;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void accept(ParameterVisitor parameterVisitor) {
        JavaAnnotationParameterVisitorAcceptor.accept(this.getProperties(), parameterVisitor);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> A as(Class<A> annotationType) {
        return AnnotationProxy.of(annotationType, this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.type.getName() + '}';
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static class DefaultParameterVisitor
    implements ParameterVisitor {
        @Override
        public void visitBoolean(String propertyName, boolean propertyValue) {
        }

        @Override
        public void visitByte(String propertyName, byte propertyValue) {
        }

        @Override
        public void visitCharacter(String propertyName, Character propertyValue) {
        }

        @Override
        public void visitDouble(String propertyName, Double propertyValue) {
        }

        @Override
        public void visitFloat(String propertyName, Float propertyValue) {
        }

        @Override
        public void visitInteger(String propertyName, int propertyValue) {
        }

        @Override
        public void visitLong(String propertyName, Long propertyValue) {
        }

        @Override
        public void visitShort(String propertyName, Short propertyValue) {
        }

        @Override
        public void visitString(String propertyName, String propertyValue) {
        }

        @Override
        public void visitClass(String propertyName, JavaClass propertyValue) {
        }

        @Override
        public void visitEnumConstant(String propertyName, JavaEnumConstant propertyValue) {
        }

        @Override
        public void visitAnnotation(String propertyName, JavaAnnotation<?> propertyValue) {
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface ParameterVisitor {
        public void visitBoolean(String var1, boolean var2);

        public void visitByte(String var1, byte var2);

        public void visitCharacter(String var1, Character var2);

        public void visitDouble(String var1, Double var2);

        public void visitFloat(String var1, Float var2);

        public void visitInteger(String var1, int var2);

        public void visitLong(String var1, Long var2);

        public void visitShort(String var1, Short var2);

        public void visitString(String var1, String var2);

        public void visitClass(String var1, JavaClass var2);

        public void visitEnumConstant(String var1, JavaEnumConstant var2);

        public void visitAnnotation(String var1, JavaAnnotation<?> var2);
    }
}

