/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class JavaAccess<TARGET extends AccessTarget>
implements HasName,
HasDescription,
HasOwner<JavaCodeUnit>,
HasSourceCodeLocation {
    private final JavaCodeUnit origin;
    private final TARGET target;
    private final int lineNumber;
    private final int hashCode;
    private final SourceCodeLocation sourceCodeLocation;

    JavaAccess(DomainBuilders.JavaAccessBuilder<TARGET, ?> builder) {
        this.origin = Preconditions.checkNotNull(builder.getOrigin());
        this.target = (AccessTarget)Preconditions.checkNotNull(builder.getTarget());
        this.lineNumber = builder.getLineNumber();
        this.hashCode = Objects.hash(this.origin.getFullName(), ((AccessTarget)this.target).getFullName(), this.lineNumber);
        this.sourceCodeLocation = SourceCodeLocation.of(this.getOriginOwner(), this.lineNumber);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return ((AccessTarget)this.target).getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOrigin() {
        return this.origin;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOriginOwner() {
        return this.getOrigin().getOwner();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getTargetOwner() {
        return ((AccessTarget)this.getTarget()).getOwner();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public TARGET getTarget() {
        return this.target;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.getOrigin();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaAccess other = (JavaAccess)obj;
        return Objects.equals(this.origin.getFullName(), other.origin.getFullName()) && Objects.equals(((AccessTarget)this.target).getFullName(), ((AccessTarget)other.target).getFullName()) && Objects.equals(this.lineNumber, other.lineNumber);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{origin=" + this.origin + ", target=" + this.target + ", lineNumber=" + this.lineNumber + this.additionalToStringFields() + '}';
    }

    String additionalToStringFields() {
        return "";
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        String description = this.origin.getDescription() + " " + this.descriptionVerb() + " " + ((AccessTarget)this.getTarget()).getDescription();
        return description + " in " + this.getSourceCodeLocation();
    }

    protected abstract String descriptionVerb();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        private Functions() {
        }

        public static final class Get {
            private Get() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static ChainableFunction<JavaAccess<?>, JavaCodeUnit> origin() {
                return new ChainableFunction<JavaAccess<?>, JavaCodeUnit>(){

                    @Override
                    public JavaCodeUnit apply(JavaAccess<?> input) {
                        return input.getOrigin();
                    }
                };
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static <A extends JavaAccess<? extends T>, T extends AccessTarget> ChainableFunction<A, T> target() {
                return new ChainableFunction<A, T>(){

                    @Override
                    public T apply(A input) {
                        return ((JavaAccess)input).getTarget();
                    }
                };
            }
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> originOwner(DescribedPredicate<? super JavaClass> predicate) {
            return Predicates.origin(HasOwner.Functions.Get.owner().is(predicate));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> origin(DescribedPredicate<? super JavaCodeUnit> predicate) {
            return predicate.onResultOf(Functions.Get.origin()).as("origin " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> originOwnerEqualsTargetOwner() {
            return new OriginOwnerEqualsTargetOwnerPredicate();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> targetOwner(DescribedPredicate<? super JavaClass> predicate) {
            return Predicates.target(HasOwner.Functions.Get.owner().is(predicate));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> target(DescribedPredicate<? super AccessTarget> predicate) {
            return new TargetPredicate(predicate);
        }

        private static class TargetPredicate
        extends DescribedPredicate<JavaAccess<?>> {
            private final DescribedPredicate<? super AccessTarget> predicate;

            TargetPredicate(DescribedPredicate<? super AccessTarget> predicate) {
                super("target " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean apply(JavaAccess<?> input) {
                return this.predicate.apply((AccessTarget)input.getTarget());
            }
        }

        private static class OriginOwnerEqualsTargetOwnerPredicate
        extends DescribedPredicate<JavaAccess<?>> {
            OriginOwnerEqualsTargetOwnerPredicate() {
                super("origin owner equals target owner", new Object[0]);
            }

            @Override
            public boolean apply(JavaAccess<?> input) {
                return input.getOriginOwner().equals(input.getTargetOwner());
            }
        }
    }
}

