/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassList;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class DomainObjectCreationContext {
    public static JavaClasses createJavaClasses(Map<String, JavaClass> selectedClasses, Map<String, JavaClass> allClasses, ImportContext importContext) {
        return JavaClasses.of(selectedClasses, allClasses, importContext);
    }

    public static JavaClass createJavaClass(DomainBuilders.JavaClassBuilder builder) {
        return new JavaClass(builder);
    }

    public static void completeClassHierarchy(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeClassHierarchyFrom(importContext);
    }

    public static void completeMembers(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeMembers(importContext);
    }

    public static void completeAnnotations(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeAnnotations(importContext);
    }

    public static <T extends HasDescription> JavaAnnotation<T> createJavaAnnotation(T owner, DomainBuilders.JavaAnnotationBuilder builder) {
        return new JavaAnnotation<T>(owner, builder);
    }

    public static JavaClassList createJavaClassList(List<JavaClass> elements) {
        return new JavaClassList(elements);
    }

    public static JavaField createJavaField(DomainBuilders.JavaFieldBuilder builder) {
        return new JavaField(builder);
    }

    public static JavaFieldAccess createJavaFieldAccess(DomainBuilders.JavaFieldAccessBuilder builder) {
        return new JavaFieldAccess(builder);
    }

    public static AccessTarget.FieldAccessTarget createFieldAccessTarget(DomainBuilders.FieldAccessTargetBuilder builder) {
        return new AccessTarget.FieldAccessTarget(builder);
    }

    public static JavaConstructor createJavaConstructor(DomainBuilders.JavaConstructorBuilder builder) {
        return new JavaConstructor(builder);
    }

    public static JavaConstructorCall createJavaConstructorCall(DomainBuilders.JavaConstructorCallBuilder builder) {
        return new JavaConstructorCall(builder);
    }

    public static AccessTarget.ConstructorCallTarget createConstructorCallTarget(DomainBuilders.ConstructorCallTargetBuilder builder) {
        return new AccessTarget.ConstructorCallTarget(builder);
    }

    public static JavaMethod createJavaMethod(DomainBuilders.JavaMethodBuilder builder) {
        return new JavaMethod(builder);
    }

    public static JavaMethodCall createJavaMethodCall(DomainBuilders.JavaMethodCallBuilder builder) {
        return new JavaMethodCall(builder);
    }

    public static AccessTarget.MethodCallTarget createMethodCallTarget(DomainBuilders.MethodCallTargetBuilder builder) {
        return new AccessTarget.MethodCallTarget(builder);
    }

    public static JavaStaticInitializer createJavaStaticInitializer(DomainBuilders.JavaStaticInitializerBuilder builder) {
        return new JavaStaticInitializer(builder);
    }

    public static JavaEnumConstant createJavaEnumConstant(DomainBuilders.JavaEnumConstantBuilder builder) {
        return new JavaEnumConstant(builder);
    }

    public static Source createSource(URI uri, Optional<String> sourceFileName) {
        return new Source(uri, sourceFileName);
    }

    public static <CODE_UNIT extends JavaCodeUnit> ThrowsClause<CODE_UNIT> createThrowsClause(CODE_UNIT codeUnit, List<JavaClass> types) {
        return ThrowsClause.from(codeUnit, types);
    }

    static class AccessContext {
        final SetMultimap<JavaClass, JavaFieldAccess> fieldAccessesByTarget = HashMultimap.create();
        final SetMultimap<JavaClass, JavaMethodCall> methodCallsByTarget = HashMultimap.create();
        final SetMultimap<String, JavaConstructorCall> constructorCallsByTarget = HashMultimap.create();

        private AccessContext() {
        }

        void mergeWith(AccessContext other) {
            this.fieldAccessesByTarget.putAll(other.fieldAccessesByTarget);
            this.methodCallsByTarget.putAll(other.methodCallsByTarget);
            this.constructorCallsByTarget.putAll(other.constructorCallsByTarget);
        }

        static class TopProcess
        extends AccessContext {
            private final Collection<JavaClass> classes;

            TopProcess(Collection<JavaClass> classes) {
                this.classes = classes;
            }

            void finish() {
                for (JavaClass clazz : this.classes) {
                    for (JavaField field : clazz.getFields()) {
                        field.registerAccessesToField(this.getFieldAccessesTo(field));
                    }
                    for (JavaMethod method : clazz.getMethods()) {
                        method.registerCallsToMethod(this.getMethodCallsOf(method));
                    }
                    for (JavaConstructor constructor : clazz.getConstructors()) {
                        constructor.registerCallsToConstructor(this.constructorCallsByTarget.get(constructor.getFullName()));
                    }
                }
            }

            private Supplier<Set<JavaFieldAccess>> getFieldAccessesTo(JavaField field) {
                return Suppliers.memoize(new AccessSupplier(field.getOwner(), this.fieldAccessTargetResolvesTo(field)));
            }

            private Function<JavaClass, Set<JavaFieldAccess>> fieldAccessTargetResolvesTo(JavaField field) {
                return new ClassToFieldAccessesToSelf(this.fieldAccessesByTarget, field);
            }

            private Supplier<Set<JavaMethodCall>> getMethodCallsOf(JavaMethod method) {
                return Suppliers.memoize(new AccessSupplier(method.getOwner(), this.methodCallTargetResolvesTo(method)));
            }

            private Function<JavaClass, Set<JavaMethodCall>> methodCallTargetResolvesTo(JavaMethod method) {
                return new ClassToMethodCallsToSelf(this.methodCallsByTarget, method);
            }

            private static class AccessSupplier<T extends JavaAccess<?>>
            implements Supplier<Set<T>> {
                private final JavaClass owner;
                private final Function<JavaClass, Set<T>> mapToAccesses;

                AccessSupplier(JavaClass owner, Function<JavaClass, Set<T>> mapToAccesses) {
                    this.owner = owner;
                    this.mapToAccesses = mapToAccesses;
                }

                @Override
                public Set<T> get() {
                    ImmutableSet.Builder result = ImmutableSet.builder();
                    for (JavaClass javaClass : this.getPossibleTargetClassesForAccess()) {
                        result.addAll(this.mapToAccesses.apply(javaClass));
                    }
                    return result.build();
                }

                private Set<JavaClass> getPossibleTargetClassesForAccess() {
                    return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(this.owner)).addAll(this.owner.getAllSubClasses())).build();
                }
            }

            private static class ClassToMethodCallsToSelf
            implements Function<JavaClass, Set<JavaMethodCall>> {
                private final Multimap<JavaClass, JavaMethodCall> methodCallsByTarget;
                private final JavaMethod method;

                ClassToMethodCallsToSelf(SetMultimap<JavaClass, JavaMethodCall> methodCallsByTarget, JavaMethod method) {
                    this.methodCallsByTarget = methodCallsByTarget;
                    this.method = method;
                }

                @Override
                public Set<JavaMethodCall> apply(JavaClass input) {
                    HashSet<JavaMethodCall> result = new HashSet<JavaMethodCall>();
                    for (JavaMethodCall call : this.methodCallsByTarget.get(input)) {
                        if (!((AccessTarget.MethodCallTarget)call.getTarget()).resolve().contains(this.method)) continue;
                        result.add(call);
                    }
                    return result;
                }
            }

            private static class ClassToFieldAccessesToSelf
            implements Function<JavaClass, Set<JavaFieldAccess>> {
                private final Multimap<JavaClass, JavaFieldAccess> fieldAccessesByTarget;
                private final JavaField field;

                ClassToFieldAccessesToSelf(SetMultimap<JavaClass, JavaFieldAccess> fieldAccessesByTarget, JavaField field) {
                    this.fieldAccessesByTarget = fieldAccessesByTarget;
                    this.field = field;
                }

                @Override
                public Set<JavaFieldAccess> apply(JavaClass input) {
                    HashSet<JavaFieldAccess> result = new HashSet<JavaFieldAccess>();
                    for (JavaFieldAccess access : this.fieldAccessesByTarget.get(input)) {
                        if (!((AccessTarget.FieldAccessTarget)access.getTarget()).resolveField().asSet().contains(this.field)) continue;
                        result.add(access);
                    }
                    return result;
                }
            }
        }

        static class Part
        extends AccessContext {
            Part() {
            }

            Part(JavaCodeUnit codeUnit) {
                for (JavaFieldAccess javaFieldAccess : codeUnit.getFieldAccesses()) {
                    this.fieldAccessesByTarget.put(((AccessTarget.FieldAccessTarget)javaFieldAccess.getTarget()).getOwner(), javaFieldAccess);
                }
                for (JavaMethodCall javaMethodCall : codeUnit.getMethodCallsFromSelf()) {
                    this.methodCallsByTarget.put(((AccessTarget.MethodCallTarget)javaMethodCall.getTarget()).getOwner(), javaMethodCall);
                }
                for (JavaConstructorCall javaConstructorCall : codeUnit.getConstructorCallsFromSelf()) {
                    this.constructorCallsByTarget.put(((AccessTarget.ConstructorCallTarget)javaConstructorCall.getTarget()).getFullName(), javaConstructorCall);
                }
            }
        }
    }
}

