/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ComparisonChain;
import java.util.HashSet;
import java.util.Objects;

public class Dependency
implements HasDescription,
Comparable<Dependency>,
HasSourceCodeLocation {
    private final JavaClass originClass;
    private final JavaClass targetClass;
    private final int lineNumber;
    private final String description;
    private final SourceCodeLocation sourceCodeLocation;

    private Dependency(JavaClass originClass, JavaClass targetClass, int lineNumber, String description) {
        this.originClass = originClass;
        this.targetClass = targetClass;
        this.lineNumber = lineNumber;
        this.description = description;
        this.sourceCodeLocation = SourceCodeLocation.of(originClass, lineNumber);
    }

    static Optional<Dependency> tryCreateFromAccess(JavaAccess<?> access) {
        if (access.getOriginOwner().equals(access.getTargetOwner()) || access.getTargetOwner().isPrimitive()) {
            return Optional.absent();
        }
        return Optional.of(new Dependency(access.getOriginOwner(), access.getTargetOwner(), access.getLineNumber(), access.getDescription()));
    }

    static Dependency fromInheritance(JavaClass origin, JavaClass targetSuperType) {
        Preconditions.checkArgument(!origin.equals(targetSuperType) && !targetSuperType.isPrimitive(), "It should never be possible to create an inheritance dependency to self or any primitive");
        String originType = origin.isInterface() ? "Interface" : "Class";
        String originDescription = originType + " " + Dependency.bracketFormat(origin.getName());
        String dependencyType = !origin.isInterface() && targetSuperType.isInterface() ? "implements" : "extends";
        String targetType = targetSuperType.isInterface() ? "interface" : "class";
        String targetDescription = Dependency.bracketFormat(targetSuperType.getName());
        String dependencyDescription = originDescription + " " + dependencyType + " " + targetType + " " + targetDescription;
        String description = dependencyDescription + " in " + origin.getSourceCodeLocation();
        return new Dependency(origin, targetSuperType, 0, description);
    }

    static Optional<Dependency> tryCreateFromField(JavaField field) {
        return Dependency.tryCreateDependencyFromJavaMember(field, "has type", field.getRawType());
    }

    static Optional<Dependency> tryCreateFromReturnType(JavaMethod method) {
        return Dependency.tryCreateDependencyFromJavaMember(method, "has return type", method.getRawReturnType());
    }

    static Optional<Dependency> tryCreateFromParameter(JavaCodeUnit codeUnit, JavaClass parameter) {
        return Dependency.tryCreateDependencyFromJavaMember(codeUnit, "has parameter of type", parameter);
    }

    static Optional<Dependency> tryCreateFromThrowsDeclaration(ThrowsDeclaration<? extends JavaCodeUnit> declaration) {
        return Dependency.tryCreateDependencyFromJavaMember(declaration.getLocation(), "throws type", declaration.getRawType());
    }

    static Optional<Dependency> tryCreateFromAnnotation(JavaAnnotation<?> target) {
        Origin origin = Dependency.findSuitableOrigin(target);
        return Dependency.tryCreateDependency(origin.originClass, origin.originDescription, "is annotated with", target.getRawType());
    }

    static Optional<Dependency> tryCreateFromAnnotationMember(JavaAnnotation<?> annotation, JavaClass memberType) {
        Origin origin = Dependency.findSuitableOrigin(annotation);
        return Dependency.tryCreateDependency(origin.originClass, origin.originDescription, "has annotation member of type", memberType);
    }

    private static Origin findSuitableOrigin(JavaAnnotation<?> annotation) {
        CanBeAnnotated annotatedElement = annotation.getAnnotatedElement();
        if (annotatedElement instanceof JavaMember) {
            JavaMember member = (JavaMember)annotatedElement;
            return new Origin(member.getOwner(), member.getDescription());
        }
        if (annotatedElement instanceof JavaClass) {
            JavaClass clazz = (JavaClass)annotatedElement;
            return new Origin(clazz, clazz.getDescription());
        }
        throw new IllegalStateException("Could not find suitable dependency origin for " + annotation);
    }

    private static Optional<Dependency> tryCreateDependencyFromJavaMember(JavaMember origin, String dependencyType, JavaClass target) {
        return Dependency.tryCreateDependency(origin.getOwner(), origin.getDescription(), dependencyType, target);
    }

    private static Optional<Dependency> tryCreateDependency(JavaClass originClass, String originDescription, String dependencyType, JavaClass targetClass) {
        if (originClass.equals(targetClass) || targetClass.isPrimitive()) {
            return Optional.absent();
        }
        String targetDescription = Dependency.bracketFormat(targetClass.getName());
        String dependencyDescription = originDescription + " " + dependencyType + " " + targetDescription;
        String description = dependencyDescription + " in " + originClass.getSourceCodeLocation();
        return Optional.of(new Dependency(originClass, targetClass, 0, description));
    }

    private static String bracketFormat(String name) {
        return "<" + name + ">";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOriginClass() {
        return this.originClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getTargetClass() {
        return this.targetClass;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return this.description;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int compareTo(Dependency o) {
        return ComparisonChain.start().compare(this.lineNumber, o.lineNumber).compare((Comparable<?>)((Object)this.getDescription()), (Comparable<?>)((Object)o.getDescription())).result();
    }

    public int hashCode() {
        return Objects.hash(this.originClass, this.targetClass, this.lineNumber, this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return Objects.equals(this.originClass, other.originClass) && Objects.equals(this.targetClass, other.targetClass) && Objects.equals(this.lineNumber, other.lineNumber) && Objects.equals(this.description, other.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("originClass", this.originClass).add("targetClass", this.targetClass).add("lineNumber", this.lineNumber).add("description", this.description).toString();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static JavaClasses toTargetClasses(Iterable<Dependency> dependencies) {
        HashSet<JavaClass> classes = new HashSet<JavaClass>();
        for (Dependency dependency : dependencies) {
            classes.add(dependency.getTargetClass());
        }
        return JavaClasses.of(classes);
    }

    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<Dependency, JavaClass> GET_ORIGIN_CLASS = new ChainableFunction<Dependency, JavaClass>(){

            @Override
            public JavaClass apply(Dependency input) {
                return input.getOriginClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<Dependency, JavaClass> GET_TARGET_CLASS = new ChainableFunction<Dependency, JavaClass>(){

            @Override
            public JavaClass apply(Dependency input) {
                return input.getTargetClass();
            }
        };

        private Functions() {
        }
    }

    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependency(Class<?> originClass, Class<?> targetClass) {
            return Predicates.dependencyOrigin(originClass).and(Predicates.dependencyTarget(targetClass)).as("dependency %s -> %s", originClass.getName(), targetClass.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependency(String originClassName, String targetClassName) {
            return Predicates.dependencyOrigin(originClassName).and(Predicates.dependencyTarget(targetClassName)).as("dependency %s -> %s", originClassName, targetClassName);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependency(DescribedPredicate<? super JavaClass> originPredicate, DescribedPredicate<? super JavaClass> targetPredicate) {
            return Predicates.dependencyOrigin(originPredicate).and(Predicates.dependencyTarget(targetPredicate)).as("dependency %s -> %s", originPredicate.getDescription(), targetPredicate.getDescription());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyOrigin(Class<?> clazz) {
            return Predicates.dependencyOrigin(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyOrigin(String className) {
            return Predicates.dependencyOrigin(HasName.Predicates.name(className).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyOrigin(DescribedPredicate<? super JavaClass> predicate) {
            return Functions.GET_ORIGIN_CLASS.is(predicate).as("origin " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyTarget(Class<?> clazz) {
            return Predicates.dependencyTarget(clazz.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyTarget(String className) {
            return Predicates.dependencyTarget(HasName.Predicates.name(className).as(className, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<Dependency> dependencyTarget(DescribedPredicate<? super JavaClass> predicate) {
            return Functions.GET_TARGET_CLASS.is(predicate).as("target " + predicate.getDescription(), new Object[0]);
        }
    }

    private static class Origin {
        private final JavaClass originClass;
        private final String originDescription;

        private Origin(JavaClass originClass, String originDescription) {
            this.originClass = originClass;
            this.originDescription = originDescription;
        }
    }
}

