/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

class AnnotationValueFormatter
implements Function<Object, String> {
    private final Function<List<String>, String> arrayFormatter;
    private final Function<Class<?>, String> typeFormatter;
    private final Function<String, String> stringFormatter;

    private AnnotationValueFormatter(Builder builder) {
        this.arrayFormatter = Preconditions.checkNotNull(builder.arrayFormatter);
        this.typeFormatter = Preconditions.checkNotNull(builder.typeFormatter);
        this.stringFormatter = Preconditions.checkNotNull(builder.stringFormatter);
    }

    @Override
    public String apply(Object input) {
        if (input instanceof Class) {
            return this.typeFormatter.apply((Class)input);
        }
        if (input instanceof String) {
            return this.stringFormatter.apply((String)input);
        }
        if (!input.getClass().isArray()) {
            return String.valueOf(input);
        }
        ArrayList<String> elemToString = new ArrayList<String>();
        for (int i = 0; i < Array.getLength(input); ++i) {
            elemToString.add("" + this.apply(Array.get(input, i)));
        }
        return this.arrayFormatter.apply(elemToString);
    }

    static Builder configure() {
        return new Builder();
    }

    static class Builder {
        private Function<List<String>, String> arrayFormatter;
        private Function<Class<?>, String> typeFormatter;
        private Function<String, String> stringFormatter = Function.Functions.identity();

        Builder() {
        }

        Builder formattingArraysWithSquareBrackets() {
            this.arrayFormatter = new Function<List<String>, String>(){

                @Override
                public String apply(List<String> input) {
                    return "[" + Joiner.on(", ").join(input) + "]";
                }
            };
            return this;
        }

        Builder formattingArraysWithCurlyBrackets() {
            this.arrayFormatter = new Function<List<String>, String>(){

                @Override
                public String apply(List<String> input) {
                    return "{" + Joiner.on(", ").join(input) + "}";
                }
            };
            return this;
        }

        Builder formattingTypesToString() {
            this.typeFormatter = new Function<Class<?>, String>(){

                @Override
                public String apply(Class<?> input) {
                    return String.valueOf(input);
                }
            };
            return this;
        }

        Builder formattingTypesAsClassNames() {
            this.typeFormatter = new Function<Class<?>, String>(){

                @Override
                public String apply(Class<?> input) {
                    return input.getName() + ".class";
                }
            };
            return this;
        }

        Builder quotingStrings() {
            this.stringFormatter = new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return "\"" + input + "\"";
                }
            };
            return this;
        }

        AnnotationValueFormatter build() {
            return new AnnotationValueFormatter(this);
        }
    }
}

