/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.InitialConfiguration;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.domain.DomainPlugin;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@MayResolveTypesViaReflection(reason="We depend on the classpath, if we proxy an annotation type")
class AnnotationProxy {
    private static final InitialConfiguration<Function<Object, String>> valueFormatter = new InitialConfiguration();

    AnnotationProxy() {
    }

    public static <A extends Annotation> A of(Class<A> annotationType, JavaAnnotation<?> toProxy) {
        Preconditions.checkArgument(annotationType.getName().equals(toProxy.getRawType().getName()), "Requested annotation type %s is incompatible with %s of type %s", (Object)annotationType.getSimpleName(), (Object)JavaAnnotation.class.getSimpleName(), (Object)toProxy.getRawType().getSimpleName());
        return AnnotationProxy.newProxy(annotationType, toProxy);
    }

    private static <A extends Annotation> A newProxy(Class<A> annotationType, JavaAnnotation<?> toProxy) {
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationMethodInvocationHandler(annotationType, toProxy)));
    }

    private static <F> Object[] convertArray(Object[] input, Conversion<F> elementConversion, Class<?> targetType) {
        Object[] result = (Object[])Array.newInstance(targetType, input.length);
        for (int i = 0; i < input.length; ++i) {
            result[i] = elementConversion.convert(input[i], targetType);
        }
        return result;
    }

    static {
        DomainPlugin.Loader.loadForCurrentPlatform().plugInAnnotationValueFormatter(valueFormatter);
    }

    private static class MethodKey {
        private final String name;
        private final List<String> paramTypeNames;

        private MethodKey(String name, String ... paramTypeNames) {
            this(name, ImmutableList.copyOf(paramTypeNames));
        }

        private MethodKey(String name, ImmutableList<String> paramTypeNames) {
            this.name = name;
            this.paramTypeNames = paramTypeNames;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.paramTypeNames);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.paramTypeNames, other.paramTypeNames);
        }

        public static MethodKey of(Method method) {
            ImmutableList.Builder paramTypeNames = ImmutableList.builder();
            for (Class<?> type : method.getParameterTypes()) {
                paramTypeNames.add(type.getName());
            }
            return new MethodKey(method.getName(), (ImmutableList<String>)paramTypeNames.build());
        }
    }

    private static class Conversions {
        private final Set<Conversion<?>> conversions;

        private Conversions(Conversion<?> ... conversions) {
            this.conversions = ImmutableSet.copyOf(conversions);
        }

        <T> Object convertIfNecessary(T result, Class<?> returnType) {
            if (returnType.isInstance(result)) {
                return result;
            }
            return ((Conversion)this.tryFindConversionFor(returnType).or(new NoOpConversion())).convert(result, returnType);
        }

        private <F> Optional<Conversion<F>> tryFindConversionFor(Class<?> returnType) {
            for (Conversion<?> conversion : this.conversions) {
                if (!conversion.canHandle(returnType)) continue;
                return Optional.of(conversion);
            }
            return Optional.absent();
        }

        private static class NoOpConversion<T>
        implements Conversion<T> {
            private NoOpConversion() {
            }

            @Override
            public T convert(T input, Class<?> returnType) {
                return input;
            }

            @Override
            public boolean canHandle(Class<?> returnType) {
                return true;
            }
        }
    }

    private static class ToStringHandler
    implements SpecificHandler {
        private final Class<?> annotationType;
        private final JavaAnnotation<?> toProxy;
        private final Conversions conversions;

        private ToStringHandler(Class<?> annotationType, JavaAnnotation<?> toProxy, Conversions conversions) {
            this.annotationType = annotationType;
            this.toProxy = toProxy;
            this.conversions = conversions;
        }

        @Override
        public Object handle(Object proxy, Method method, Object[] args) {
            return String.format("@%s(%s)", this.toProxy.getRawType().getName(), this.propertyStrings());
        }

        private String propertyStrings() {
            HashSet<String> properties = new HashSet<String>();
            for (Map.Entry<String, Object> entry : this.toProxy.getProperties().entrySet()) {
                Class<?> returnType = this.getDeclaredMethod(entry.getKey()).getReturnType();
                String value = (String)((Function)valueFormatter.get()).apply(this.conversions.convertIfNecessary(entry.getValue(), returnType));
                properties.add(entry.getKey() + "=" + value);
            }
            return Joiner.on(", ").join(properties);
        }

        private Method getDeclaredMethod(String name) {
            try {
                return this.annotationType.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class HashCodeHandler
    implements SpecificHandler {
        private HashCodeHandler() {
        }

        @Override
        public Object handle(Object proxy, Method method, Object[] args) {
            return System.identityHashCode(proxy);
        }
    }

    private static class EqualsHandler
    implements SpecificHandler {
        private EqualsHandler() {
        }

        @Override
        public Object handle(Object proxy, Method method, Object[] args) {
            return proxy == args[0];
        }
    }

    private static class ConstantReturnValueHandler
    implements SpecificHandler {
        private final Object value;

        private ConstantReturnValueHandler(Object value) {
            this.value = value;
        }

        @Override
        public Object handle(Object proxy, Method method, Object[] args) {
            return this.value;
        }
    }

    private static interface SpecificHandler {
        public Object handle(Object var1, Method var2, Object[] var3);
    }

    private static class JavaAnnotationArrayConversion
    implements Conversion<Object[]> {
        private final JavaAnnotationConversion annotationConversion;

        private JavaAnnotationArrayConversion(JavaAnnotationConversion annotationConversion) {
            this.annotationConversion = annotationConversion;
        }

        @Override
        public Object convert(Object[] input, Class<?> returnType) {
            return AnnotationProxy.convertArray(input, this.annotationConversion, returnType.getComponentType());
        }

        @Override
        public boolean canHandle(Class<?> returnType) {
            return returnType.getComponentType() != null && returnType.getComponentType().isAnnotation();
        }
    }

    private static class JavaAnnotationConversion
    implements Conversion<JavaAnnotation<?>> {
        private final ClassLoader classLoader;

        private JavaAnnotationConversion(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Annotation convert(JavaAnnotation<?> input, Class<?> returnType) {
            Class<?> type = JavaType.From.javaClass(input.getRawType()).resolveClass(this.classLoader);
            return AnnotationProxy.of(type, input);
        }

        @Override
        public boolean canHandle(Class<?> returnType) {
            return returnType.isAnnotation();
        }
    }

    private static class JavaEnumConstantArrayConversion
    implements Conversion<Object[]> {
        private final JavaEnumConstantConversion enumConversion;

        private JavaEnumConstantArrayConversion(JavaEnumConstantConversion enumConversion) {
            this.enumConversion = enumConversion;
        }

        @Override
        public Object convert(Object[] input, Class<?> returnType) {
            return AnnotationProxy.convertArray(input, this.enumConversion, returnType.getComponentType());
        }

        @Override
        public boolean canHandle(Class<?> returnType) {
            return returnType.getComponentType() != null && returnType.getComponentType().isEnum();
        }
    }

    private static class JavaEnumConstantConversion
    implements Conversion<JavaEnumConstant> {
        private JavaEnumConstantConversion() {
        }

        public Enum<?> convert(JavaEnumConstant input, Class<?> returnType) {
            for (Object constant : JavaType.From.javaClass(input.getDeclaringClass()).resolveClass().getEnumConstants()) {
                Enum anEnum = (Enum)constant;
                if (!anEnum.name().equals(input.name())) continue;
                return anEnum;
            }
            throw new IllegalStateException(String.format("Couldn't find Enum Constant %s.%s", input.getDeclaringClass().getSimpleName(), input.name()));
        }

        @Override
        public boolean canHandle(Class<?> returnType) {
            return returnType.isEnum();
        }
    }

    private static class JavaClassArrayConversion
    implements Conversion<Object[]> {
        private final JavaClassConversion javaClassConversion;

        private JavaClassArrayConversion(JavaClassConversion javaClassConversion) {
            this.javaClassConversion = javaClassConversion;
        }

        @Override
        public Object convert(Object[] input, Class<?> returnType) {
            return AnnotationProxy.convertArray(input, this.javaClassConversion, returnType.getComponentType());
        }

        @Override
        public boolean canHandle(Class<?> returnType) {
            return Class[].class.isAssignableFrom(returnType);
        }
    }

    private static class JavaClassConversion
    implements Conversion<JavaClass> {
        private final ClassLoader classLoader;

        private JavaClassConversion(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Class<?> convert(JavaClass input, Class<?> returnType) {
            return JavaType.From.javaClass(input).resolveClass(this.classLoader);
        }

        @Override
        public boolean canHandle(Class<?> returnType) {
            return Class.class.isAssignableFrom(returnType);
        }
    }

    private static interface Conversion<F> {
        public Object convert(F var1, Class<?> var2);

        public boolean canHandle(Class<?> var1);
    }

    private static class AnnotationMethodInvocationHandler
    implements InvocationHandler {
        private final JavaAnnotation<?> toProxy;
        private final Conversions conversions;
        private final Map<MethodKey, SpecificHandler> handlersByMethod;

        private AnnotationMethodInvocationHandler(Class<?> annotationType, JavaAnnotation<?> toProxy) {
            this.toProxy = toProxy;
            this.conversions = this.initConversions(annotationType);
            this.handlersByMethod = this.initHandlersByMethod(annotationType, toProxy, this.conversions);
        }

        private Conversions initConversions(Class<?> annotationType) {
            JavaClassConversion javaClassConversion = new JavaClassConversion(annotationType.getClassLoader());
            JavaEnumConstantConversion enumConversion = new JavaEnumConstantConversion();
            JavaAnnotationConversion annotationConversion = new JavaAnnotationConversion(annotationType.getClassLoader());
            return new Conversions(new Conversion[]{javaClassConversion, new JavaClassArrayConversion(javaClassConversion), enumConversion, new JavaEnumConstantArrayConversion(enumConversion), annotationConversion, new JavaAnnotationArrayConversion(annotationConversion)});
        }

        private ImmutableMap<MethodKey, SpecificHandler> initHandlersByMethod(Class<?> annotationType, JavaAnnotation<?> toProxy, Conversions conversions) {
            return ImmutableMap.of(new MethodKey("annotationType", new String[0]), new ConstantReturnValueHandler(annotationType), new MethodKey("equals", new String[]{Object.class.getName()}), new EqualsHandler(), new MethodKey("hashCode", new String[0]), new HashCodeHandler(), new MethodKey("toString", new String[0]), new ToStringHandler(annotationType, toProxy, conversions));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            MethodKey key = MethodKey.of(method);
            if (this.handlersByMethod.containsKey(key)) {
                return this.handlersByMethod.get(key).handle(proxy, method, args);
            }
            Object result = this.toProxy.get(method.getName()).or(method.getDefaultValue());
            return this.conversions.convertIfNecessary(result, method.getReturnType());
        }
    }
}

