/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public abstract class Optional<T> {
    private Optional() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> of(T object) {
        Preconditions.checkNotNull(object, "Object may not be null");
        return new Present(object);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> fromNullable(T object) {
        return object == null ? new Absent() : new Present(object);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> Optional<T> absent() {
        return Absent.getInstance();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract boolean isPresent();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T get();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T getOrThrow(RuntimeException var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract <U> Optional<U> transform(Function<? super T, U> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T orNull();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract T or(T var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Optional<T> or(Optional<T> var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public abstract Set<T> asSet();

    private static class Present<T>
    extends Optional<T> {
        private final T object;

        private Present(T object) {
            this.object = object;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.object;
        }

        @Override
        public T orNull() {
            return this.object;
        }

        @Override
        public T or(T value) {
            return this.object;
        }

        @Override
        public Optional<T> or(Optional<T> value) {
            return this;
        }

        @Override
        public Set<T> asSet() {
            return Collections.singleton(this.object);
        }

        @Override
        public T getOrThrow(RuntimeException e) {
            return this.object;
        }

        @Override
        public <U> Optional<U> transform(Function<? super T, U> function) {
            return Optional.of(function.apply(this.object));
        }

        public int hashCode() {
            return Objects.hash(this.object);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Present other = (Present)obj;
            return Objects.equals(this.object, other.object);
        }
    }

    private static class Absent<T>
    extends Optional<T> {
        private static final Absent<Object> INSTANCE = new Absent();

        private Absent() {
        }

        private static <T> Absent<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T get() {
            throw new NullPointerException("Object is absent");
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        public T or(T value) {
            return value;
        }

        @Override
        public Optional<T> or(Optional<T> value) {
            return value;
        }

        @Override
        public Set<T> asSet() {
            return Collections.emptySet();
        }

        @Override
        public T getOrThrow(RuntimeException e) {
            throw e;
        }

        @Override
        public <U> Optional<U> transform(Function<? super T, U> function) {
            return Absent.absent();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof Absent;
        }
    }
}

