/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public abstract class DescribedPredicate<T>
implements Predicate<T> {
    private final String description;
    private static final DescribedPredicate<Object> ALWAYS_TRUE = new DescribedPredicate<Object>("always true", new Object[0]){

        @Override
        public boolean apply(Object input) {
            return true;
        }
    };
    private static final DescribedPredicate<Object> ALWAYS_FALSE = new DescribedPredicate<Object>("always false", new Object[0]){

        @Override
        public boolean apply(Object input) {
            return false;
        }
    };

    public DescribedPredicate(String description, Object ... params) {
        Preconditions.checkArgument(description != null, "Description must be set");
        this.description = String.format(description, params);
    }

    public String getDescription() {
        return this.description;
    }

    public DescribedPredicate<T> as(String description, Object ... params) {
        return new AsPredicate(this, description, params);
    }

    public DescribedPredicate<T> and(DescribedPredicate<? super T> other) {
        return new AndPredicate<T>(this, other);
    }

    public DescribedPredicate<T> or(DescribedPredicate<? super T> other) {
        return new OrPredicate<T>(this, other);
    }

    public <F> DescribedPredicate<F> onResultOf(Function<? super F, ? extends T> function) {
        return new OnResultOfPredicate<F, T>(this, function);
    }

    public <U extends T> DescribedPredicate<U> forSubType() {
        return this;
    }

    public String toString() {
        return this.getDescription();
    }

    public static <T> DescribedPredicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> DescribedPredicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> DescribedPredicate<T> equalTo(T object) {
        return new EqualToPredicate<T>(object);
    }

    public static <T extends Comparable<T>> DescribedPredicate<T> lessThan(T value) {
        return new LessThanPredicate<T>(value);
    }

    public static <T extends Comparable<T>> DescribedPredicate<T> greaterThan(T value) {
        return new GreaterThanPredicate<T>(value);
    }

    public static <T extends Comparable<T>> DescribedPredicate<T> lessThanOrEqualTo(T value) {
        return new LessThanOrEqualToPredicate<T>(value);
    }

    public static <T extends Comparable<T>> DescribedPredicate<T> greaterThanOrEqualTo(T value) {
        return new GreaterThanOrEqualToPredicate<T>(value);
    }

    public static <T> DescribedPredicate<T> describe(String description, Predicate<? super T> predicate) {
        return new DescribePredicate<T>(description, predicate).forSubType();
    }

    public static <T> DescribedPredicate<T> doesNot(DescribedPredicate<? super T> predicate) {
        return DescribedPredicate.not(predicate).as("does not %s", predicate.getDescription()).forSubType();
    }

    public static <T> DescribedPredicate<T> doNot(DescribedPredicate<? super T> predicate) {
        return DescribedPredicate.not(predicate).as("do not %s", predicate.getDescription()).forSubType();
    }

    public static <T> DescribedPredicate<T> not(DescribedPredicate<? super T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static DescribedPredicate<Iterable<?>> empty() {
        return new EmptyPredicate();
    }

    public static <T> DescribedPredicate<Iterable<T>> anyElementThat(DescribedPredicate<? super T> predicate) {
        return new AnyElementPredicate<T>(predicate);
    }

    public static <T> DescribedPredicate<Iterable<T>> allElements(DescribedPredicate<? super T> predicate) {
        return new AllElementsPredicate<T>(predicate);
    }

    private static class AllElementsPredicate<T>
    extends DescribedPredicate<Iterable<T>> {
        private final DescribedPredicate<T> predicate;

        AllElementsPredicate(DescribedPredicate<? super T> predicate) {
            super("all elements " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubType();
        }

        @Override
        public boolean apply(Iterable<T> iterable) {
            for (T javaClass : iterable) {
                if (this.predicate.apply(javaClass)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AnyElementPredicate<T>
    extends DescribedPredicate<Iterable<T>> {
        private final DescribedPredicate<T> predicate;

        AnyElementPredicate(DescribedPredicate<? super T> predicate) {
            super("any element that " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubType();
        }

        @Override
        public boolean apply(Iterable<T> iterable) {
            for (T javaClass : iterable) {
                if (!this.predicate.apply(javaClass)) continue;
                return true;
            }
            return false;
        }
    }

    private static class EmptyPredicate
    extends DescribedPredicate<Iterable<?>> {
        EmptyPredicate() {
            super("empty", new Object[0]);
        }

        @Override
        public boolean apply(Iterable<?> input) {
            return Iterables.isEmpty(input);
        }
    }

    private static class DescribePredicate<T>
    extends DescribedPredicate<T> {
        private final Predicate<T> delegate;

        DescribePredicate(String description, Predicate<T> predicate) {
            super(description, new Object[0]);
            this.delegate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(T input) {
            return this.delegate.apply(input);
        }
    }

    private static class GreaterThanOrEqualToPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        GreaterThanOrEqualToPredicate(T value) {
            super("greater than or equal to '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean apply(T input) {
            return input.compareTo(this.value) >= 0;
        }
    }

    private static class LessThanOrEqualToPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        LessThanOrEqualToPredicate(T value) {
            super("less than or equal to '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean apply(T input) {
            return input.compareTo(this.value) <= 0;
        }
    }

    private static class GreaterThanPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        GreaterThanPredicate(T value) {
            super("greater than '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean apply(T input) {
            return input.compareTo(this.value) > 0;
        }
    }

    private static class LessThanPredicate<T extends Comparable<T>>
    extends DescribedPredicate<T> {
        private final T value;

        LessThanPredicate(T value) {
            super("less than '%s'", value);
            this.value = (Comparable)Preconditions.checkNotNull(value);
        }

        @Override
        public boolean apply(T input) {
            return input.compareTo(this.value) < 0;
        }
    }

    private static class EqualToPredicate<T>
    extends DescribedPredicate<T> {
        private final T value;

        EqualToPredicate(T value) {
            super("equal to '%s'", value);
            this.value = Preconditions.checkNotNull(value);
        }

        @Override
        public boolean apply(T input) {
            return this.value.equals(input);
        }
    }

    private static class NotPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> predicate;

        NotPredicate(DescribedPredicate<? super T> predicate) {
            super("not " + predicate.getDescription(), new Object[0]);
            this.predicate = Preconditions.checkNotNull(predicate).forSubType();
        }

        @Override
        public boolean apply(T input) {
            return !this.predicate.apply(input);
        }
    }

    private static class OnResultOfPredicate<F, T>
    extends DescribedPredicate<F> {
        private final DescribedPredicate<T> current;
        private final Function<? super F, ? extends T> function;

        OnResultOfPredicate(DescribedPredicate<T> current, Function<? super F, ? extends T> function) {
            super(current.getDescription(), new Object[0]);
            this.current = Preconditions.checkNotNull(current);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean apply(F input) {
            return this.current.apply(this.function.apply(input));
        }
    }

    private static class OrPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> current;
        private final DescribedPredicate<? super T> other;

        OrPredicate(DescribedPredicate<T> current, DescribedPredicate<? super T> other) {
            super(current.getDescription() + " or " + other.getDescription(), new Object[0]);
            this.current = Preconditions.checkNotNull(current);
            this.other = Preconditions.checkNotNull(other);
        }

        @Override
        public boolean apply(T input) {
            return this.current.apply(input) || this.other.apply(input);
        }
    }

    private static class AndPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> current;
        private final DescribedPredicate<? super T> other;

        AndPredicate(DescribedPredicate<T> current, DescribedPredicate<? super T> other) {
            super(current.getDescription() + " and " + other.getDescription(), new Object[0]);
            this.current = Preconditions.checkNotNull(current);
            this.other = Preconditions.checkNotNull(other);
        }

        @Override
        public boolean apply(T input) {
            return this.current.apply(input) && this.other.apply(input);
        }
    }

    private static class AsPredicate<T>
    extends DescribedPredicate<T> {
        private final DescribedPredicate<T> current;

        AsPredicate(DescribedPredicate<T> current, String description, Object ... params) {
            super(description, params);
            this.current = current;
        }

        @Override
        public boolean apply(T input) {
            return this.current.apply(input);
        }
    }
}

