/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchConfiguration {
    @Internal
    public static final String ARCHUNIT_PROPERTIES_RESOURCE_NAME = "archunit.properties";
    @Internal
    public static final String RESOLVE_MISSING_DEPENDENCIES_FROM_CLASS_PATH = "resolveMissingDependenciesFromClassPath";
    static final String CLASS_RESOLVER = "classResolver";
    static final String CLASS_RESOLVER_ARGS = "classResolver.args";
    @Internal
    public static final String ENABLE_MD5_IN_CLASS_SOURCES = "enableMd5InClassSources";
    private static final String EXTENSION_PREFIX = "extension";
    private static final Logger LOG = LoggerFactory.getLogger(ArchConfiguration.class);
    private static final Supplier<ArchConfiguration> INSTANCE = Suppliers.memoize(new Supplier<ArchConfiguration>(){

        @Override
        public ArchConfiguration get() {
            return new ArchConfiguration();
        }
    });
    private final String propertiesResourceName;
    private final PropertiesOverwritableBySystemProperties properties = new PropertiesOverwritableBySystemProperties();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchConfiguration get() {
        return INSTANCE.get();
    }

    private ArchConfiguration() {
        this(ARCHUNIT_PROPERTIES_RESOURCE_NAME);
    }

    private ArchConfiguration(String propertiesResourceName) {
        this.propertiesResourceName = propertiesResourceName;
        this.readProperties(propertiesResourceName);
    }

    private void readProperties(String propertiesResourceName) {
        this.properties.clear();
        URL archUnitPropertiesUrl = ClassLoaders.getCurrentClassLoader(this.getClass()).getResource(propertiesResourceName);
        if (archUnitPropertiesUrl == null) {
            LOG.debug("No configuration found in classpath at {} => Using default configuration", (Object)propertiesResourceName);
            return;
        }
        try (InputStream inputStream = archUnitPropertiesUrl.openStream();){
            LOG.info("Reading ArchUnit properties from {}", (Object)archUnitPropertiesUrl);
            this.properties.load(inputStream);
        }
        catch (IOException e) {
            LOG.warn("Error reading ArchUnit properties from " + archUnitPropertiesUrl, (Throwable)e);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void reset() {
        this.readProperties(this.propertiesResourceName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean resolveMissingDependenciesFromClassPath() {
        return Boolean.parseBoolean(this.properties.getProperty(RESOLVE_MISSING_DEPENDENCIES_FROM_CLASS_PATH));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setResolveMissingDependenciesFromClassPath(boolean newValue) {
        this.properties.setProperty(RESOLVE_MISSING_DEPENDENCIES_FROM_CLASS_PATH, String.valueOf(newValue));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean md5InClassSourcesEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(ENABLE_MD5_IN_CLASS_SOURCES));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setMd5InClassSourcesEnabled(boolean enabled) {
        this.properties.setProperty(ENABLE_MD5_IN_CLASS_SOURCES, String.valueOf(enabled));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<String> getClassResolver() {
        return Optional.fromNullable(this.properties.getProperty(CLASS_RESOLVER));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setClassResolver(Class<? extends ClassResolver> classResolver) {
        this.properties.setProperty(CLASS_RESOLVER, classResolver.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void unsetClassResolver() {
        this.properties.remove(CLASS_RESOLVER);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<String> getClassResolverArguments() {
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToList(this.properties.getProperty(CLASS_RESOLVER_ARGS, ""));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setClassResolverArguments(String ... args) {
        this.properties.setProperty(CLASS_RESOLVER_ARGS, Joiner.on(",").join(args));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setExtensionProperties(String extensionIdentifier, Properties properties) {
        String propertyPrefix = this.getFullExtensionPropertyPrefix(extensionIdentifier);
        this.clearPropertiesWithPrefix(propertyPrefix);
        for (String propertyName : properties.stringPropertyNames()) {
            String fullPropertyName = propertyPrefix + "." + propertyName;
            this.properties.setProperty(fullPropertyName, properties.getProperty(propertyName));
        }
    }

    private void clearPropertiesWithPrefix(String propertyPrefix) {
        for (String propertyToRemove : ArchConfiguration.filterNamesWithPrefix(this.properties.stringPropertyNames(), propertyPrefix)) {
            this.properties.remove(propertyToRemove);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Properties getExtensionProperties(String extensionIdentifier) {
        String propertyPrefix = this.getFullExtensionPropertyPrefix(extensionIdentifier);
        return this.getSubProperties(propertyPrefix);
    }

    private String getFullExtensionPropertyPrefix(String extensionIdentifier) {
        return "extension." + extensionIdentifier;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ExtensionProperties configureExtension(String extensionIdentifier) {
        return new ExtensionProperties(extensionIdentifier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Properties getSubProperties(String propertyPrefix) {
        return ArchConfiguration.getSubProperties(propertyPrefix, this.properties.getMergedProperties());
    }

    private static Properties getSubProperties(String propertyPrefix, Properties properties) {
        Properties result = new Properties();
        for (String key : ArchConfiguration.filterNamesWithPrefix(properties.stringPropertyNames(), propertyPrefix)) {
            String extensionPropertyKey = ArchConfiguration.removePrefix(key, propertyPrefix);
            result.put(extensionPropertyKey, properties.getProperty(key));
        }
        return result;
    }

    private static Iterable<String> filterNamesWithPrefix(Iterable<String> propertyNames, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        String fullPrefix = prefix + ".";
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith(fullPrefix)) continue;
            result.add(propertyName);
        }
        return result;
    }

    private static String removePrefix(String string, String prefix) {
        return string.substring(prefix.length() + 1);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getProperty(String propertyName) {
        return Preconditions.checkNotNull(this.properties.getProperty(propertyName), "Property '%s' is not configured", (Object)propertyName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getPropertyOrDefault(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public final class ExtensionProperties {
        private final String extensionIdentifier;

        private ExtensionProperties(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ExtensionProperties setProperty(String key, Object value) {
            String fullKey = Joiner.on(".").join(ArchConfiguration.EXTENSION_PREFIX, this.extensionIdentifier, key);
            ArchConfiguration.this.properties.setProperty(fullKey, String.valueOf(value));
            return this;
        }
    }

    private static class PropertiesOverwritableBySystemProperties {
        private static final Properties PROPERTY_DEFAULTS = PropertiesOverwritableBySystemProperties.createProperties(ImmutableMap.of("resolveMissingDependenciesFromClassPath", Boolean.TRUE.toString(), "enableMd5InClassSources", Boolean.FALSE.toString()));
        private final Properties properties = PropertiesOverwritableBySystemProperties.createProperties(PROPERTY_DEFAULTS);

        private PropertiesOverwritableBySystemProperties() {
        }

        void clear() {
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)PROPERTY_DEFAULTS);
        }

        void load(InputStream inputStream) throws IOException {
            this.properties.load(inputStream);
        }

        Set<String> stringPropertyNames() {
            return this.getMergedProperties().stringPropertyNames();
        }

        boolean containsKey(String propertyName) {
            return this.getMergedProperties().containsKey(propertyName);
        }

        String getProperty(String propertyName) {
            return this.getMergedProperties().getProperty(propertyName);
        }

        String getProperty(String propertyName, String defaultValue) {
            return this.getMergedProperties().getProperty(propertyName, defaultValue);
        }

        void setProperty(String propertyName, String value) {
            this.properties.setProperty(propertyName, value);
        }

        void remove(String propertyName) {
            this.properties.remove(propertyName);
        }

        Properties getMergedProperties() {
            Properties result = PropertiesOverwritableBySystemProperties.createProperties(this.properties);
            Properties overwritten = ArchConfiguration.getSubProperties("archunit", System.getProperties());
            if (!overwritten.isEmpty()) {
                LOG.info("Merging properties: The following properties have been overwritten by system properties: {}", (Object)overwritten);
            }
            result.putAll((Map<?, ?>)overwritten);
            return result;
        }

        private static Properties createProperties(Map<?, ?> entries) {
            Properties result = new Properties();
            result.putAll(entries);
            return result;
        }
    }
}

