/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.ValueWidget;
import com.twosigma.beakerx.widget.Widget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Box
extends ValueWidget<String> {
    public static final String CHILDREN = "children";
    public static final String IPY_MODEL = "IPY_MODEL_";
    public static final String VIEW_NAME_VALUE = "BoxView";
    public static final String MODEL_NAME_VALUE = "BoxModel";
    private List<Widget> children;

    public Box(List<Widget> children) {
        this.children = children;
    }

    public Box(List<Widget> children, Message parent) {
        super(parent);
        this.children = children;
    }

    public List<Widget> getChildren() {
        return this.children;
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        List<String> commIds = this.comIds();
        content.put(CHILDREN, (Serializable)commIds.toArray());
        super.content(content);
        return content;
    }

    public void add(Widget widget, Message parent) {
        this.children.add(widget);
        this.updateChildren(parent);
    }

    public void add(Widget widget) {
        this.children.add(widget);
        this.updateChildren();
    }

    public void add(int index, Widget widget) {
        this.children.add(index, widget);
        this.updateChildren();
    }

    public void add(int index, Widget widget, Message parent) {
        this.children.add(index, widget);
        this.updateChildren(parent);
    }

    public void removeAllChildren() {
        ArrayList<Widget> ch = new ArrayList<Widget>(this.getChildren());
        ch.forEach(this::remove);
    }

    public void remove(Widget widget) {
        widget.close();
        this.children.remove(widget);
        this.updateChildren();
    }

    private void updateChildren() {
        List<String> commIds = this.comIds();
        this.sendUpdate(CHILDREN, commIds.toArray());
    }

    private void updateChildren(Message parent) {
        List<String> commIds = this.comIds();
        this.sendUpdate(CHILDREN, commIds.toArray(), parent);
    }

    private List<String> comIds() {
        return this.children.stream().map(x -> IPY_MODEL + x.getComm().getCommId()).collect(Collectors.toList());
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    @Override
    public String getValueFromObject(Object input) {
        return this.getString(input);
    }

    @Override
    public void display() {
        this.activateWidgetInContainer();
        super.display();
    }

    @Override
    public void activateWidgetInContainer() {
        this.children.forEach(Widget::activateWidgetInContainer);
    }
}

