/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.util.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Comm {
    public static final String METHOD = "method";
    public static final String UPDATE = "update";
    public static final String STATE = "state";
    public static final String VERSION = "version";
    public static final String COMM_ID = "comm_id";
    public static final String TARGET_NAME = "target_name";
    public static final String DATA = "data";
    public static final String METADATA = "metadata";
    public static final String TARGET_MODULE = "target_module";
    public static final String COMMS = "comms";
    public static final String BUFFER_PATHS = "buffer_paths";
    private String commId;
    private String targetName;
    private Data data;
    private HashMap<?, ?> metadata;
    private String targetModule;
    private KernelFunctionality kernel;
    private List<Handler<Message>> msgCallbackList = new ArrayList<Handler<Message>>();
    private List<Handler<Message>> closeCallbackList = new ArrayList<Handler<Message>>();
    private GetParentMessageStrategy getParentMessageStrategy = InternalVariable::getParentHeader;

    public Comm(String commId, String targetName, Message parentMessage) {
        this(commId, targetName);
        this.getParentMessageStrategy = () -> parentMessage;
    }

    public Comm(String commId, String targetName) {
        this.kernel = KernelManager.get();
        this.commId = commId;
        this.targetName = targetName;
        this.data = new Data(new HashMap());
        this.metadata = new HashMap();
    }

    public Comm(String commId, TargetNamesEnum targetName) {
        this(commId, targetName.getTargetName());
    }

    public Comm(TargetNamesEnum targetName) {
        this(Utils.commUUID(), targetName.getTargetName());
    }

    public Comm(String targetName) {
        this(Utils.commUUID(), targetName);
    }

    public String getCommId() {
        return this.commId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Data getData() {
        return new Data(new HashMap(this.data.getData()));
    }

    public void setData(HashMap<?, ?> data) {
        this.data = new Data(data);
    }

    public void setMetaData(HashMap<?, ?> metadata) {
        this.metadata = metadata;
    }

    public String getTargetModule() {
        return this.targetModule;
    }

    public void setTargetModule(String targetModule) {
        this.targetModule = targetModule;
    }

    public void addMsgCallbackList(Handler<Message> ... handlers) {
        this.msgCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearMsgCallbackList() {
        this.msgCallbackList = new ArrayList<Handler<Message>>();
    }

    public List<Handler<Message>> getCloseCallbackList() {
        return this.closeCallbackList;
    }

    public void addCloseCallbackList(Handler<Message> ... handlers) {
        this.closeCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearCloseCallbackList() {
        this.closeCallbackList = new ArrayList<Handler<Message>>();
    }

    public void open() {
        this.doOpen(this.getParentMessage(), Buffer.EMPTY);
    }

    public void open(Buffer buffer) {
        this.doOpen(this.getParentMessage(), buffer);
    }

    public void open(Message parentMessage) {
        this.getParentMessageStrategy = () -> parentMessage;
        this.doOpen(parentMessage, Buffer.EMPTY);
    }

    private void doOpen(Message parentMessage, Buffer buffer) {
        Preconditions.checkNotNull(parentMessage, "parent message can not be null");
        Message message = new Message(new Header(JupyterMessages.COMM_OPEN, parentMessage.getHeader().getSession()));
        message.setParentHeader(parentMessage.getHeader());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(TARGET_NAME, (Serializable)((Object)this.getTargetName()));
        HashMap<String, Serializable> state = new HashMap<String, Serializable>();
        state.put(STATE, this.data.getData());
        state.put(METHOD, (Serializable)this.data.getData().get(METHOD));
        if (!buffer.isEmpty()) {
            state.put(BUFFER_PATHS, buffer.getBufferPaths());
            message.setBuffers(buffer.getBuffers());
        }
        map.put(DATA, state);
        map.put(METADATA, this.metadata);
        map.put(TARGET_MODULE, (Serializable)((Object)this.getTargetModule()));
        message.setContent(map);
        message.setMetadata(Comm.buildMetadata());
        this.kernel.publish(Collections.singletonList(message));
        this.kernel.addComm(this.getCommId(), this);
    }

    public void close() {
        Message parentMessage = this.getParentMessage();
        if (this.getCloseCallbackList() != null && !this.getCloseCallbackList().isEmpty()) {
            for (Handler<Message> handler : this.getCloseCallbackList()) {
                handler.handle(parentMessage);
            }
        }
        Message message = new Message(new Header(JupyterMessages.COMM_CLOSE, parentMessage.getHeader().getSession()));
        if (parentMessage != null) {
            message.setParentHeader(parentMessage.getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(DATA, new HashMap());
        map.put(METADATA, new HashMap());
        message.setContent(map);
        message.setMetadata(Comm.buildMetadata());
        this.kernel.removeComm(this.getCommId());
        this.kernel.publish(Collections.singletonList(message));
    }

    public void send(Buffer buffer, Data data) {
        this.send(JupyterMessages.COMM_MSG, buffer, data);
    }

    public void send(JupyterMessages type, Data data) {
        this.send(type, Buffer.EMPTY, data);
    }

    public void send(JupyterMessages type, Buffer buffer, Data data) {
        Message message = this.createMessage(type, buffer, data);
        this.kernel.publish(Collections.singletonList(message));
    }

    public Message createMessage(JupyterMessages type, Buffer buffer, Data data, Message parent) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        if (type != JupyterMessages.DISPLAY_DATA) {
            map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        }
        map.put(DATA, data.getData());
        map.put(METADATA, this.metadata);
        return this.create(type, buffer, map, parent);
    }

    public Message createMessage(JupyterMessages type, Buffer buffer, Data data) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        if (type != JupyterMessages.DISPLAY_DATA) {
            map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        }
        map.put(DATA, data.getData());
        map.put(METADATA, this.metadata);
        return this.create(type, buffer, map);
    }

    private Message create(JupyterMessages type, Buffer buffer, Map<String, Serializable> content, Message parent) {
        return Comm.messageMessage(type, buffer, content, parent);
    }

    private Message create(JupyterMessages type, Buffer buffer, Map<String, Serializable> content) {
        return Comm.messageMessage(type, buffer, content, this.getParentMessage());
    }

    public static Message messageMessage(JupyterMessages type, Buffer buffer, Map<String, Serializable> content, Message parentMessage) {
        Message message = new Message(new Header(type, parentMessage.getHeader().getSession()));
        Preconditions.checkNotNull(parentMessage);
        message.setParentHeader(parentMessage.getHeader());
        message.setContent(content);
        message.setMetadata(Comm.buildMetadata());
        if (!buffer.isEmpty()) {
            message.setBuffers(buffer.getBuffers());
        }
        return message;
    }

    public void publish(List<Message> list) {
        this.kernel.publish(list);
    }

    public void sendUpdate(Buffer buffer) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(METHOD, UPDATE);
        HashMap state = new HashMap();
        content.put(STATE, state);
        content.put(BUFFER_PATHS, buffer.getBufferPaths());
        this.send(buffer, new Data(content));
    }

    public Message createOutputContent(Map<String, Serializable> content) {
        return this.create(JupyterMessages.STREAM, Buffer.EMPTY, content);
    }

    public void sendUpdate(String propertyName, Object value) {
        Message message = this.createUpdateMessage(propertyName, value);
        this.kernel.publish(Collections.singletonList(message));
    }

    public void sendUpdate(String propertyName, Object value, Message parent) {
        Message message = this.createUpdateMessage(propertyName, value, parent);
        this.kernel.publish(Collections.singletonList(message));
    }

    public Message createUpdateMessage(String propertyName, Object value, Message parent) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(METHOD, UPDATE);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(propertyName, value);
        content.put(STATE, state);
        content.put(BUFFER_PATHS, new HashMap());
        return this.createMessage(JupyterMessages.COMM_MSG, Buffer.EMPTY, new Data(content), parent);
    }

    public Message createUpdateMessage(String propertyName, Object value) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(METHOD, UPDATE);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(propertyName, value);
        content.put(STATE, state);
        content.put(BUFFER_PATHS, new HashMap());
        return this.createMessage(JupyterMessages.COMM_MSG, Buffer.EMPTY, new Data(content));
    }

    public void handleMsg(Message parentMessage) {
        for (Handler<Message> handler : this.msgCallbackList) {
            handler.handle(parentMessage);
        }
    }

    private static HashMap<String, Serializable> buildMetadata() {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        metadata.put(VERSION, (Serializable)((Object)"2"));
        return metadata;
    }

    public String toString() {
        return this.commId + "/" + this.targetName + "/" + (this.targetModule != null && !this.targetModule.isEmpty() ? this.targetModule : "");
    }

    public Message getParentMessage() {
        return this.getParentMessageStrategy.getParentMessage();
    }

    public static class Buffer {
        public static final Buffer EMPTY = new Buffer(Collections.EMPTY_LIST, new ArrayList<List<String>>());
        private List<byte[]> buffers;
        private ArrayList<List<String>> bufferPaths;

        public Buffer(List<byte[]> buffers, ArrayList<List<String>> bufferPaths) {
            this.buffers = buffers;
            this.bufferPaths = bufferPaths;
        }

        public List<byte[]> getBuffers() {
            return this.buffers;
        }

        public ArrayList<List<String>> getBufferPaths() {
            return this.bufferPaths;
        }

        public boolean isEmpty() {
            return this.buffers.isEmpty();
        }
    }

    public static class Data {
        private HashMap<?, ?> data;

        public Data(HashMap<?, ?> data) {
            this.data = data;
        }

        public HashMap<?, ?> getData() {
            return this.data;
        }
    }

    static interface GetParentMessageStrategy {
        public Message getParentMessage();
    }
}

