/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteNode;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.AutocompleteService;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.util.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AutocompleteServiceBeakerx
implements AutocompleteService {
    private static final String LAST_SPACE = " ";
    private MagicCommandAutocompletePatterns magicPatterns;

    public AutocompleteServiceBeakerx(MagicCommandAutocompletePatterns magicCommandAutocompletePatterns) {
        this.magicPatterns = Preconditions.checkNotNull(magicCommandAutocompletePatterns);
    }

    @Override
    public AutocompleteResult find(String txt, int cur) {
        String expression = txt.substring(0, cur);
        LinkedList<String> parts = new LinkedList<String>(Arrays.asList(MagicCommandUtils.splitPath(expression)));
        Optional<AutocompleteResult> result = expression.endsWith(LAST_SPACE) ? this.findNextWord(txt, parts, cur) : this.matchToTheWord(txt, parts, expression);
        return result.orElseGet(() -> this.doAutocomplete(txt, cur));
    }

    private Optional<AutocompleteResult> findNextWord(String text, LinkedList<String> parts, int cur) {
        String first = parts.removeFirst();
        Optional<AutocompleteNode> node = this.magicPatterns.get(first);
        return node.flatMap(x -> x.findNextWord(text, parts));
    }

    private Optional<AutocompleteResult> matchToTheWord(String text, LinkedList<String> parts, String txt) {
        if (parts.size() == 1) {
            List<AutocompleteNode> collect = this.findMatches(this.magicPatterns.values(), txt);
            if (collect.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new AutocompleteResult(collect.stream().map(AutocompleteNode::getName).collect(Collectors.toList()), 0));
        }
        if (parts.size() > 1) {
            String last = parts.removeLast();
            String first = parts.removeFirst();
            Optional<AutocompleteNode> node = this.magicPatterns.get(first);
            return node.flatMap(x -> x.matchToTheWord(text, parts, last));
        }
        return Optional.empty();
    }

    @NotNull
    private List<AutocompleteNode> findMatches(Collection<AutocompleteNode> nodes, String txt) {
        return nodes.stream().filter(x -> x.getName().startsWith(txt)).filter(x -> !x.getName().equals(txt)).collect(Collectors.toList());
    }

    protected abstract AutocompleteResult doAutocomplete(String var1, int var2);
}

