/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.twosigma.beakerx.BeakerXJsonSerializer;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.table.TableDisplayToJson;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public abstract class BaseBeakerXJsonSerializer
implements BeakerXJsonSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BeakerObjectConverter serializer;

    public BaseBeakerXJsonSerializer() {
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.registerModule((Module)TableDisplayToJson.tableDisplayModule());
        this.serializer = this.createSerializer();
    }

    protected abstract BeakerObjectConverter createSerializer();

    @Override
    public String toJson(Object value) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator jgen = this.objectMapper.getFactory().createGenerator((Writer)sw);
            boolean success = this.serializer.writeObject(value, jgen, true);
            jgen.flush();
            sw.flush();
            if (success) {
                return sw.toString();
            }
            return value.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object fromJson(String json) {
        try {
            return this.serializer.deserialize(this.objectMapper.readTree(json), this.objectMapper);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

