/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.fastzipfilereader.MappedByteBufferResources;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

class PhysicalZipFile
implements Closeable {
    private final File file;
    private final String path;
    private MappedByteBufferResources byteBufferResources;
    NestedJarHandler nestedJarHandler;
    boolean isDeflatedToRam;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    PhysicalZipFile(File file, NestedJarHandler nestedJarHandler) throws IOException {
        FileUtils.checkCanReadAndIsFile(file);
        this.file = file;
        this.nestedJarHandler = nestedJarHandler;
        this.path = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, file.getPath());
        this.byteBufferResources = new MappedByteBufferResources(file, nestedJarHandler);
    }

    PhysicalZipFile(ByteBuffer byteBuffer, File outermostFile, String path, NestedJarHandler nestedJarHandler) throws IOException {
        this.file = outermostFile;
        this.path = path;
        this.nestedJarHandler = nestedJarHandler;
        this.isDeflatedToRam = true;
        this.byteBufferResources = new MappedByteBufferResources(byteBuffer, nestedJarHandler);
        if (this.byteBufferResources.length() == 0L) {
            throw new IOException("Zipfile is empty: " + path);
        }
    }

    PhysicalZipFile(InputStream inputStream, String path, NestedJarHandler nestedJarHandler, LogNode log) throws IOException {
        this.nestedJarHandler = nestedJarHandler;
        this.path = path;
        this.isDeflatedToRam = true;
        this.byteBufferResources = new MappedByteBufferResources(inputStream, path, nestedJarHandler, log);
        if (this.byteBufferResources.length() == 0L) {
            throw new IOException("Zipfile is empty: " + path);
        }
        this.file = this.byteBufferResources.getMappedFile();
    }

    ByteBuffer getByteBuffer(int chunkIdx) throws IOException, InterruptedException {
        return this.byteBufferResources.getByteBuffer(chunkIdx);
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public long length() {
        return this.byteBufferResources.length();
    }

    public int numChunks() {
        return this.byteBufferResources.numChunks();
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        return this.file == null ? 0 : this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PhysicalZipFile)) {
            return false;
        }
        return Objects.equals(this.file, ((PhysicalZipFile)obj).file);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.byteBufferResources != null) {
                this.byteBufferResources.close(null);
            }
            this.byteBufferResources = null;
            this.nestedJarHandler = null;
        }
    }
}

