/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import nonapi.io.github.classgraph.concurrency.SingletonMap;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.utils.LogNode;

public class MappedByteBufferResources {
    private File mappedFile;
    private boolean mappedFileIsTempFile;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private long length;
    private AtomicReferenceArray<ByteBuffer> byteBufferChunksCached;
    private SingletonMap<Integer, ByteBuffer, IOException> chunkIdxToByteBufferSingletonMap;
    private final NestedJarHandler nestedJarHandler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final int MAX_JAR_RAM_SIZE = 0x4000000;

    public MappedByteBufferResources(InputStream inputStream, String tempFileBaseName, NestedJarHandler nestedJarHandler, LogNode log) throws IOException {
        this.nestedJarHandler = nestedJarHandler;
        byte[] buf = new byte[0x4000000];
        int bufLength = buf.length;
        int totBytesRead = 0;
        int bytesRead = 0;
        while ((bytesRead = inputStream.read(buf, totBytesRead, bufLength - totBytesRead)) > 0) {
            totBytesRead += bytesRead;
        }
        if (bytesRead < 0) {
            this.wrapByteBuffer(ByteBuffer.wrap(buf, 0, totBytesRead));
        } else {
            if (log != null) {
                log.log("Could not fit downloaded URL into max RAM buffer size of 67108864 bytes, downloading to temporary file: " + tempFileBaseName + " -> " + this.mappedFile);
            }
            try {
                this.mappedFile = nestedJarHandler.makeTempFile(tempFileBaseName, true);
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Could not create temporary file: " + e);
                }
                throw e;
            }
            this.mappedFileIsTempFile = true;
            Files.write(this.mappedFile.toPath(), buf, StandardOpenOption.WRITE);
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.mappedFile, true));){
                int bytesReadCtd;
                while ((bytesReadCtd = inputStream.read(buf, 0, buf.length)) > 0) {
                    ((OutputStream)os).write(buf, 0, bytesReadCtd);
                }
            }
            this.mapFile();
        }
    }

    public MappedByteBufferResources(ByteBuffer byteBuffer, NestedJarHandler nestedJarHandler) throws IOException {
        this.nestedJarHandler = nestedJarHandler;
        this.wrapByteBuffer(byteBuffer);
    }

    public MappedByteBufferResources(File file, NestedJarHandler nestedJarHandler) throws IOException {
        this.nestedJarHandler = nestedJarHandler;
        this.mappedFile = file;
        this.mapFile();
    }

    private void wrapByteBuffer(ByteBuffer byteBuffer) {
        this.length = byteBuffer.remaining();
        this.byteBufferChunksCached = new AtomicReferenceArray(1);
        this.byteBufferChunksCached.set(0, byteBuffer);
    }

    private void mapFile() throws IOException {
        try {
            this.raf = new RandomAccessFile(this.mappedFile, "r");
            this.length = this.raf.length();
            this.fileChannel = this.raf.getChannel();
        }
        catch (IOException e) {
            this.close(null);
            throw e;
        }
        catch (IllegalArgumentException | SecurityException e) {
            this.close(null);
            throw new IOException(e);
        }
        int numByteBufferChunks = (int)((this.length + 0x7FFFFFF7L) / 0x7FFFFFF7L);
        this.byteBufferChunksCached = new AtomicReferenceArray(numByteBufferChunks);
        this.chunkIdxToByteBufferSingletonMap = new SingletonMap<Integer, ByteBuffer, IOException>(){

            @Override
            public ByteBuffer newInstance(Integer chunkIdxI, LogNode log) throws IOException {
                MappedByteBuffer byteBuffer;
                long pos = chunkIdxI.longValue() * 0x7FFFFFF7L;
                long chunkSize = Math.min(0x7FFFFFF7L, MappedByteBufferResources.this.length - pos);
                if (MappedByteBufferResources.this.fileChannel == null) {
                    throw new IOException("Cannot map a null FileChannel");
                }
                try {
                    byteBuffer = MappedByteBufferResources.this.fileChannel.map(FileChannel.MapMode.READ_ONLY, pos, chunkSize);
                }
                catch (IOException e) {
                    MappedByteBufferResources.this.close(log);
                    throw e;
                }
                catch (IllegalArgumentException | NonReadableChannelException e) {
                    MappedByteBufferResources.this.close(log);
                    throw new IOException(e);
                }
                catch (OutOfMemoryError e) {
                    try {
                        System.gc();
                        System.runFinalization();
                        byteBuffer = MappedByteBufferResources.this.fileChannel.map(FileChannel.MapMode.READ_ONLY, pos, chunkSize);
                    }
                    catch (IOException e2) {
                        MappedByteBufferResources.this.close(log);
                        throw e2;
                    }
                    catch (IllegalArgumentException | OutOfMemoryError e2) {
                        MappedByteBufferResources.this.close(log);
                        throw new IOException(e2);
                    }
                }
                MappedByteBufferResources.this.nestedJarHandler.addMappedByteBuffer(byteBuffer);
                return byteBuffer;
            }
        };
    }

    public ByteBuffer getByteBuffer(int chunkIdx) throws IOException, InterruptedException {
        if (this.closed.get()) {
            throw new IOException(this.getClass().getSimpleName() + " already closed");
        }
        if (chunkIdx < 0 || chunkIdx >= this.numChunks()) {
            throw new IOException("Chunk index out of range");
        }
        ByteBuffer cachedBuf = this.byteBufferChunksCached.get(chunkIdx);
        if (cachedBuf == null) {
            if (this.chunkIdxToByteBufferSingletonMap == null) {
                throw new IOException("chunkIdxToByteBufferSingletonMap is null");
            }
            try {
                cachedBuf = this.chunkIdxToByteBufferSingletonMap.get(chunkIdx, null);
                this.byteBufferChunksCached.set(chunkIdx, cachedBuf);
            }
            catch (SingletonMap.NullSingletonException e) {
                throw new IOException("Cannot get ByteBuffer chunk " + chunkIdx + " : " + e);
            }
        }
        return cachedBuf;
    }

    public File getMappedFile() {
        return this.mappedFile;
    }

    public long length() {
        return this.length;
    }

    public int numChunks() {
        return this.byteBufferChunksCached == null ? 0 : this.byteBufferChunksCached.length();
    }

    public void close(LogNode log) {
        if (!this.closed.getAndSet(true)) {
            if (this.chunkIdxToByteBufferSingletonMap != null) {
                this.chunkIdxToByteBufferSingletonMap.clear();
                this.chunkIdxToByteBufferSingletonMap = null;
            }
            if (this.byteBufferChunksCached != null) {
                if (this.mappedFile != null) {
                    for (int i = 0; i < this.byteBufferChunksCached.length(); ++i) {
                        ByteBuffer mappedByteBuffer = this.byteBufferChunksCached.get(i);
                        if (mappedByteBuffer == null) continue;
                        this.nestedJarHandler.unmapByteBuffer(mappedByteBuffer, null);
                        this.byteBufferChunksCached.set(i, null);
                    }
                }
                this.byteBufferChunksCached = null;
            }
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException i) {
                    // empty catch block
                }
                this.fileChannel = null;
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException i) {
                    // empty catch block
                }
                this.raf = null;
            }
            if (this.mappedFile != null) {
                block15: {
                    if (this.mappedFileIsTempFile) {
                        try {
                            this.nestedJarHandler.removeTempFile(this.mappedFile);
                        }
                        catch (IOException | SecurityException e) {
                            if (log == null) break block15;
                            log.log("Removing temporary file failed: " + this.mappedFile);
                        }
                    }
                }
                this.mappedFile = null;
            }
        }
    }
}

