/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.clustering.distance;

import org.hipparchus.clustering.distance.DistanceMeasure;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class CanberraDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -6972277381587032228L;

    @Override
    public double compute(double[] a, double[] b) throws MathIllegalArgumentException {
        MathArrays.checkEqualLength((double[])a, (double[])b);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double num = FastMath.abs((double)(a[i] - b[i]));
            double denom = FastMath.abs((double)a[i]) + FastMath.abs((double)b[i]);
            sum += num == 0.0 && denom == 0.0 ? 0.0 : num / denom;
        }
        return sum;
    }
}

