/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.io.Serializable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.AbstractRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.DefaultRealMatrixChangingVisitor;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class DiagonalMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = 20121229L;
    private final double[] data;

    public DiagonalMatrix(int dimension) throws MathIllegalArgumentException {
        super(dimension, dimension);
        this.data = new double[dimension];
    }

    public DiagonalMatrix(double[] d) {
        this(d, true);
    }

    public DiagonalMatrix(double[] d, boolean copyArray) throws NullArgumentException {
        MathUtils.checkNotNull(d);
        this.data = copyArray ? (double[])d.clone() : d;
    }

    @Override
    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws MathIllegalArgumentException {
        if (rowDimension != columnDimension) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, rowDimension, columnDimension);
        }
        return new DiagonalMatrix(rowDimension);
    }

    @Override
    public RealMatrix copy() {
        return new DiagonalMatrix(this.data);
    }

    public DiagonalMatrix add(DiagonalMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i = 0; i < dim; ++i) {
            outData[i] = this.data[i] + m.data[i];
        }
        return new DiagonalMatrix(outData, false);
    }

    public DiagonalMatrix subtract(DiagonalMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i = 0; i < dim; ++i) {
            outData[i] = this.data[i] - m.data[i];
        }
        return new DiagonalMatrix(outData, false);
    }

    public DiagonalMatrix multiply(DiagonalMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i = 0; i < dim; ++i) {
            outData[i] = this.data[i] * m.data[i];
        }
        return new DiagonalMatrix(outData, false);
    }

    @Override
    public RealMatrix multiply(final RealMatrix m) throws MathIllegalArgumentException {
        if (m instanceof DiagonalMatrix) {
            return this.multiply((DiagonalMatrix)m);
        }
        MatrixUtils.checkMultiplicationCompatible(this, m);
        RealMatrix product = m.createMatrix(m.getRowDimension(), m.getColumnDimension());
        product.walkInOptimizedOrder(new DefaultRealMatrixChangingVisitor(){

            @Override
            public double visit(int row, int column, double value) {
                return DiagonalMatrix.this.data[row] * m.getEntry(row, column);
            }
        });
        return product;
    }

    public DiagonalMatrix multiplyTransposed(DiagonalMatrix m) throws MathIllegalArgumentException {
        return this.multiply(m);
    }

    @Override
    public RealMatrix multiplyTransposed(final RealMatrix m) throws MathIllegalArgumentException {
        if (m instanceof DiagonalMatrix) {
            return this.multiplyTransposed((DiagonalMatrix)m);
        }
        MatrixUtils.checkSameColumnDimension(this, m);
        RealMatrix product = m.createMatrix(m.getColumnDimension(), m.getRowDimension());
        product.walkInOptimizedOrder(new DefaultRealMatrixChangingVisitor(){

            @Override
            public double visit(int row, int column, double value) {
                return DiagonalMatrix.this.data[row] * m.getEntry(column, row);
            }
        });
        return product;
    }

    public DiagonalMatrix transposeMultiply(DiagonalMatrix m) throws MathIllegalArgumentException {
        return this.multiply(m);
    }

    @Override
    public RealMatrix transposeMultiply(RealMatrix m) {
        if (m instanceof DiagonalMatrix) {
            return this.transposeMultiply((DiagonalMatrix)m);
        }
        return this.multiply(m);
    }

    @Override
    public double[][] getData() {
        int dim = this.getRowDimension();
        double[][] out = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            out[i][i] = this.data[i];
        }
        return out;
    }

    public double[] getDataRef() {
        return this.data;
    }

    @Override
    public double getEntry(int row, int column) throws MathIllegalArgumentException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        return row == column ? this.data[row] : 0.0;
    }

    @Override
    public void setEntry(int row, int column, double value) throws MathIllegalArgumentException {
        if (row == column) {
            MatrixUtils.checkRowIndex(this, row);
            this.data[row] = value;
        } else {
            this.ensureZero(value);
        }
    }

    @Override
    public void addToEntry(int row, int column, double increment) throws MathIllegalArgumentException {
        if (row == column) {
            MatrixUtils.checkRowIndex(this, row);
            int n = row;
            this.data[n] = this.data[n] + increment;
        } else {
            this.ensureZero(increment);
        }
    }

    @Override
    public void multiplyEntry(int row, int column, double factor) throws MathIllegalArgumentException {
        if (row == column) {
            MatrixUtils.checkRowIndex(this, row);
            int n = row;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public int getRowDimension() {
        return this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data.length;
    }

    @Override
    public double[] operate(double[] v) throws MathIllegalArgumentException {
        return this.multiply(new DiagonalMatrix(v, false)).getDataRef();
    }

    @Override
    public double[] preMultiply(double[] v) throws MathIllegalArgumentException {
        return this.operate(v);
    }

    @Override
    public RealVector preMultiply(RealVector v) throws MathIllegalArgumentException {
        double[] vectorData = v instanceof ArrayRealVector ? ((ArrayRealVector)v).getDataRef() : v.toArray();
        return MatrixUtils.createRealVector(this.preMultiply(vectorData));
    }

    private void ensureZero(double value) throws MathIllegalArgumentException {
        if (!Precision.equals(0.0, value, 1)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, FastMath.abs(value), 0);
        }
    }

    public DiagonalMatrix inverse() throws MathIllegalArgumentException {
        return this.inverse(0.0);
    }

    public DiagonalMatrix inverse(double threshold) throws MathIllegalArgumentException {
        if (this.isSingular(threshold)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
        }
        double[] result = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            result[i] = 1.0 / this.data[i];
        }
        return new DiagonalMatrix(result, false);
    }

    public boolean isSingular(double threshold) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!Precision.equals(this.data[i], 0.0, threshold)) continue;
            return true;
        }
        return false;
    }
}

