/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.multivariate;

import org.hipparchus.distribution.MultivariateRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.random.RandomGenerator;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    protected final RandomGenerator random;
    private final int dimension;

    protected AbstractMultivariateRealDistribution(RandomGenerator rng, int n) {
        this.random = rng;
        this.dimension = n;
    }

    @Override
    public void reseedRandomGenerator(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public abstract double[] sample();

    @Override
    public double[][] sample(int sampleSize) {
        if (sampleSize <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_SAMPLES, sampleSize);
        }
        double[][] out = new double[sampleSize][this.dimension];
        for (int i = 0; i < sampleSize; ++i) {
            out[i] = this.sample();
        }
        return out;
    }
}

