/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.discrete;

import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.distribution.discrete.AbstractIntegerDistribution;
import org.hipparchus.distribution.discrete.SaddlePointExpansion;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Gamma;
import org.hipparchus.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = 20160320L;
    private final NormalDistribution normal;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double p) throws MathIllegalArgumentException {
        this(p, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double p, double epsilon, int maxIterations) throws MathIllegalArgumentException {
        if (p <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.MEAN, p);
        }
        this.mean = p;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.normal = new NormalDistribution(p, FastMath.sqrt(p));
    }

    public PoissonDistribution(double p, double epsilon) throws MathIllegalArgumentException {
        this(p, epsilon, 10000000);
    }

    public PoissonDistribution(double p, int maxIterations) {
        this(p, 1.0E-12, maxIterations);
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        double ret = x < 0 || x == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (x == 0 ? -this.mean : -SaddlePointExpansion.getStirlingError(x) - SaddlePointExpansion.getDeviancePart(x, this.mean) - 0.5 * FastMath.log(Math.PI * 2) - 0.5 * FastMath.log(x));
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int x) {
        return this.normal.cumulativeProbability((double)x + 0.5);
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        return this.getMean();
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

