/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class CauchyDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double median;
    private final double scale;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double median, double scale) throws MathIllegalArgumentException {
        if (scale <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SCALE, scale);
        }
        this.scale = scale;
        this.median = median;
    }

    @Override
    public double cumulativeProbability(double x) {
        return 0.5 + FastMath.atan((x - this.median) / this.scale) / Math.PI;
    }

    public double getMedian() {
        return this.median;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        double dev = x - this.median;
        return 0.3183098861837907 * (this.scale / (dev * dev + this.scale * this.scale));
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        double ret = p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * FastMath.tan(Math.PI * (p - 0.5)));
        return ret;
    }

    @Override
    public double getNumericalMean() {
        return Double.NaN;
    }

    @Override
    public double getNumericalVariance() {
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

