/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AbstractUnivariateSolver;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;

public abstract class BaseSecantSolver
extends AbstractUnivariateSolver
implements BracketedUnivariateSolver<UnivariateFunction> {
    protected static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private AllowedSolution allowed = AllowedSolution.ANY_SIDE;
    private final Method method;

    protected BaseSecantSolver(double absoluteAccuracy, Method method) {
        super(absoluteAccuracy);
        this.method = method;
    }

    protected BaseSecantSolver(double relativeAccuracy, double absoluteAccuracy, Method method) {
        super(relativeAccuracy, absoluteAccuracy);
        this.method = method;
    }

    protected BaseSecantSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy, Method method) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
        this.method = method;
    }

    @Override
    public double solve(int maxEval, UnivariateFunction f, double min, double max, AllowedSolution allowedSolution) {
        return this.solve(maxEval, f, min, max, min + 0.5 * (max - min), allowedSolution);
    }

    @Override
    public double solve(int maxEval, UnivariateFunction f, double min, double max, double startValue, AllowedSolution allowedSolution) {
        this.allowed = allowedSolution;
        return super.solve(maxEval, f, min, max, startValue);
    }

    @Override
    public double solve(int maxEval, UnivariateFunction f, double min, double max, double startValue) {
        return this.solve(maxEval, f, min, max, startValue, AllowedSolution.ANY_SIDE);
    }

    @Override
    public BracketedUnivariateSolver.Interval solveInterval(int maxEval, UnivariateFunction f, double min, double max, double startValue) throws MathIllegalArgumentException, MathIllegalStateException {
        this.setup(maxEval, f, min, max, startValue);
        this.allowed = null;
        return this.doSolveInterval();
    }

    @Override
    protected final double doSolve() throws MathIllegalStateException {
        return this.doSolveInterval().getSide(this.allowed);
    }

    protected final BracketedUnivariateSolver.Interval doSolveInterval() throws MathIllegalStateException {
        double x0 = this.getMin();
        double x1 = this.getMax();
        double f0 = this.computeObjectiveValue(x0);
        double f1 = this.computeObjectiveValue(x1);
        if (f0 == 0.0) {
            return new BracketedUnivariateSolver.Interval(x0, f0, x0, f0);
        }
        if (f1 == 0.0) {
            return new BracketedUnivariateSolver.Interval(x1, f1, x1, f1);
        }
        this.verifyBracketing(x0, x1);
        double ftol = this.getFunctionValueAccuracy();
        double atol = this.getAbsoluteAccuracy();
        double rtol = this.getRelativeAccuracy();
        boolean inverted = false;
        do {
            double x;
            double fx;
            if ((fx = this.computeObjectiveValue(x = x1 - f1 * (x1 - x0) / (f1 - f0))) == 0.0) {
                return new BracketedUnivariateSolver.Interval(x, fx, x, fx);
            }
            if (f1 * fx < 0.0) {
                x0 = x1;
                f0 = f1;
                inverted = !inverted;
            } else {
                switch (this.method) {
                    case ILLINOIS: {
                        f0 *= 0.5;
                        break;
                    }
                    case PEGASUS: {
                        f0 *= f1 / (f1 + fx);
                        break;
                    }
                    case REGULA_FALSI: {
                        if (x != x1) break;
                        throw new MathIllegalStateException(LocalizedCoreFormats.CONVERGENCE_FAILED, new Object[0]);
                    }
                    default: {
                        throw MathRuntimeException.createInternalError();
                    }
                }
            }
            x1 = x;
            f1 = fx;
        } while (!(FastMath.abs(x1 - x0) < FastMath.max(rtol * FastMath.abs(x1), atol)) && (!(FastMath.abs(f1) < ftol) || !(this.allowed == AllowedSolution.ANY_SIDE || inverted && this.allowed == AllowedSolution.LEFT_SIDE || !inverted && this.allowed == AllowedSolution.RIGHT_SIDE || f1 <= 0.0 && this.allowed == AllowedSolution.BELOW_SIDE) && (!(f1 >= 0.0) || this.allowed != AllowedSolution.ABOVE_SIDE)));
        if (inverted) {
            return new BracketedUnivariateSolver.Interval(x1, f1, x0, f0);
        }
        return new BracketedUnivariateSolver.Interval(x0, f0, x1, f1);
    }

    protected static enum Method {
        REGULA_FALSI,
        ILLINOIS,
        PEGASUS;

    }
}

