/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import org.hipparchus.analysis.MultivariateFunction;
import org.hipparchus.analysis.interpolation.InterpolatingMicrosphere;
import org.hipparchus.analysis.interpolation.MultivariateInterpolator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;

public class MicrosphereProjectionInterpolator
implements MultivariateInterpolator {
    private final double exponent;
    private final InterpolatingMicrosphere microsphere;
    private final boolean sharedSphere;
    private final double noInterpolationTolerance;

    public MicrosphereProjectionInterpolator(int dimension, int elements, double maxDarkFraction, double darkThreshold, double background, double exponent, boolean sharedSphere, double noInterpolationTolerance) {
        this(new InterpolatingMicrosphere(dimension, elements, maxDarkFraction, darkThreshold, background, new UnitSphereRandomVectorGenerator(dimension)), exponent, sharedSphere, noInterpolationTolerance);
    }

    public MicrosphereProjectionInterpolator(InterpolatingMicrosphere microsphere, double exponent, boolean sharedSphere, double noInterpolationTolerance) throws MathIllegalArgumentException {
        if (exponent < 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, exponent, 0);
        }
        this.microsphere = microsphere;
        this.exponent = exponent;
        this.sharedSphere = sharedSphere;
        this.noInterpolationTolerance = noInterpolationTolerance;
    }

    @Override
    public MultivariateFunction interpolate(final double[][] xval, final double[] yval) throws MathIllegalArgumentException, NullArgumentException {
        if (xval == null || yval == null) {
            throw new NullArgumentException();
        }
        if (xval.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        if (xval.length != yval.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, xval.length, yval.length);
        }
        if (xval[0] == null) {
            throw new NullArgumentException();
        }
        int dimension = this.microsphere.getDimension();
        if (dimension != xval[0].length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, xval[0].length, dimension);
        }
        final InterpolatingMicrosphere m = this.sharedSphere ? this.microsphere : this.microsphere.copy();
        return new MultivariateFunction(){

            @Override
            public double value(double[] point) {
                return m.value(point, xval, yval, MicrosphereProjectionInterpolator.this.exponent, MicrosphereProjectionInterpolator.this.noInterpolationTolerance);
            }
        };
    }
}

