/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.io.Serializable;
import java.util.Arrays;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class Gradient
implements Derivative<Gradient>,
RealFieldElement<Gradient>,
Serializable {
    private static final long serialVersionUID = 20200520L;
    private final double value;
    private final double[] grad;

    private Gradient(double value, int freeParameters) {
        this.value = value;
        this.grad = new double[freeParameters];
    }

    public Gradient(double value, double ... gradient) {
        this(value, gradient.length);
        System.arraycopy(gradient, 0, this.grad, 0, this.grad.length);
    }

    public Gradient(DerivativeStructure ds) throws MathIllegalArgumentException {
        this(ds.getValue(), ds.getFreeParameters());
        MathUtils.checkDimension(ds.getOrder(), 1);
        System.arraycopy(ds.getAllDerivatives(), 1, this.grad, 0, this.grad.length);
    }

    public static Gradient constant(int freeParameters, double value) {
        return new Gradient(value, freeParameters);
    }

    public static Gradient variable(int freeParameters, int index, double value) {
        Gradient g = new Gradient(value, freeParameters);
        g.grad[index] = 1.0;
        return g;
    }

    @Override
    public Gradient newInstance(double c) {
        return new Gradient(c, new double[this.grad.length]);
    }

    @Override
    public double getReal() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public double[] getGradient() {
        return (double[])this.grad.clone();
    }

    @Override
    public int getFreeParameters() {
        return this.grad.length;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public double getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        if (orders.length != this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, orders.length, this.grad.length);
        }
        int selected = -1;
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] == 0) continue;
            if (selected >= 0 || orders[i] != 1) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, orders[i]);
            }
            selected = i;
        }
        return selected < 0 ? this.value : this.grad[selected];
    }

    public double getPartialDerivative(int n) throws MathIllegalArgumentException {
        if (n < 0 || n >= this.grad.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, n, 0, this.grad.length - 1);
        }
        return this.grad[n];
    }

    public DerivativeStructure toDerivativeStructure() {
        double[] derivatives = new double[1 + this.grad.length];
        derivatives[0] = this.value;
        System.arraycopy(this.grad, 0, derivatives, 1, this.grad.length);
        return this.getField().getConversionFactory().build(derivatives);
    }

    @Override
    public Gradient add(double a) {
        return new Gradient(this.value + a, this.grad);
    }

    @Override
    public Gradient add(Gradient a) {
        Gradient result = this.newInstance(this.value + a.value);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] + a.grad[i];
        }
        return result;
    }

    @Override
    public Gradient subtract(double a) {
        return new Gradient(this.value - a, this.grad);
    }

    @Override
    public Gradient subtract(Gradient a) {
        Gradient result = this.newInstance(this.value - a.value);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] - a.grad[i];
        }
        return result;
    }

    @Override
    public Gradient multiply(int n) {
        Gradient result = this.newInstance(this.value * (double)n);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] * (double)n;
        }
        return result;
    }

    @Override
    public Gradient multiply(double a) {
        Gradient result = this.newInstance(this.value * a);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] * a;
        }
        return result;
    }

    @Override
    public Gradient multiply(Gradient a) {
        Gradient result = this.newInstance(this.value * a.value);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] * a.value + this.value * a.grad[i];
        }
        return result;
    }

    @Override
    public Gradient divide(double a) {
        Gradient result = this.newInstance(this.value / a);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] / a;
        }
        return result;
    }

    @Override
    public Gradient divide(Gradient a) {
        double inv1 = 1.0 / a.value;
        double inv2 = inv1 * inv1;
        Gradient result = this.newInstance(this.value * inv1);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (this.grad[i] * a.value - this.value * a.grad[i]) * inv2;
        }
        return result;
    }

    @Override
    public Gradient remainder(double a) {
        return new Gradient(FastMath.IEEEremainder(this.value, a), this.grad);
    }

    @Override
    public Gradient remainder(Gradient a) {
        double rem = FastMath.IEEEremainder(this.value, a.value);
        double k = FastMath.rint((this.value - rem) / a.value);
        Gradient result = this.newInstance(rem);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = this.grad[i] - k * a.grad[i];
        }
        return result;
    }

    @Override
    public Gradient negate() {
        Gradient result = this.newInstance(-this.value);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = -this.grad[i];
        }
        return result;
    }

    @Override
    public Gradient abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public Gradient ceil() {
        return this.newInstance(FastMath.ceil(this.value));
    }

    @Override
    public Gradient floor() {
        return this.newInstance(FastMath.floor(this.value));
    }

    @Override
    public Gradient rint() {
        return this.newInstance(FastMath.rint(this.value));
    }

    @Override
    public Gradient signum() {
        return this.newInstance(FastMath.signum(this.value));
    }

    @Override
    public Gradient copySign(Gradient sign) {
        long m = Double.doubleToLongBits(this.value);
        long s = Double.doubleToLongBits(sign.value);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Gradient copySign(double sign) {
        long m = Double.doubleToLongBits(this.value);
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public int getExponent() {
        return FastMath.getExponent(this.value);
    }

    @Override
    public Gradient scalb(int n) {
        Gradient result = this.newInstance(FastMath.scalb(this.value, n));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = FastMath.scalb(this.grad[i], n);
        }
        return result;
    }

    @Override
    public Gradient hypot(Gradient y) {
        int expY;
        if (Double.isInfinite(this.value) || Double.isInfinite(y.value)) {
            return this.newInstance(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value) || Double.isNaN(y.value)) {
            return this.newInstance(Double.NaN);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        Gradient scaledX = this.scalb(-middleExp);
        Gradient scaledY = y.scalb(-middleExp);
        Gradient scaledH = scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    @Override
    public Gradient reciprocal() {
        double inv1 = 1.0 / this.value;
        double inv2 = inv1 * inv1;
        Gradient result = this.newInstance(inv1);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = -this.grad[i] * inv2;
        }
        return result;
    }

    public Gradient compose(double g0, double g1) {
        Gradient result = this.newInstance(g0);
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = g1 * this.grad[i];
        }
        return result;
    }

    @Override
    public Gradient sqrt() {
        double s = FastMath.sqrt(this.value);
        return this.compose(s, 1.0 / (2.0 * s));
    }

    @Override
    public Gradient cbrt() {
        double c = FastMath.cbrt(this.value);
        return this.compose(c, 1.0 / (3.0 * c * c));
    }

    @Override
    public Gradient rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        double r = FastMath.pow(this.value, 1.0 / (double)n);
        return this.compose(r, 1.0 / ((double)n * FastMath.pow(r, n - 1)));
    }

    public GradientField getField() {
        return GradientField.getField(this.getFreeParameters());
    }

    public static Gradient pow(double a, Gradient x) {
        if (a == 0.0) {
            return x.getField().getZero();
        }
        double aX = FastMath.pow(a, x.value);
        double aXlnA = aX * FastMath.log(a);
        Gradient result = x.newInstance(aX);
        for (int i = 0; i < x.grad.length; ++i) {
            result.grad[i] = aXlnA * x.grad[i];
        }
        return result;
    }

    @Override
    public Gradient pow(double p) {
        if (p == 0.0) {
            return this.getField().getOne();
        }
        double valuePm1 = FastMath.pow(this.value, p - 1.0);
        return this.compose(valuePm1 * this.value, p * valuePm1);
    }

    @Override
    public Gradient pow(int n) {
        if (n == 0) {
            return this.getField().getOne();
        }
        double valueNm1 = FastMath.pow(this.value, n - 1);
        return this.compose(valueNm1 * this.value, (double)n * valueNm1);
    }

    @Override
    public Gradient pow(Gradient e) {
        return this.log().multiply(e).exp();
    }

    @Override
    public Gradient exp() {
        double exp = FastMath.exp(this.value);
        return this.compose(exp, exp);
    }

    @Override
    public Gradient expm1() {
        double exp = FastMath.exp(this.value);
        double expM1 = FastMath.expm1(this.value);
        return this.compose(expM1, exp);
    }

    @Override
    public Gradient log() {
        return this.compose(FastMath.log(this.value), 1.0 / this.value);
    }

    @Override
    public Gradient log1p() {
        return this.compose(FastMath.log1p(this.value), 1.0 / (1.0 + this.value));
    }

    @Override
    public Gradient log10() {
        return this.compose(FastMath.log10(this.value), 1.0 / (this.value * FastMath.log(10.0)));
    }

    @Override
    public Gradient cos() {
        SinCos sinCos = FastMath.sinCos(this.value);
        return this.compose(sinCos.cos(), -sinCos.sin());
    }

    @Override
    public Gradient sin() {
        SinCos sinCos = FastMath.sinCos(this.value);
        return this.compose(sinCos.sin(), sinCos.cos());
    }

    @Override
    public FieldSinCos<Gradient> sinCos() {
        SinCos sinCos = FastMath.sinCos(this.value);
        Gradient sin = this.newInstance(sinCos.sin());
        Gradient cos = this.newInstance(sinCos.cos());
        for (int i = 0; i < this.grad.length; ++i) {
            sin.grad[i] = this.grad[i] * sinCos.cos();
            cos.grad[i] = -this.grad[i] * sinCos.sin();
        }
        return new FieldSinCos<Gradient>(sin, cos);
    }

    @Override
    public Gradient tan() {
        double tan = FastMath.tan(this.value);
        return this.compose(tan, 1.0 + tan * tan);
    }

    @Override
    public Gradient acos() {
        return this.compose(FastMath.acos(this.value), -1.0 / FastMath.sqrt(1.0 - this.value * this.value));
    }

    @Override
    public Gradient asin() {
        return this.compose(FastMath.asin(this.value), 1.0 / FastMath.sqrt(1.0 - this.value * this.value));
    }

    @Override
    public Gradient atan() {
        return this.compose(FastMath.atan(this.value), 1.0 / (1.0 + this.value * this.value));
    }

    @Override
    public Gradient atan2(Gradient x) {
        double inv = 1.0 / (this.value * this.value + x.value * x.value);
        Gradient result = this.newInstance(FastMath.atan2(this.value, x.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = (x.value * this.grad[i] - x.grad[i] * this.value) * inv;
        }
        return result;
    }

    @Override
    public Gradient cosh() {
        return this.compose(FastMath.cosh(this.value), FastMath.sinh(this.value));
    }

    @Override
    public Gradient sinh() {
        return this.compose(FastMath.sinh(this.value), FastMath.cosh(this.value));
    }

    @Override
    public Gradient tanh() {
        double tanh = FastMath.tanh(this.value);
        return this.compose(tanh, 1.0 - tanh * tanh);
    }

    @Override
    public Gradient acosh() {
        return this.compose(FastMath.acosh(this.value), 1.0 / FastMath.sqrt(this.value * this.value - 1.0));
    }

    @Override
    public Gradient asinh() {
        return this.compose(FastMath.asinh(this.value), 1.0 / FastMath.sqrt(this.value * this.value + 1.0));
    }

    @Override
    public Gradient atanh() {
        return this.compose(FastMath.atanh(this.value), 1.0 / (1.0 - this.value * this.value));
    }

    @Override
    public Gradient toDegrees() {
        Gradient result = this.newInstance(FastMath.toDegrees(this.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = FastMath.toDegrees(this.grad[i]);
        }
        return result;
    }

    @Override
    public Gradient toRadians() {
        Gradient result = this.newInstance(FastMath.toRadians(this.value));
        for (int i = 0; i < this.grad.length; ++i) {
            result.grad[i] = FastMath.toRadians(this.grad[i]);
        }
        return result;
    }

    public double taylor(double ... delta) {
        double result = this.value;
        for (int i = 0; i < this.grad.length; ++i) {
            result += delta[i] * this.grad[i];
        }
        return result;
    }

    public Gradient linearCombination(Gradient[] a, Gradient[] b) {
        int n = a.length;
        double[] a0 = new double[n];
        double[] b0 = new double[n];
        double[] a1 = new double[2 * n];
        double[] b1 = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            Gradient ai = a[i];
            Gradient bi = b[i];
            a0[i] = ai.value;
            b0[i] = bi.value;
            a1[2 * i] = ai.value;
            b1[2 * i + 1] = bi.value;
        }
        Gradient result = this.newInstance(MathArrays.linearCombination(a0, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                a1[2 * i + 1] = a[i].grad[k];
                b1[2 * i] = b[i].grad[k];
            }
            result.grad[k] = MathArrays.linearCombination(a1, b1);
        }
        return result;
    }

    public Gradient linearCombination(double[] a, Gradient[] b) {
        int n = b.length;
        double[] b0 = new double[n];
        double[] b1 = new double[n];
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].value;
        }
        Gradient result = this.newInstance(MathArrays.linearCombination(a, b0));
        for (int k = 0; k < this.grad.length; ++k) {
            for (int i = 0; i < n; ++i) {
                b1[i] = b[i].grad[k];
            }
            result.grad[k] = MathArrays.linearCombination(a, b1);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(Gradient a1, Gradient b1, Gradient a2, Gradient b2) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1.value, b1.grad[i], a1.grad[i], b1.value, a2.value, b2.grad[i], a2.grad[i], b2.value);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(double a1, Gradient b1, double a2, Gradient b2) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1, b1.value, a2, b2.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1, b1.grad[i], a2, b2.grad[i]);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(Gradient a1, Gradient b1, Gradient a2, Gradient b2, Gradient a3, Gradient b3) {
        double[] a = new double[]{a1.value, 0.0, a2.value, 0.0, a3.value, 0.0};
        double[] b = new double[]{0.0, b1.value, 0.0, b2.value, 0.0, b3.value};
        Gradient result = this.newInstance(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            result.grad[i] = MathArrays.linearCombination(a, b);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(double a1, Gradient b1, double a2, Gradient b2, double a3, Gradient b3) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i]);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(Gradient a1, Gradient b1, Gradient a2, Gradient b2, Gradient a3, Gradient b3, Gradient a4, Gradient b4) {
        double[] a = new double[]{a1.value, 0.0, a2.value, 0.0, a3.value, 0.0, a4.value, 0.0};
        double[] b = new double[]{0.0, b1.value, 0.0, b2.value, 0.0, b3.value, 0.0, b4.value};
        Gradient result = this.newInstance(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value, a4.value, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            a[1] = a1.grad[i];
            a[3] = a2.grad[i];
            a[5] = a3.grad[i];
            a[7] = a4.grad[i];
            b[0] = b1.grad[i];
            b[2] = b2.grad[i];
            b[4] = b3.grad[i];
            b[6] = b4.grad[i];
            result.grad[i] = MathArrays.linearCombination(a, b);
        }
        return result;
    }

    @Override
    public Gradient linearCombination(double a1, Gradient b1, double a2, Gradient b2, double a3, Gradient b3, double a4, Gradient b4) {
        Gradient result = this.newInstance(MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value, a4, b4.value));
        for (int i = 0; i < b1.grad.length; ++i) {
            result.grad[i] = MathArrays.linearCombination(a1, b1.grad[i], a2, b2.grad[i], a3, b3.grad[i], a4, b4.grad[i]);
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Gradient) {
            Gradient rhs = (Gradient)other;
            return this.value == rhs.value && MathArrays.equals(this.grad, rhs.grad);
        }
        return false;
    }

    public int hashCode() {
        return 129 + 7 * Double.hashCode(this.value) - 15 * Arrays.hashCode(this.grad);
    }
}

