/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldUnivariateDerivative2<T extends RealFieldElement<T>>
extends FieldUnivariateDerivative<T, FieldUnivariateDerivative2<T>> {
    private final T f0;
    private final T f1;
    private final T f2;

    public FieldUnivariateDerivative2(T f0, T f1, T f2) {
        this.f0 = f0;
        this.f1 = f1;
        this.f2 = f2;
    }

    public FieldUnivariateDerivative2(FieldDerivativeStructure<T> ds) throws MathIllegalArgumentException {
        MathUtils.checkDimension(ds.getFreeParameters(), 1);
        MathUtils.checkDimension(ds.getOrder(), 2);
        this.f0 = ds.getValue();
        this.f1 = ds.getPartialDerivative(1);
        this.f2 = ds.getPartialDerivative(2);
    }

    @Override
    public FieldUnivariateDerivative2<T> newInstance(double value) {
        RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)zero.newInstance(value), zero, zero);
    }

    @Override
    public double getReal() {
        return this.getValue().getReal();
    }

    @Override
    public T getValue() {
        return this.f0;
    }

    @Override
    public T getDerivative(int n) {
        switch (n) {
            case 0: {
                return this.f0;
            }
            case 1: {
                return this.f1;
            }
            case 2: {
                return this.f2;
            }
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, n);
    }

    @Override
    public int getOrder() {
        return 2;
    }

    public T getFirstDerivative() {
        return this.f1;
    }

    public T getSecondDerivative() {
        return this.f2;
    }

    public Field<T> getValueField() {
        return this.f0.getField();
    }

    @Override
    public FieldDerivativeStructure<T> toDerivativeStructure() {
        return ((FieldUnivariateDerivative2Field)this.getField()).getConversionFactory().build(new RealFieldElement[]{this.f0, this.f1, this.f2});
    }

    @Override
    public FieldUnivariateDerivative2<T> add(T a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.add(a), (RealFieldElement)this.f1, (RealFieldElement)this.f2);
    }

    @Override
    public FieldUnivariateDerivative2<T> add(double a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.add(a), (RealFieldElement)this.f1, (RealFieldElement)this.f2);
    }

    @Override
    public FieldUnivariateDerivative2<T> add(FieldUnivariateDerivative2<T> a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.add(a.f0), (RealFieldElement)this.f1.add(a.f1), (RealFieldElement)this.f2.add(a.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> subtract(T a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.subtract(a), (RealFieldElement)this.f1, (RealFieldElement)this.f2);
    }

    @Override
    public FieldUnivariateDerivative2<T> subtract(double a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.subtract(a), (RealFieldElement)this.f1, (RealFieldElement)this.f2);
    }

    @Override
    public FieldUnivariateDerivative2<T> subtract(FieldUnivariateDerivative2<T> a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.subtract(a.f0), (RealFieldElement)this.f1.subtract(a.f1), (RealFieldElement)this.f2.subtract(a.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> multiply(T a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.multiply(a), (RealFieldElement)this.f1.multiply(a), (RealFieldElement)this.f2.multiply(a));
    }

    @Override
    public FieldUnivariateDerivative2<T> multiply(int n) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.multiply((int)n), (RealFieldElement)this.f1.multiply((int)n), (RealFieldElement)this.f2.multiply((int)n));
    }

    @Override
    public FieldUnivariateDerivative2<T> multiply(double a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.multiply(a), (RealFieldElement)this.f1.multiply(a), (RealFieldElement)this.f2.multiply(a));
    }

    @Override
    public FieldUnivariateDerivative2<T> multiply(FieldUnivariateDerivative2<T> a) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.multiply(a.f0), (RealFieldElement)a.f0.linearCombination(this.f1, a.f0, this.f0, a.f1), (RealFieldElement)a.f0.linearCombination(this.f2, a.f0, this.f1.add(this.f1), a.f1, this.f0, a.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> divide(T a) {
        RealFieldElement inv1 = (RealFieldElement)a.reciprocal();
        return new FieldUnivariateDerivative2<RealFieldElement>(this.f0.multiply((RealFieldElement)inv1), this.f1.multiply((RealFieldElement)inv1), this.f2.multiply((RealFieldElement)inv1));
    }

    @Override
    public FieldUnivariateDerivative2<T> divide(double a) {
        double inv1 = 1.0 / a;
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.multiply(inv1), (RealFieldElement)this.f1.multiply(inv1), (RealFieldElement)this.f2.multiply(inv1));
    }

    @Override
    public FieldUnivariateDerivative2<T> divide(FieldUnivariateDerivative2<T> a) {
        RealFieldElement inv1 = (RealFieldElement)a.f0.reciprocal();
        RealFieldElement inv2 = inv1.multiply(inv1);
        RealFieldElement inv3 = inv1.multiply(inv2);
        return new FieldUnivariateDerivative2<RealFieldElement>(this.f0.multiply((RealFieldElement)inv1), ((RealFieldElement)a.f0.linearCombination(this.f1, a.f0, this.f0.negate(), a.f1)).multiply(inv2), ((RealFieldElement)a.f0.linearCombination(this.f2, a.f0.multiply(a.f0), (int)this.f1.multiply((int)-2), a.f0.multiply(a.f1), this.f0.add(this.f0), a.f1.multiply(a.f1), this.f0.negate(), a.f0.multiply(a.f2))).multiply(inv3));
    }

    @Override
    public FieldUnivariateDerivative2<T> remainder(T a) {
        return new FieldUnivariateDerivative2<T>(FastMath.IEEEremainder(this.f0, a), this.f1, this.f2);
    }

    @Override
    public FieldUnivariateDerivative2<T> remainder(double a) {
        return new FieldUnivariateDerivative2<double>(FastMath.IEEEremainder(this.f0, a), (double)this.f1, (double)this.f2);
    }

    @Override
    public FieldUnivariateDerivative2<T> remainder(FieldUnivariateDerivative2<T> a) {
        T rem = FastMath.IEEEremainder(this.f0, a.f0);
        RealFieldElement k = FastMath.rint((RealFieldElement)((RealFieldElement)this.f0.subtract(rem)).divide(a.f0));
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)rem, (RealFieldElement)this.f1.subtract(k.multiply(a.f1)), (RealFieldElement)this.f2.subtract(k.multiply(a.f2)));
    }

    @Override
    public FieldUnivariateDerivative2<T> negate() {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.negate(), (RealFieldElement)this.f1.negate(), (RealFieldElement)this.f2.negate());
    }

    @Override
    public FieldUnivariateDerivative2<T> abs() {
        if (Double.doubleToLongBits(this.f0.getReal()) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public FieldUnivariateDerivative2<T> ceil() {
        RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)FastMath.ceil(this.f0), zero, zero);
    }

    @Override
    public FieldUnivariateDerivative2<T> floor() {
        RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)FastMath.floor(this.f0), zero, zero);
    }

    @Override
    public FieldUnivariateDerivative2<T> rint() {
        RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)FastMath.rint(this.f0), zero, zero);
    }

    @Override
    public FieldUnivariateDerivative2<T> signum() {
        RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)FastMath.signum(this.f0), zero, zero);
    }

    @Override
    public FieldUnivariateDerivative2<T> copySign(T sign) {
        long m = Double.doubleToLongBits(this.f0.getReal());
        long s = Double.doubleToLongBits(sign.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldUnivariateDerivative2<T> copySign(FieldUnivariateDerivative2<T> sign) {
        long m = Double.doubleToLongBits(this.f0.getReal());
        long s = Double.doubleToLongBits(sign.f0.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldUnivariateDerivative2<T> copySign(double sign) {
        long m = Double.doubleToLongBits(this.f0.getReal());
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public int getExponent() {
        return FastMath.getExponent(this.f0.getReal());
    }

    @Override
    public FieldUnivariateDerivative2<T> scalb(int n) {
        return new FieldUnivariateDerivative2<T>(FastMath.scalb(this.f0, n), FastMath.scalb(this.f1, n), FastMath.scalb(this.f2, n));
    }

    @Override
    public FieldUnivariateDerivative2<T> hypot(FieldUnivariateDerivative2<T> y) {
        int expY;
        if (Double.isInfinite(this.f0.getReal()) || Double.isInfinite(y.f0.getReal())) {
            RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
            return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.newInstance(Double.POSITIVE_INFINITY), zero, zero);
        }
        if (Double.isNaN(this.f0.getReal()) || Double.isNaN(y.f0.getReal())) {
            RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
            return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)this.f0.newInstance(Double.NaN), zero, zero);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        Object scaledX = this.scalb(-middleExp);
        Object scaledY = y.scalb(-middleExp);
        Object scaledH = ((FieldUnivariateDerivative2)scaledX).multiply((FieldUnivariateDerivative2<T>)scaledX).add(((FieldUnivariateDerivative2)scaledY).multiply((FieldUnivariateDerivative2<T>)scaledY)).sqrt();
        return ((FieldUnivariateDerivative2)scaledH).scalb(middleExp);
    }

    @Override
    public FieldUnivariateDerivative2<T> reciprocal() {
        RealFieldElement inv1 = (RealFieldElement)this.f0.reciprocal();
        RealFieldElement inv2 = inv1.multiply(inv1);
        RealFieldElement inv3 = inv1.multiply(inv2);
        return new FieldUnivariateDerivative2<RealFieldElement>(inv1, ((RealFieldElement)this.f1.negate()).multiply(inv2), ((RealFieldElement)this.f0.linearCombination(this.f1.add(this.f1), this.f1, this.f0.negate(), this.f2)).multiply(inv3));
    }

    public FieldUnivariateDerivative2<T> compose(T g0, T g1, T g2) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)g0, (RealFieldElement)g1.multiply(this.f1), (RealFieldElement)this.f0.linearCombination(g1, this.f2, g2, this.f1.multiply(this.f1)));
    }

    @Override
    public FieldUnivariateDerivative2<T> sqrt() {
        T s = FastMath.sqrt(this.f0);
        return this.compose(s, (RealFieldElement)((RealFieldElement)s.add(s)).reciprocal(), (RealFieldElement)((RealFieldElement)((RealFieldElement)s.multiply((int)-4)).multiply(this.f0)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative2<T> cbrt() {
        T c = FastMath.cbrt(this.f0);
        RealFieldElement c2 = (RealFieldElement)c.multiply(c);
        return this.compose(c, (RealFieldElement)((RealFieldElement)c2.multiply(3)).reciprocal(), (RealFieldElement)((RealFieldElement)((RealFieldElement)c2.multiply(4.5)).multiply(this.f0)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative2<T> rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        T r = FastMath.pow(this.f0, 1.0 / (double)n);
        RealFieldElement z = (RealFieldElement)FastMath.pow(r, n - 1).multiply((int)n);
        return this.compose(r, (RealFieldElement)z.reciprocal(), (RealFieldElement)((RealFieldElement)((RealFieldElement)z.multiply(z).multiply(r)).reciprocal()).multiply(1 - n));
    }

    @Override
    public FieldUnivariateDerivative2Field<T> getField() {
        return FieldUnivariateDerivative2Field.getUnivariateDerivative2Field(this.f0.getField());
    }

    public static <T extends RealFieldElement<T>> FieldUnivariateDerivative2<T> pow(double a, FieldUnivariateDerivative2<T> x) {
        if (a == 0.0) {
            return ((FieldUnivariateDerivative2Field)x.getField()).getZero();
        }
        RealFieldElement aX = FastMath.pow((RealFieldElement)x.f0.newInstance(a), x.f0);
        double lnA = FastMath.log(a);
        RealFieldElement aXlnA = (RealFieldElement)aX.multiply(lnA);
        return new FieldUnivariateDerivative2<RealFieldElement>(aX, (RealFieldElement)aXlnA.multiply(x.f1), (RealFieldElement)aXlnA.multiply(((RealFieldElement)((RealFieldElement)x.f1.multiply(x.f1)).multiply(lnA)).add(x.f2)));
    }

    @Override
    public FieldUnivariateDerivative2<T> pow(double p) {
        if (p == 0.0) {
            return ((FieldUnivariateDerivative2Field)this.getField()).getOne();
        }
        T f0Pm2 = FastMath.pow(this.f0, p - 2.0);
        RealFieldElement f0Pm1 = (RealFieldElement)f0Pm2.multiply(this.f0);
        RealFieldElement f0P = (RealFieldElement)f0Pm1.multiply(this.f0);
        return this.compose(f0P, (RealFieldElement)f0Pm1.multiply(p), (RealFieldElement)f0Pm2.multiply(p * (p - 1.0)));
    }

    @Override
    public FieldUnivariateDerivative2<T> pow(int n) {
        if (n == 0) {
            return ((FieldUnivariateDerivative2Field)this.getField()).getOne();
        }
        T f0Nm2 = FastMath.pow(this.f0, n - 2);
        RealFieldElement f0Nm1 = (RealFieldElement)f0Nm2.multiply(this.f0);
        RealFieldElement f0N = (RealFieldElement)f0Nm1.multiply(this.f0);
        return this.compose(f0N, (RealFieldElement)f0Nm1.multiply(n), (RealFieldElement)f0Nm2.multiply((int)(n * (n - 1))));
    }

    @Override
    public FieldUnivariateDerivative2<T> pow(FieldUnivariateDerivative2<T> e) {
        return ((FieldUnivariateDerivative2)this.log()).multiply(e).exp();
    }

    @Override
    public FieldUnivariateDerivative2<T> exp() {
        T exp = FastMath.exp(this.f0);
        return this.compose(exp, exp, exp);
    }

    @Override
    public FieldUnivariateDerivative2<T> expm1() {
        T exp = FastMath.exp(this.f0);
        T expM1 = FastMath.expm1(this.f0);
        return this.compose(expM1, exp, exp);
    }

    @Override
    public FieldUnivariateDerivative2<T> log() {
        RealFieldElement inv = (RealFieldElement)this.f0.reciprocal();
        return this.compose(FastMath.log(this.f0), inv, (RealFieldElement)inv.multiply(inv).negate());
    }

    @Override
    public FieldUnivariateDerivative2<T> log1p() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)this.f0.add(1.0)).reciprocal();
        return this.compose(FastMath.log1p(this.f0), inv, (RealFieldElement)inv.multiply(inv).negate());
    }

    @Override
    public FieldUnivariateDerivative2<T> log10() {
        RealFieldElement invF0 = (RealFieldElement)this.f0.reciprocal();
        RealFieldElement inv = (RealFieldElement)invF0.divide(FastMath.log(10.0));
        return this.compose(FastMath.log10(this.f0), inv, (RealFieldElement)inv.multiply(invF0).negate());
    }

    @Override
    public FieldUnivariateDerivative2<T> cos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.f0);
        return this.compose((RealFieldElement)sinCos.cos(), (RealFieldElement)((RealFieldElement)sinCos.sin()).negate(), (RealFieldElement)((RealFieldElement)sinCos.cos()).negate());
    }

    @Override
    public FieldUnivariateDerivative2<T> sin() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.f0);
        return this.compose((RealFieldElement)sinCos.sin(), (RealFieldElement)sinCos.cos(), (RealFieldElement)((RealFieldElement)sinCos.sin()).negate());
    }

    @Override
    public FieldSinCos<FieldUnivariateDerivative2<T>> sinCos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.f0);
        RealFieldElement mSin = (RealFieldElement)((RealFieldElement)sinCos.sin()).negate();
        RealFieldElement mCos = (RealFieldElement)((RealFieldElement)sinCos.cos()).negate();
        return new FieldSinCos<FieldUnivariateDerivative2<T>>(this.compose((RealFieldElement)sinCos.sin(), (RealFieldElement)sinCos.cos(), mSin), this.compose((RealFieldElement)sinCos.cos(), mSin, mCos));
    }

    @Override
    public FieldUnivariateDerivative2<T> tan() {
        T tan = FastMath.tan(this.f0);
        RealFieldElement sec2 = (RealFieldElement)((RealFieldElement)tan.multiply(tan)).add(1.0);
        return this.compose(tan, sec2, (RealFieldElement)sec2.add(sec2).multiply(tan));
    }

    @Override
    public FieldUnivariateDerivative2<T> acos() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).negate()).add(1.0)).reciprocal();
        RealFieldElement mS = (RealFieldElement)((RealFieldElement)inv.sqrt()).negate();
        return this.compose(FastMath.acos(this.f0), mS, ((RealFieldElement)mS.multiply(this.f0)).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative2<T> asin() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).negate()).add(1.0)).reciprocal();
        RealFieldElement s = (RealFieldElement)inv.sqrt();
        return this.compose(FastMath.asin(this.f0), s, ((RealFieldElement)s.multiply(this.f0)).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative2<T> atan() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).add(1.0)).reciprocal();
        return this.compose(FastMath.atan(this.f0), inv, ((RealFieldElement)this.f0.multiply((int)-2)).multiply(inv).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative2<T> atan2(FieldUnivariateDerivative2<T> x) {
        RealFieldElement x2 = (RealFieldElement)x.f0.multiply(x.f0);
        RealFieldElement f02 = (RealFieldElement)this.f0.add(this.f0);
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).add(x2).reciprocal();
        T atan0 = FastMath.atan2(this.f0, x.f0);
        RealFieldElement atan1 = ((RealFieldElement)this.f0.linearCombination(x.f0, this.f1, x.f1.negate(), this.f0)).multiply(inv);
        RealFieldElement c = this.f0.linearCombination(this.f2, (RealFieldElement)x2, (RealFieldElement)this.f1.multiply((int)-2), x.f0.multiply(x.f1), (RealFieldElement)f02, x.f1.multiply(x.f1), this.f0.negate(), x.f0.multiply(x.f2)).multiply(inv);
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)atan0, atan1, (RealFieldElement)c.subtract(f02.multiply(atan1).multiply(atan1)).divide(x.f0));
    }

    @Override
    public FieldUnivariateDerivative2<T> cosh() {
        T c = FastMath.cosh(this.f0);
        T s = FastMath.sinh(this.f0);
        return this.compose(c, s, c);
    }

    @Override
    public FieldUnivariateDerivative2<T> sinh() {
        T c = FastMath.cosh(this.f0);
        T s = FastMath.sinh(this.f0);
        return this.compose(s, c, s);
    }

    @Override
    public FieldUnivariateDerivative2<T> tanh() {
        T tanh = FastMath.tanh(this.f0);
        RealFieldElement sech2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)tanh.multiply(tanh)).negate()).add(1.0);
        return this.compose(tanh, sech2, (RealFieldElement)((RealFieldElement)sech2.multiply(-2)).multiply(tanh));
    }

    @Override
    public FieldUnivariateDerivative2<T> acosh() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).subtract(1.0)).reciprocal();
        RealFieldElement s = (RealFieldElement)inv.sqrt();
        return this.compose(FastMath.acosh(this.f0), s, ((RealFieldElement)this.f0.negate()).multiply(s).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative2<T> asinh() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).add(1.0)).reciprocal();
        RealFieldElement s = (RealFieldElement)inv.sqrt();
        return this.compose(FastMath.asinh(this.f0), s, ((RealFieldElement)this.f0.negate()).multiply(s).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative2<T> atanh() {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).negate()).add(1.0)).reciprocal();
        return this.compose(FastMath.atanh(this.f0), inv, ((RealFieldElement)this.f0.add(this.f0)).multiply(inv).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative2<T> toDegrees() {
        return new FieldUnivariateDerivative2<T>(FastMath.toDegrees(this.f0), FastMath.toDegrees(this.f1), FastMath.toDegrees(this.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> toRadians() {
        return new FieldUnivariateDerivative2<T>(FastMath.toRadians(this.f0), FastMath.toRadians(this.f1), FastMath.toRadians(this.f2));
    }

    public T taylor(double delta) {
        return (T)((RealFieldElement)this.f0.add(((RealFieldElement)this.f1.add(this.f2.multiply(0.5 * delta))).multiply(delta)));
    }

    public T taylor(T delta) {
        return (T)((RealFieldElement)this.f0.add(((RealFieldElement)this.f1.add(this.f2.multiply(delta.multiply(0.5)))).multiply(delta)));
    }

    public FieldUnivariateDerivative2<T> linearCombination(T[] a, FieldUnivariateDerivative2<T>[] b) {
        Field field = b[0].f0.getField();
        int n = b.length;
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b2 = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].f0;
            b1[i] = b[i].f1;
            b2[i] = b[i].f2;
        }
        return new FieldUnivariateDerivative2<RealFieldElement>(b[0].f0.linearCombination(a, (RealFieldElement[])b0), b[0].f0.linearCombination(a, (RealFieldElement[])b1), b[0].f0.linearCombination(a, (RealFieldElement[])b2));
    }

    public FieldUnivariateDerivative2<T> linearCombination(FieldUnivariateDerivative2<T>[] a, FieldUnivariateDerivative2<T>[] b) {
        Field field = a[0].f0.getField();
        int n = a.length;
        RealFieldElement[] a0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] a1 = (RealFieldElement[])MathArrays.buildArray(field, 2 * n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, 2 * n);
        RealFieldElement[] a2 = (RealFieldElement[])MathArrays.buildArray(field, 3 * n);
        RealFieldElement[] b2 = (RealFieldElement[])MathArrays.buildArray(field, 3 * n);
        for (int i = 0; i < n; ++i) {
            FieldUnivariateDerivative2<T> ai = a[i];
            FieldUnivariateDerivative2<T> bi = b[i];
            a0[i] = ai.f0;
            b0[i] = bi.f0;
            a1[2 * i] = ai.f0;
            a1[2 * i + 1] = ai.f1;
            b1[2 * i] = bi.f1;
            b1[2 * i + 1] = bi.f0;
            a2[3 * i] = ai.f0;
            a2[3 * i + 1] = (RealFieldElement)ai.f1.add(ai.f1);
            a2[3 * i + 2] = ai.f2;
            b2[3 * i] = bi.f2;
            b2[3 * i + 1] = bi.f1;
            b2[3 * i + 2] = bi.f0;
        }
        return new FieldUnivariateDerivative2<RealFieldElement>(a[0].f0.linearCombination((RealFieldElement[])a0, (RealFieldElement[])b0), a[0].f0.linearCombination((RealFieldElement[])a1, (RealFieldElement[])b1), a[0].f0.linearCombination((RealFieldElement[])a2, (RealFieldElement[])b2));
    }

    public FieldUnivariateDerivative2<T> linearCombination(double[] a, FieldUnivariateDerivative2<T>[] b) {
        Field field = b[0].f0.getField();
        int n = b.length;
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b2 = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].f0;
            b1[i] = b[i].f1;
            b2[i] = b[i].f2;
        }
        return new FieldUnivariateDerivative2<RealFieldElement>(b[0].f0.linearCombination(a, (T[])b0), b[0].f0.linearCombination(a, (T[])b1), b[0].f0.linearCombination(a, (T[])b2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(FieldUnivariateDerivative2<T> a1, FieldUnivariateDerivative2<T> b1, FieldUnivariateDerivative2<T> a2, FieldUnivariateDerivative2<T> b2) {
        Field field = a1.f0.getField();
        RealFieldElement[] u2 = (RealFieldElement[])MathArrays.buildArray(field, 6);
        RealFieldElement[] v2 = (RealFieldElement[])MathArrays.buildArray(field, 6);
        u2[0] = a1.f0;
        u2[1] = (RealFieldElement)a1.f1.add(a1.f1);
        u2[2] = a1.f2;
        u2[3] = a2.f0;
        u2[4] = (RealFieldElement)a2.f1.add(a2.f1);
        u2[5] = a2.f2;
        v2[0] = b1.f2;
        v2[1] = b1.f1;
        v2[2] = b1.f0;
        v2[3] = b2.f2;
        v2[4] = b2.f1;
        v2[5] = b2.f0;
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0), (RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f1, a1.f1, b1.f0, a2.f0, b2.f1, a2.f1, b2.f0), a1.f0.linearCombination((RealFieldElement[])u2, (RealFieldElement[])v2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(double a1, FieldUnivariateDerivative2<T> b1, double a2, FieldUnivariateDerivative2<T> b2) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1), (RealFieldElement)b1.f0.linearCombination(a1, b1.f2, a2, b2.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(FieldUnivariateDerivative2<T> a1, FieldUnivariateDerivative2<T> b1, FieldUnivariateDerivative2<T> a2, FieldUnivariateDerivative2<T> b2, FieldUnivariateDerivative2<T> a3, FieldUnivariateDerivative2<T> b3) {
        Field field = a1.f0.getField();
        RealFieldElement[] u1 = (RealFieldElement[])MathArrays.buildArray(field, 6);
        RealFieldElement[] v1 = (RealFieldElement[])MathArrays.buildArray(field, 6);
        u1[0] = a1.f0;
        u1[1] = a1.f1;
        u1[2] = a2.f0;
        u1[3] = a2.f1;
        u1[4] = a3.f0;
        u1[5] = a3.f1;
        v1[0] = b1.f1;
        v1[1] = b1.f0;
        v1[2] = b2.f1;
        v1[3] = b2.f0;
        v1[4] = b3.f1;
        v1[5] = b3.f0;
        RealFieldElement[] u2 = (RealFieldElement[])MathArrays.buildArray(field, 9);
        RealFieldElement[] v2 = (RealFieldElement[])MathArrays.buildArray(field, 9);
        u2[0] = a1.f0;
        u2[1] = (RealFieldElement)a1.f1.add(a1.f1);
        u2[2] = a1.f2;
        u2[3] = a2.f0;
        u2[4] = (RealFieldElement)a2.f1.add(a2.f1);
        u2[5] = a2.f2;
        u2[6] = a3.f0;
        u2[7] = (RealFieldElement)a3.f1.add(a3.f1);
        u2[8] = a3.f2;
        v2[0] = b1.f2;
        v2[1] = b1.f1;
        v2[2] = b1.f0;
        v2[3] = b2.f2;
        v2[4] = b2.f1;
        v2[5] = b2.f0;
        v2[6] = b3.f2;
        v2[7] = b3.f1;
        v2[8] = b3.f0;
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0), a1.f0.linearCombination((RealFieldElement[])u1, (RealFieldElement[])v1), a1.f0.linearCombination((RealFieldElement[])u2, (RealFieldElement[])v2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(T a1, FieldUnivariateDerivative2<T> b1, T a2, FieldUnivariateDerivative2<T> b2, T a3, FieldUnivariateDerivative2<T> b3) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1), (RealFieldElement)b1.f0.linearCombination(a1, b1.f2, a2, b2.f2, a3, b3.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(double a1, FieldUnivariateDerivative2<T> b1, double a2, FieldUnivariateDerivative2<T> b2, double a3, FieldUnivariateDerivative2<T> b3) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1), (RealFieldElement)b1.f0.linearCombination(a1, b1.f2, a2, b2.f2, a3, b3.f2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(FieldUnivariateDerivative2<T> a1, FieldUnivariateDerivative2<T> b1, FieldUnivariateDerivative2<T> a2, FieldUnivariateDerivative2<T> b2, FieldUnivariateDerivative2<T> a3, FieldUnivariateDerivative2<T> b3, FieldUnivariateDerivative2<T> a4, FieldUnivariateDerivative2<T> b4) {
        Field field = a1.f0.getField();
        RealFieldElement[] u1 = (RealFieldElement[])MathArrays.buildArray(field, 8);
        RealFieldElement[] v1 = (RealFieldElement[])MathArrays.buildArray(field, 8);
        u1[0] = a1.f0;
        u1[1] = a1.f1;
        u1[2] = a2.f0;
        u1[3] = a2.f1;
        u1[4] = a3.f0;
        u1[5] = a3.f1;
        u1[6] = a4.f0;
        u1[7] = a4.f1;
        v1[0] = b1.f1;
        v1[1] = b1.f0;
        v1[2] = b2.f1;
        v1[3] = b2.f0;
        v1[4] = b3.f1;
        v1[5] = b3.f0;
        v1[6] = b4.f1;
        v1[7] = b4.f0;
        RealFieldElement[] u2 = (RealFieldElement[])MathArrays.buildArray(field, 12);
        RealFieldElement[] v2 = (RealFieldElement[])MathArrays.buildArray(field, 12);
        u2[0] = a1.f0;
        u2[1] = (RealFieldElement)a1.f1.add(a1.f1);
        u2[2] = a1.f2;
        u2[3] = a2.f0;
        u2[4] = (RealFieldElement)a2.f1.add(a2.f1);
        u2[5] = a2.f2;
        u2[6] = a3.f0;
        u2[7] = (RealFieldElement)a3.f1.add(a3.f1);
        u2[8] = a3.f2;
        u2[9] = a4.f0;
        u2[10] = (RealFieldElement)a4.f1.add(a4.f1);
        u2[11] = a4.f2;
        v2[0] = b1.f2;
        v2[1] = b1.f1;
        v2[2] = b1.f0;
        v2[3] = b2.f2;
        v2[4] = b2.f1;
        v2[5] = b2.f0;
        v2[6] = b3.f2;
        v2[7] = b3.f1;
        v2[8] = b3.f0;
        v2[9] = b4.f2;
        v2[10] = b4.f1;
        v2[11] = b4.f0;
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0, a4.f0, b4.f0), a1.f0.linearCombination((RealFieldElement[])u1, (RealFieldElement[])v1), a1.f0.linearCombination((RealFieldElement[])u2, (RealFieldElement[])v2));
    }

    @Override
    public FieldUnivariateDerivative2<T> linearCombination(double a1, FieldUnivariateDerivative2<T> b1, double a2, FieldUnivariateDerivative2<T> b2, double a3, FieldUnivariateDerivative2<T> b3, double a4, FieldUnivariateDerivative2<T> b4) {
        return new FieldUnivariateDerivative2<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0, a4, b4.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1, a4, b4.f1), (RealFieldElement)b1.f0.linearCombination(a1, b1.f2, a2, b2.f2, a3, b3.f2, a4, b4.f2));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldUnivariateDerivative2) {
            FieldUnivariateDerivative2 rhs = (FieldUnivariateDerivative2)other;
            return this.f0.equals(rhs.f0) && this.f1.equals(rhs.f1) && this.f2.equals(rhs.f2);
        }
        return false;
    }

    public int hashCode() {
        return 317 - 41 * this.f0.hashCode() + 57 * this.f1.hashCode() - 103 * this.f2.hashCode();
    }
}

