/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus;

import org.hipparchus.FieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;

public interface CalculusFieldElement<T>
extends FieldElement<T> {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;

    default public T newInstance(double value) {
        CalculusFieldElement zero = (CalculusFieldElement)this.getField().getZero();
        return zero.add(value);
    }

    public double getReal();

    @Override
    public T add(double var1);

    @Override
    public T subtract(double var1);

    @Override
    public T multiply(double var1);

    @Override
    public T divide(double var1);

    default public int getExponent() {
        return FastMath.getExponent(this.getReal());
    }

    public T scalb(int var1);

    public T hypot(T var1) throws MathIllegalArgumentException;

    @Override
    public T reciprocal();

    public T sqrt();

    public T cbrt();

    public T rootN(int var1);

    public T pow(double var1);

    public T pow(int var1);

    public T pow(T var1) throws MathIllegalArgumentException;

    public T exp();

    public T expm1();

    public T log();

    public T log1p();

    public T log10();

    public T cos();

    public T sin();

    default public FieldSinCos<T> sinCos() {
        return new FieldSinCos<T>(this.sin(), this.cos());
    }

    public T tan();

    public T acos();

    public T asin();

    public T atan();

    public T atan2(T var1) throws MathIllegalArgumentException;

    public T cosh();

    public T sinh();

    public T tanh();

    public T acosh();

    public T asinh();

    public T atanh();

    default public T toDegrees() {
        return this.multiply(57.29577951308232);
    }

    default public T toRadians() {
        return this.multiply(Math.PI / 180);
    }

    public T linearCombination(T[] var1, T[] var2) throws MathIllegalArgumentException;

    public T linearCombination(double[] var1, T[] var2) throws MathIllegalArgumentException;

    public T linearCombination(T var1, T var2, T var3, T var4);

    public T linearCombination(double var1, T var3, double var4, T var6);

    public T linearCombination(T var1, T var2, T var3, T var4, T var5, T var6);

    public T linearCombination(double var1, T var3, double var4, T var6, double var7, T var9);

    public T linearCombination(T var1, T var2, T var3, T var4, T var5, T var6, T var7, T var8);

    public T linearCombination(double var1, T var3, double var4, T var6, double var7, T var9, double var10, T var12);

    public T ceil();

    public T floor();

    public T rint();

    public T remainder(double var1);

    public T remainder(T var1);

    public T signum();

    public T copySign(T var1);

    public T copySign(double var1);

    default public boolean isInfinite() {
        return Double.isFinite(this.getReal());
    }

    default public boolean isNaN() {
        return Double.isNaN(this.getReal());
    }
}

