/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaStateInterpolator;

class MidpointStateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20160328L;

    MidpointStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected MidpointStateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new MidpointStateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double coeffDot2 = 2.0 * theta;
        double coeffDot1 = 1.0 - coeffDot2;
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double coeff1 = theta * oneMinusThetaH;
            double coeff2 = theta * thetaH;
            interpolatedState = this.previousStateLinearCombination(coeff1, coeff2);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot2);
        } else {
            double coeff1 = oneMinusThetaH * theta;
            double coeff2 = -oneMinusThetaH * (1.0 + theta);
            interpolatedState = this.currentStateLinearCombination(coeff1, coeff2);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot2);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

