/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.ode.ODEState;

public class ODEStateAndDerivative
extends ODEState {
    private static final long serialVersionUID = 20160408L;
    private final double[] primaryDerivative;
    private final double[][] secondaryDerivative;

    public ODEStateAndDerivative(double time, double[] primaryState, double[] primaryDerivative) {
        this(time, primaryState, primaryDerivative, null, null);
    }

    public ODEStateAndDerivative(double time, double[] primaryState, double[] primaryDerivative, double[][] secondaryState, double[][] secondaryDerivative) {
        super(time, primaryState, secondaryState);
        this.primaryDerivative = (double[])primaryDerivative.clone();
        this.secondaryDerivative = this.copy(secondaryDerivative);
    }

    public double[] getPrimaryDerivative() {
        return (double[])this.primaryDerivative.clone();
    }

    public double[] getSecondaryDerivative(int index) {
        return index == 0 ? (double[])this.primaryDerivative.clone() : (double[])this.secondaryDerivative[index - 1].clone();
    }

    public double[] getCompleteDerivative() {
        double[] completeDerivative = new double[this.getCompleteStateDimension()];
        System.arraycopy(this.primaryDerivative, 0, completeDerivative, 0, this.primaryDerivative.length);
        int offset = this.primaryDerivative.length;
        if (this.secondaryDerivative != null) {
            for (int index = 0; index < this.secondaryDerivative.length; ++index) {
                System.arraycopy(this.secondaryDerivative[index], 0, completeDerivative, offset, this.secondaryDerivative[index].length);
                offset += this.secondaryDerivative[index].length;
            }
        }
        return completeDerivative;
    }
}

