/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.logging.FilterHandler;
import edu.stanford.nlp.util.logging.JavaUtilLoggingAdaptor;
import edu.stanford.nlp.util.logging.JavaUtilLoggingHandler;
import edu.stanford.nlp.util.logging.LogFilter;
import edu.stanford.nlp.util.logging.LogRecordHandler;
import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.RedirectOutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RepeatedRecordHandler;
import edu.stanford.nlp.util.logging.RerouteChannel;
import edu.stanford.nlp.util.logging.VisibilityHandler;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class RedwoodConfiguration {
    private LinkedList<Runnable> tasks = new LinkedList();
    private OutputHandler outputHandler = Redwood.ConsoleHandler.out();
    private File defaultFile = new File("/dev/null");
    private int channelWidth = 0;

    protected RedwoodConfiguration() {
    }

    public void apply() {
        for (Runnable task : this.tasks) {
            task.run();
        }
    }

    public RedwoodConfiguration capture(OutputStream stream) {
        if (stream == System.out) {
            this.tasks.add(() -> Redwood.captureSystemStreams(true, Redwood.realSysErr == System.err));
        } else if (stream == System.err) {
            this.tasks.add(() -> Redwood.captureSystemStreams(Redwood.realSysOut == System.out, true));
        } else {
            throw new IllegalArgumentException("Must capture one of stderr or stdout");
        }
        return this;
    }

    public RedwoodConfiguration restore(OutputStream stream) {
        if (stream == System.out) {
            this.tasks.add(() -> Redwood.captureSystemStreams(false, Redwood.realSysErr == System.err));
        } else if (stream == System.err) {
            this.tasks.add(() -> Redwood.captureSystemStreams(Redwood.realSysOut == System.out, false));
        } else {
            throw new IllegalArgumentException("Must capture one of stderr or stdout");
        }
        return this;
    }

    public RedwoodConfiguration listenOnChannels(final Consumer<Redwood.Record> listener, final Object ... channels) {
        return this.handlers(Handlers.chain(new FilterHandler(Collections.singletonList(new LogFilter(){
            Set<Object> matchAgainst;
            {
                this.matchAgainst = new HashSet<Object>(Arrays.asList(channels));
            }

            @Override
            public boolean matches(Redwood.Record message) {
                for (Object channel : message.channels()) {
                    if (!this.matchAgainst.contains(channel)) continue;
                    return true;
                }
                return false;
            }
        }), true), (config, root) -> root.addChild(new LogRecordHandler(){

            @Override
            public List<Redwood.Record> handle(Redwood.Record record) {
                listener.accept(record);
                return Collections.singletonList(record);
            }
        })));
    }

    public RedwoodConfiguration output(String method) {
        if (method.equalsIgnoreCase("stdout") || method.equalsIgnoreCase("out")) {
            JavaUtilLoggingAdaptor.adapt();
            this.outputHandler = Redwood.ConsoleHandler.out();
        } else if (method.equalsIgnoreCase("stderr") || method.equalsIgnoreCase("err")) {
            JavaUtilLoggingAdaptor.adapt();
            this.outputHandler = Redwood.ConsoleHandler.err();
        } else if (method.equalsIgnoreCase("java.util.logging")) {
            JavaUtilLoggingAdaptor.adapt();
            this.outputHandler = RedirectOutputHandler.fromJavaUtilLogging(Logger.getLogger("``error``"));
        } else {
            throw new IllegalArgumentException("Unknown value for log.method");
        }
        return this;
    }

    public RedwoodConfiguration channelWidth(int width) {
        this.tasks.addFirst(() -> {
            this.channelWidth = width;
        });
        return this;
    }

    public RedwoodConfiguration clear() {
        this.tasks = new LinkedList();
        this.tasks.add(() -> {
            Redwood.clearHandlers();
            Redwood.restoreSystemStreams();
        });
        this.outputHandler = Redwood.ConsoleHandler.out();
        return this;
    }

    public RedwoodConfiguration handlers(Thunk ... paths) {
        for (Thunk thunk : paths) {
            this.tasks.add(() -> thunk.apply(this, Redwood.rootHandler()));
        }
        return this;
    }

    public RedwoodConfiguration neatExit() {
        this.tasks.add(() -> Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Redwood.stop();
            }
        }));
        return this;
    }

    public static RedwoodConfiguration empty() {
        return new RedwoodConfiguration().clear();
    }

    public static RedwoodConfiguration standard() {
        return new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.hideDebug, Handlers.stderr));
    }

    public static RedwoodConfiguration minimal() {
        return new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.hideChannels(new Object[0]), Handlers.hideDebug, Handlers.stderr));
    }

    public static RedwoodConfiguration slf4j() {
        return new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.hideChannels(new Object[0]), Handlers.slf4j));
    }

    public static RedwoodConfiguration debugLevel() {
        RedwoodConfiguration config;
        try {
            MetaClass.create("org.slf4j.LoggerFactory").createInstance(new Object[0]);
            config = new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.showAllChannels(), Handlers.slf4j));
        }
        catch (Exception ignored) {
            config = new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.showAllChannels(), Handlers.stderr));
        }
        return config;
    }

    public static RedwoodConfiguration infoLevel() {
        RedwoodConfiguration config;
        try {
            MetaClass.create("org.slf4j.LoggerFactory").createInstance(new Object[0]);
            config = new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.hideChannels(new Object[]{Redwood.DBG}), Handlers.slf4j));
        }
        catch (Exception ignored) {
            config = new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.hideChannels(new Object[]{Redwood.DBG}), Handlers.stderr));
        }
        return config;
    }

    public static RedwoodConfiguration errorLevel() {
        RedwoodConfiguration config;
        try {
            MetaClass.create("org.slf4j.LoggerFactory").createInstance(new Object[0]);
            config = new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.showOnlyError, Handlers.slf4j));
        }
        catch (Exception ignored) {
            config = new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.showOnlyError, Handlers.stderr));
        }
        return config;
    }

    public static RedwoodConfiguration javaUtilLogging() {
        return new RedwoodConfiguration().clear().handlers(Handlers.chain(Handlers.hideChannels(new Object[0]), Handlers.javaUtil));
    }

    public static RedwoodConfiguration current() {
        return new RedwoodConfiguration();
    }

    private static String get(Properties p, String key, String defaultValue, Set<String> used) {
        String rtn = p.getProperty(key, defaultValue);
        used.add(key);
        return rtn;
    }

    public static RedwoodConfiguration parse(Properties props) {
        String outputFile;
        RedwoodConfiguration config = new RedwoodConfiguration().clear();
        Set<String> used = Generics.newHashSet();
        if (RedwoodConfiguration.get(props, "log.captureStreams", "false", used).equalsIgnoreCase("true")) {
            config = config.capture(System.out).capture(System.err);
        }
        if (RedwoodConfiguration.get(props, "log.captureStdout", "false", used).equalsIgnoreCase("true")) {
            config = config.capture(System.out);
        }
        if (RedwoodConfiguration.get(props, "log.captureStderr", "false", used).equalsIgnoreCase("true")) {
            config = config.capture(System.err);
        }
        String collapse = RedwoodConfiguration.get(props, "log.collapse", "none", used);
        LinkedList<LogRecordHandler> chain = new LinkedList<LogRecordHandler>();
        if (collapse.equalsIgnoreCase("exact")) {
            chain.add(new RepeatedRecordHandler(RepeatedRecordHandler.EXACT));
        } else if (collapse.equalsIgnoreCase("approximate")) {
            chain.add(new RepeatedRecordHandler(RepeatedRecordHandler.APPROXIMATE));
        } else if (!collapse.equalsIgnoreCase("none")) {
            throw new IllegalArgumentException("Unknown collapse mode (Redwood): " + collapse);
        }
        boolean debug = Boolean.parseBoolean(RedwoodConfiguration.get(props, "log.channels.debug", "true", used));
        if (!debug) {
            chain.add(Handlers.hideDebug);
        }
        config.channelWidth(Integer.parseInt(RedwoodConfiguration.get(props, "log.channels.width", "0", used)));
        if (RedwoodConfiguration.get(props, "log.neatExit", "false", used).equalsIgnoreCase("true")) {
            config = config.neatExit();
        }
        if ((outputFile = RedwoodConfiguration.get(props, "log.file", null, used)) != null) {
            config.defaultFile = new File(outputFile);
            config = config.handlers(Handlers.defaultFile);
        }
        config = config.output(RedwoodConfiguration.get(props, "log.output", "stdout", used));
        config = config.handlers(Handlers.chain(chain.toArray(new LogRecordHandler[chain.size()]), Handlers.output));
        for (Object propAsObj : props.keySet()) {
            String prop = propAsObj.toString();
            if (!prop.startsWith("log.") || used.contains(prop)) continue;
            throw new IllegalArgumentException("Could not find Redwood log property: " + prop);
        }
        return config;
    }

    public static void apply(Properties props) {
        RedwoodConfiguration.parse(props).apply();
    }

    public static class Handlers {
        public static final Thunk defaultFile = new Thunk(){

            @Override
            public void apply(final RedwoodConfiguration config, Redwood.RecordHandlerTree root) {
                root.addChild(new Redwood.FileHandler(config.defaultFile.getPath()){
                    {
                        super(filename);
                        this.leftMargin = config.channelWidth;
                    }
                });
            }
        };
        public static final Thunk stdout = (config, root) -> {
            Redwood.ConsoleHandler handler = Redwood.ConsoleHandler.out();
            handler.leftMargin = config.channelWidth;
            root.addChild(handler);
        };
        public static final Thunk stderr = (config, root) -> {
            Redwood.ConsoleHandler handler = Redwood.ConsoleHandler.err();
            handler.leftMargin = config.channelWidth;
            root.addChild(handler);
        };
        public static final Thunk slf4j = (config, root) -> {
            try {
                OutputHandler handler = (OutputHandler)MetaClass.create("edu.stanford.nlp.util.logging.SLF4JHandler").createInstance(new Object[0]);
                handler.leftMargin = config.channelWidth;
                root.addChild(handler);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not find SLF4J in your classpath", e);
            }
        };
        public static final Thunk javaUtil = (config, root) -> {
            try {
                JavaUtilLoggingHandler handler = new JavaUtilLoggingHandler();
                handler.leftMargin = config.channelWidth;
                root.addChild(handler);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not find java.util.logging in your classpath", e);
            }
        };
        public static final Thunk output = (config, root) -> {
            ((RedwoodConfiguration)config).outputHandler.leftMargin = config.channelWidth;
            root.addChild(config.outputHandler);
        };
        public static final LogRecordHandler hideDebug = new VisibilityHandler(){
            {
                this.alsoHide((Object)Redwood.DBG);
            }
        };
        public static final LogRecordHandler showOnlyError = new VisibilityHandler(){
            {
                this.hideAll();
                this.alsoShow((Object)Redwood.ERR);
            }
        };
        public static final LogRecordHandler collapseApproximate = new RepeatedRecordHandler(RepeatedRecordHandler.APPROXIMATE);
        public static final LogRecordHandler collapseExact = new RepeatedRecordHandler(RepeatedRecordHandler.EXACT);
        public static Thunk noop = (config, root) -> {};

        public static Thunk file(final String path) {
            return new Thunk(){

                @Override
                public void apply(final RedwoodConfiguration config, Redwood.RecordHandlerTree root) {
                    root.addChild(new Redwood.FileHandler(path){
                        {
                            super(filename);
                            this.leftMargin = config.channelWidth;
                        }
                    });
                }
            };
        }

        public static Thunk file(File path) {
            return Handlers.file(path.getPath());
        }

        public static LogRecordHandler hideChannels(final Object ... channelsToHide) {
            return new VisibilityHandler(){
                {
                    for (Object channel : channelsToHide) {
                        this.alsoHide(channel);
                    }
                }
            };
        }

        public static LogRecordHandler showAllChannels() {
            return new VisibilityHandler();
        }

        public static LogRecordHandler showOnlyChannels(final Object ... channelsToShow) {
            return new VisibilityHandler(){
                {
                    this.hideAll();
                    for (Object channel : channelsToShow) {
                        this.alsoShow(channel);
                    }
                }
            };
        }

        public static LogRecordHandler reroute(Object src, Object dst) {
            return new RerouteChannel(src, dst);
        }

        public static Thunk branch(Thunk ... destinations) {
            return (config, root) -> {
                for (Thunk destination : destinations) {
                    destination.apply(config, root);
                }
            };
        }

        public static Thunk chain(final LogRecordHandler[] handlers, final Thunk destination) {
            return new Thunk(){

                private Redwood.RecordHandlerTree buildChain(RedwoodConfiguration config, LogRecordHandler[] handlers2, int i) {
                    Redwood.RecordHandlerTree rtn = new Redwood.RecordHandlerTree(handlers2[i]);
                    if (i < handlers2.length - 1) {
                        rtn.addChildTree(this.buildChain(config, handlers2, i + 1));
                    } else {
                        destination.apply(config, rtn);
                    }
                    return rtn;
                }

                @Override
                public void apply(RedwoodConfiguration config, Redwood.RecordHandlerTree root) {
                    if (handlers.length == 0) {
                        destination.apply(config, root);
                    } else {
                        root.addChildTree(this.buildChain(config, handlers, 0));
                    }
                }
            };
        }

        public static Thunk chain(LogRecordHandler handler1, Thunk destination) {
            return Handlers.chain(new LogRecordHandler[]{handler1}, destination);
        }

        public static Thunk chain(LogRecordHandler handler1, LogRecordHandler handler2, Thunk destination) {
            return Handlers.chain(new LogRecordHandler[]{handler1, handler2}, destination);
        }

        public static Thunk chain(LogRecordHandler handler1, LogRecordHandler handler2, LogRecordHandler handler3, Thunk destination) {
            return Handlers.chain(new LogRecordHandler[]{handler1, handler2, handler3}, destination);
        }

        public static Thunk chain(LogRecordHandler handler1, LogRecordHandler handler2, LogRecordHandler handler3, LogRecordHandler handler4, Thunk destination) {
            return Handlers.chain(new LogRecordHandler[]{handler1, handler2, handler3, handler4}, destination);
        }

        public static Thunk chain(LogRecordHandler handler1, LogRecordHandler handler2, LogRecordHandler handler3, LogRecordHandler handler4, LogRecordHandler handler5, Thunk destination) {
            return Handlers.chain(new LogRecordHandler[]{handler1, handler2, handler3, handler4, handler5}, destination);
        }
    }

    public static interface Thunk {
        public void apply(RedwoodConfiguration var1, Redwood.RecordHandlerTree var2);
    }
}

