/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.io.Lexer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

class NegraPennLexer
implements Lexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int SENTENCE = 2;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\t\u0001\u000b\u0001\t\u0001\t\u0001\n\u0012\u0000\u0001\u0002\u0004\f\u0001\u0001\u0002\f\u0002\b\u0006\f\n\u0007\u0019\f\u0001\u0003\n\f\u0001\u0000\u0006\f\u0001\u0004\b\f\u0001\u0005\u0005\f\u0001\u0006\u0006\f\n\u0000\u0001\t!\u0000\u0001\f\u000f\u0000\u0001\f\b\u0000@\f\u1f28\u0000\u0001\t\u0001\t\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = NegraPennLexer.zzUnpackCMap("\t\u0000\u0001\t\u0001\u000b\u0001\t\u0001\t\u0001\n\u0012\u0000\u0001\u0002\u0004\f\u0001\u0001\u0002\f\u0002\b\u0006\f\n\u0007\u0019\f\u0001\u0003\n\f\u0001\u0000\u0006\f\u0001\u0004\b\f\u0001\u0005\u0005\f\u0001\u0006\u0006\f\n\u0000\u0001\t!\u0000\u0001\f\u000f\u0000\u0001\f\b\u0000@\f\u1f28\u0000\u0001\t\u0001\t\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = NegraPennLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0002\u0002\u0001\u0003\u0001\u0004\u0001\u0002\u0006\u0000\u0001\u0003";
    private static final int[] ZZ_ROWMAP = NegraPennLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\r\u0000\u001a\u0000'\u0000\u001a\u00004\u0000\u001a\u0000A\u0000\u001a\u0000N\u0000[\u0000h\u0000u\u0000\u0082\u0000\u008f\u0000\u009c\u0000\u009c";
    private static final int[] ZZ_TRANS = NegraPennLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0003\u0001\u0004\u0001\u0005\u0005\u0006\u0001\u0007\u0001\u0005\u0001\b\u0001\u0005\u0001\u0006\r\t\u000e\u0000\u0001\n\u0001\u0000\u0005\u0006\u0004\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0005\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0005\u0002\u0000\u0001\u0006\u0001\u000b\u0005\u0006\u0004\u0000\u0001\u0006\u0003\u0000\u0001\f\r\u0000\u0001\r\r\u0000\u0001\u000e\r\u0000\u0001\u000f\b\u0000\u0001\u0010\u0011\u0000\u0001\u0011\u0005\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = NegraPennLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0006\u0000\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;

    private static int[] zzUnpackAction() {
        int[] result = new int[17];
        int offset = 0;
        offset = NegraPennLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[17];
        int offset = 0;
        offset = NegraPennLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[169];
        int offset = 0;
        offset = NegraPennLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[17];
        int offset = 0;
        offset = NegraPennLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    @Override
    public void pushBack(int n) {
        this.yypushback(n);
    }

    @Override
    public int getYYEOF() {
        return -1;
    }

    NegraPennLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 106) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples for workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (numRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    @Override
    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block10: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    System.err.println("Error: " + this.yytext());
                    return 0;
                }
                case 5: {
                    continue block10;
                }
                case 2: {
                    return 1;
                }
                case 6: {
                    continue block10;
                }
                case 3: {
                    return 0;
                }
                case 7: {
                    continue block10;
                }
                case 4: {
                    System.out.print(this.yytext());
                }
                case 8: {
                    continue block10;
                }
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java NegraPennLexer [ --encoding <name> ] <inputfile(s)>");
        } else {
            int firstFilePos = 0;
            String encodingName = "UTF-8";
            if (argv[0].equals("--encoding")) {
                firstFilePos = 2;
                encodingName = argv[1];
                try {
                    Charset.forName(encodingName);
                }
                catch (Exception e) {
                    System.out.println("Invalid encoding '" + encodingName + "'");
                    return;
                }
            }
            for (int i = firstFilePos; i < argv.length; ++i) {
                NegraPennLexer scanner = null;
                try {
                    FileInputStream stream = new FileInputStream(argv[i]);
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, encodingName);
                    scanner = new NegraPennLexer(reader);
                    while (!scanner.zzAtEOF) {
                        scanner.yylex();
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
            }
        }
    }
}

