/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankTransformer;
import edu.stanford.nlp.trees.tregex.Macros;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class EnglishPTBTreebankCorrector
implements TreebankTransformer {
    private static final Redwood.RedwoodChannels log = Redwood.channels(EnglishPTBTreebankCorrector.class);
    private static final boolean DEBUG = false;
    private static final String BE = "/^(?i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase)$/";
    private static final String DO = "/^(?i:do|did|does|doing|done)$/";
    private static final String BE_HAVE_GET = "/^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/";
    private static final String MODAL_WORD = "/^(?i:should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha|'d)$/";
    private static final String MODAL = "[ < (__ < /^(?i:should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ]";
    private static final String MODAL_DO_TO = "[ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ]";
    private static final String BARE_VP_VERB = " < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/)";
    private static final String SAY_VERB = " < (__ < /^(?i:say|says|said|saying)$/)";
    private final List<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
    private static final String macroStr = "HAVE_AUX_WORD\t/^(?i:has|have|had|having|'s|'ve|'d)\\$/\n";
    private static final String editStr = "@VP=adj < (NP < (NP=ex < (NN < growth)) < CC=bad < (NP=bd < (VB < service)))\nexcise ex ex\ndelete bad\ndelete bd\nadjoinF (VP VP@ (CC and) (VP (VB service) (NP (NN debt)))) adj\n\n@SBAR=home <1 /^-NONE-$/=emp <2 (@S < (@NP <1 (DT=bad < that|That) <-1 NNS))\ndelete emp\nrelabel bad IN\nmove bad >1 home\n\n@NP < (@NP=dest <: JJ) < NN=bad < @PP\nmove bad >-1 dest\n\n@NP < (@NP=gone < (NN < authority)) < (@PP=bad < (TO < to) < (NP=vp < (NN=newv < block) < (NNS=newnp < mergers)))\nexcise gone gone\nadjoin (S (NP-SBJ (-NONE- *)) VP@) bad\nrelabel vp VP\nrelabel newv VB\nadjoin (NP NN@) newnp\n\n@NP < (__=bad < well|Well|WELL $, (__=before < as|AS|As) $. (__=after < as|AS|As))\nadjoinH (CONJP RB@) bad\nrelabel bad CONJP\nmove before >1 bad\nmove after >-1 bad\n\n@NP < (/^``$/ < /^`$/) < (POS=bad < /^'$/)\nrelabel bad /''/\n\n@NP < (IN|WDT=bad < /^(?:a|that|That)$/)\nrelabel bad DT\n\n@NP < (IN=bad < /^(?:so|about)$/)\nrelabel bad RB\n\n@NP < (IN=bad < /^(?:fiscal|next)$/)\nrelabel bad JJ\n\n@NP < (RB=bad < /^(?:a|that|Some)$/)\nrelabel bad DT\n\n@NP < (RB=bad < most $. DT)\nrelabel bad PDT\n\n@NP < (RB=bad < /^(?:MORE)$/)\nrelabel bad JJR\n\n@NP < (NN=bad < the)\nrelabel bad DT\n\n@NP < (/^VB/=bad < won)\nrelabel bad NN\n\n@NP < (/^RB/=bad < well|WELL|Well)\nrelabel bad NN\n\n@NP < (NN=bad < yen|won [ $- (CD !< one|One|1) | $- (@QP !< (CD < one|One|1)) ] )\nrelabel bad NNS\n\n@NP < (NNP|NNS=bad < Democrats|Republicans)\nrelabel bad NNPS\n\n@NP < (NNP|NNS=bad < Parks) [ < (DT < The|the) | < (NNP|JJ < National) ]\nrelabel bad NNPS\n\n@NP < (CD=bad < the)\nrelabel bad DT\n\n@NP <: (JJ=bad < /^(UV-B|sterling|then-president|secretary-general|static|gold|cyclosporine|sales)$/)\nrelabel bad NN\n\n@NP <: (JJ=bad < /^(Hungary|Major|Sharp|National)$/)\nrelabel bad NNP\n\n@NP < (JJ=bad < the)\nrelabel bad DT\n\n@NP|NX < (NNP=bad < the)\nrelabel bad DT\n\n@NP=bad < (NNP=badder < Technically|Historically)\nrelabel bad ADVP\nrelabel badder RB\n\n@NP < (RB=bad < /^(?:McNally)$/)\nrelabel bad NNP\n\n@NP < (RB=bad < /^(?:vice|night|multifamily|hand|fist)$/)\nrelabel bad NN\n\n@NP < (RP=bad < /^(?:whole)$/)\nrelabel bad JJ\n\n@NP < (RP=bad < Howard) < (NN=badder < /^A\\.$/)\nrelabel bad NNP\nrelabel badder NNP\n\n@NP < (JJ=bad < (First , (__ !> /^``$/ !> /^-LRB-$/ !> /^PRP\\$$/)) $. NNP)\nrelabel bad NNP\n\n@NP < (JJ=bad < /^(?:U\\.S\\.|Sept\\.)$/)\nrelabel bad NNP\n\n@NP < (NN=bad < Department)\nrelabel bad NNP\n\n@NP < (JJ=bad < /^(?:mine)$/)\nrelabel bad NN\n\n@NP <-1 (JJ=bad < firm)\nrelabel bad NN\n\n@NP < (JJ=bad < /^(?:ours)$/)\nrelabel bad PRP\n\n@NP <: (JJ=bad < /^(?i:mine|yours|hers|ours|theirs)$/)\nrelabel bad PRP\n\n@NP < (JJ=bad < /^(?:ours)$/)\nrelabel bad PRP\n\n@NP < (JJ=bad < aluminum|plastic|textile)\nrelabel bad NN\n\n@NP < (JJ=bad < gold|silver|bronze . stocks|bat|standard|reserves|prices|market|price|prices|fund|funds|consumers|use|commemorative|medal|bullion|exploration|producer|producers|trader|traders)\nrelabel bad NN\n\n@NP <: (JJ=bad < gold|silver|bronze)\nrelabel bad NN\n\n@NP <2 (NN=bad < House $- (DT < /^[Tt]he$/))\nrelabel bad NNP\n\n@NP < (NNP=bad < Democrats|Republicans)\nrelabel bad NNPS\n\n@NP < (NNS=bad < Democrats|Republicans , __)\nrelabel bad NNPS\n\n@NP < (NN=bad < /^(?:Chapman|Ok|Oslo|Boeing|Jan\\.|Sept\\.|Oct\\.|Nov\\.|Dec\\.|Treasury|Esso)$/)\nrelabel bad NNP\n\n@NP < (NN=bad < /^(?:members|bureaus|days|outfits|institutes|innings|write-offs|wines|trade-offs|tie-ins|thrips|1980s|1920s|receivables|earnings)$/)\nrelabel bad NNS\n\n@NP < (NNP=bad < Dutch $. NN|NNS|JJ|VBG)\nrelabel bad JJ\n\n@NP < (NN=bad < /^(?:this)$/)\nrelabel bad DT\n\n@NP < (/^:/=bad < /^(?:')$/)\nrelabel bad /''/\n\n@NP < (NNS=bad < /^(?:start-up|ground-handling|word-processing|T-shirt|co-pilot|sell-off)$/)\nrelabel bad NN\n\n@NP < (NNS=bad < /^(?:Sens\\.|Aichi|Asahi|Cincinnati|Hawaii|Pepsi)$/)\nrelabel bad NNP\n\n@NP <1 (@NP=dest !< @NP . (__=wrong < /^'s$/))\nmove wrong >-1 dest\n\n@S < (@NP=bad < PRP < (VBZ=bottom < /^'s$/)) < (@VP=adj < VBN|VBG)\nadjoin (VP (VBZ 's) VP@) adj\ndelete bottom\n\n@S < (NP-SBJ < (PRP < I)) < (VP < (VB=bad < think) < SBAR)\nrelabel bad VBP\n\n@VP < (@NP=bad < (VBZ < kills|blames) < @NP)\nexcise bad bad\n\n@NP < (VBZ=bad < /^'s$/) !< (NNP < Everything)\nrelabel bad POS\n\n@NP|NX < (VBZ=bad !< /^(?:'s|kills)/)\nrelabel bad NNS\n\n@NP < (POS=bad < /^'s$/) > (@S > (@VP < (VB < let)))\nrelabel bad PRP\n\n@S < (@VP < (VB=bad < /...ed$/ )) < (/^NP-SBJ/ !< /^-NONE-$/) > (__ !> __)\nrelabel bad VBD\n\n@S < (@VP < (VB < let|cut|bid| )) < (/^NP-SBJ/ !< /^-NONE-$/) > (__ !> __)\nrelabel bad VBD\n\n@S < (@VP < (VB=bad !, Tait|MD|not )) < (/^NP-SBJ/ !< /^-NONE-$/) > (__ !> __)\nrelabel bad VBP\n\n@NP=bad < (VBP < are) > (@VP > (@S < NP-SBJ))\nexcise bad bad\n\n@NP < (VBP=bad < charge)\nrelabel bad NN\n\n@NP < (VBP=bad < the)\nrelabel bad DT\n\n@NP < (VBP=bad < we)\nrelabel bad PRP\n\n@NP < (VBP=bad < /^[A-Z]/)\nrelabel bad NNP\n\n@NP < (VBN=bad < Applied !$ __)\nrelabel bad NNP\n\n@NP < (VBG=bad < preferred)\nrelabel bad VBN\n\n@NP < (VB=bad < The)\nrelabel bad DT\n\n@NP < (VB=bad < allowed)\nrelabel bad VBD\n\n@NP <-1 (JJR=bad < cleaner)\nrelabel bad NN\n\n@NP < (VB=bad < /^(?:Nov\\.|Jan\\.|Dec\\.|Tandy|Release|Orkem|McDonald|Citicorp|Anne)$/)\nrelabel bad NNP\n\n@NP < (VB=bad < /^(?:short|key|many|last|further)$/)\nrelabel bad JJ\n\n@NP < (VB=bad < lower)\nrelabel bad JJR\n\n@NP < (VB=bad < /^(?:spill|watch|review|risk|realestate|love|experience|control|Transport|mind|term|program|gender|audit|blame|stock|run|group|affect|rent|show|accord|change|finish|work|schedule|influence|school|freight|growth|travel|call|autograph|demand|abuse|return|defeat|pressure|bank|notice|tax|ooze|network|concern|pit|contract|cash|help|lunch|combat|pot|care|date|Streetspeak|face|effect|worry)$/)\nrelabel bad NN\n\n@NP <1 (NNP=bad < Officials|Cartoonists|Prices)\nrelabel bad NNS\n\n@NP=badder < (NNP=bad < Currently)\nrelabel bad RB\nrelabel badder ADVP-TMP\n\n@NP < (NN=bad < /^(?i:first|second|third|fourth)-quarter$/ $+ __)\nrelabel bad JJ\n\n@NP < (NNP < K $+ (NN=bad < mart))\nrelabel bad NNP\n\n@NP < (PRP=bad < US & $. __)\nrelabel bad NNP\n\n@NP < (PRP=bad < her & $. __)\nrelabel bad /PRP$/\n\n@NP <1 (PRP=bad < his) !<2 __\nrelabel bad /PRP$/\n\nVBD=bad [ > @NP | > (@ADJP < CC|CONJP > @NP) ]\nrelabel bad VBN\n\n@NP < (NN=bad < Time) < (NNP < Warner)\nrelabel bad NNP\n\n@NP < (MD=bad < Can|May)\nrelabel bad NNP\n\n@NP <1 (DT=bad !< the $. (DT !< half))\nrelabel bad PDT\n\n@NP=place < (@NP <1 DT !<2 __ $. (JJ=bad $. (NN=badder $. PP)))\nmove bad >-1 place\nmove badder >-1 place\n\n@NP=place < (@NP <1 DT|JJ !<2 __ $. (NN=bad $. PP))\nmove bad >-1 place\n\n@NP < (NNPS=bad < NEWSPAPERS ! $ /^NN/)\nrelabel bad NNS\n\n@NP < (@NP < (NNPS=bad < CERTIFICATES)) < (PP < (IN < OF) < (NP < (__ < DEPOSIT)))\nrelabel bad NNS\n\n@NP < (@NP < (__ < CERTIFICATES)) < (PP < (IN < OF) < (NP < (NNPS=bad < DEPOSIT)))\nrelabel bad NN\n\n@NP < (NNP=bad < DISCOUNT) < (NNP=badder < RATE)\nrelabel bad NN\nrelabel bad NN\n\n@NP < (JJ=bad < DISCOUNT) < (NN < RATE)\nrelabel bad NN\nrelabel bad NN\n\n@NP < (__ < chief $. (NN=bad < executive $. (NN < officer)))\nrelabel bad JJ\n\n@NP < (NN=bad < chief $. (__ < executive $. (NN < officer)))\nrelabel bad JJ\n\n@NP <: (NNP=bad < /^'s$/)\nrelabel bad PRP\n\nNP-TMP=bad < (NN < Leisure)\nrelabel bad NP\n\n@NP < (RB=bad < well !$, (RB < as) $,, (DT < The|the))\nrelabel bad NN\n\n@NP < (NN < officer $- (NN=bad < executive $- (__ < chief)))\nrelabel bad JJ\n\n@NP < (NN < officer $- (JJ < executive $- (NN=bad < chief)))\nrelabel bad JJ\n\n@NP < (NNP=bad < Ad) < (/^NN/ < Notes)\nrelabel bad NN\n\n@NP < (/^NN/ < Ad) < (NNPS=bad < Notes)\nrelabel bad NNS\n\nNP=bad < (/^NN/ < Ad) < (/^NN/ < Notes)\nrelabel bad NP-HLN\n\n@NP < (NN=bad < nonperforming)\nrelabel bad JJ\n\n@NP < (IN=bad < next|Next) < NN|NNP\nrelabel bad JJ\n\nNP-PRD=x < (JJ=y $+ (NN=z < simple))\nrelabel x ADJP-PRD\nrelabel y RB\nrelabel z JJ\n\nNP-PRD=x <: (NN=z < simple)\nrelabel x ADJP-PRD\nrelabel z JJ\n\nNN=z < simple\nrelabel z JJ\n\n@PP < (IN < behind) < (@NP < PRP=bad < (RB=no < back))\nrelabel bad /PRP$/\nrelabel no NN\n\n@SBAR=bad < (@WHNP < (WP < WHO)) < (S=badder < (VP < (@NP < (NN < NEWS))))\nrelabel bad /SBARQ-HLN/\nrelabel badder SQ\n\n@SBARQ < (@WHNP < (WP < WHO)) < (SQ < (VP < (@NP < (NNP=bad < NEWS))))\nrelabel bad NN\n\n@SBARQ < (@WHNP < (WP < WHO)) < (S=bad < (VP < (@NP < (NN < NEWS))))\nrelabel bad SQ\n\n@WHNP < @WHNP=bad < @WHPP\nrelabel bad NP\n\n@WHADJP|WHNP|NP < (WRB < /^(?i:how)$/) < (__=bad < (much !> JJ))\nrelabel bad JJ\n\n@WHNP|WHADVP < (VBP|DT|IN=bad < /^(?i:that)$/) [ > (@SBAR > @NP|VP) | > (@SBAR > (@SBAR < /^(?:CC|CONJP|,)$/ > @NP|VP)) ]\nrelabel bad WDT\n\n@UCP < (RB=bad < multifamily)\nrelabel bad NN\n\n@PRT < (RBR=bad < in)\nrelabel bad RP\n\n@PRT < (NNP=bad < up)\nrelabel bad RP\n\n@PP < (RP=bad < through) < @NP\nrelabel bad IN\n\n@PP < (RP|NN=bad < in) < @NP\nrelabel bad IN\n\n@PP < (RB=bad < for|For|after|After|past|Past|under|Under)\nrelabel bad IN\n\n@PP < (JJ=bad < if)\nrelabel bad IN\n\n@VP=bad < (IN < past) < @NP\nrelabel bad PP\n\n@VP < (RB=bad < back $. (PRT < (RP < down))) > (@SINV|SQ|VP < MD)\nrelabel bad VB\n\n@VP < (IN=bad < complicated) > @S\nrelabel bad VBD\n\n@VP < (IN=bad < near) > @VP\nrelabel bad VB\n\n@VP < (IN=bad < like|post) > (@SQ|VP < /^(?:VB|MD)/)\nrelabel bad VB\n\n@VP < (IN=bad < like|post) [ > @S | > (@VP < CC|CONJP > @S) ]\nrelabel bad VBP\n\n@VP < (/^VBD?$/=ins < take|sold) < (IN=bad < off)\ndelete bad\ninsert (PRT (RP off)) $- ins\n\n@VP < NNS=bad\nrelabel bad VBZ\n\n@VP < (NN=bad < /.{2}ing$/)\nrelabel bad VBG\n\n@VP < (NN=bad [ < set|beat|bid|redone|reset|hurt|underwritten|overrun | < /.{2}[^e]ed$/ ]) [ > (@VP < (/^VB/ < /^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/)) | > (@NP < @NP)]\nrelabel bad VBN\n\n@VP < (NN=bad < agreed|set|rebounded|fell) [ > @S | > (@VP < @CC|CONJP > @S) ]\nrelabel bad VBD\n\n@VP !< /^VB/ < (NN|NNP|JJ=bad !< /...(?i:ing)$/) [ > (@VP|SINV|SQ [ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ]) | > (@VP|SINV|UCP|SQ < CC|CONJP > (@VP|SINV|UCP|SQ [ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ])) | > (@S > (@VP  < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/))) | > (@VP  < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/)) | > (@S < (/^NP-SBJ/ < /^-NONE-$/) > (@VP  < (__ < /^(?i:say|says|said|saying)$/))) ]\nrelabel bad VB\n\n@VP !< /^VB/ < (NN=bad [ [ !< /s$/ & !< /e[dn]$/ & !< /ing$/ ] | < stress ] ) [ > @S | > (@VP < @CONJP|CC > @S) ]\nrelabel bad VBP\n\n@VP < (NN=bad < institutes) > @S\nrelabel bad VBZ\n\n@VP < (VBP=bad !< /...(?i:ing)$/) [ > (@VP|SQ|SINV [ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ]) | > (@VP|UCP|SQ|SINV < CC|CONJP > (@VP|UCP|SQ|SINV [ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ])) | > (@S > (@VP  < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/))) | > (@VP  < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/)) | > (@S < (/^NP-SBJ/ < /^-NONE-$/) > (@VP  < (__ < /^(?i:say|says|said|saying)$/))) ]\nrelabel bad VB\n\n@VP < (VBN=bad !< /...(?i:ing)$/ !< /...(?i:ed)$/) [ > (@VP|SQ [ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ]) | > (@VP|SQ < CC|CONJP !< /^VB/ > (@VP|SQ [ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ])) | > (@SINV [ < (__ < /^(?i:should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ]) | > (@SINV < CC|CONJP !< /^VB/ > (@SINV [ < (__ < /^(?i:should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ])) ]\nrelabel bad VB\n\n@VP < (VBN=bad !< /...(?i:ing)$/) < (NP !< /^-NONE-$/) [ > (@S > (@VP  < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/))) | > (@VP  < (__ < /^(?i:help|helps|helping|helped|make|makes|making|made|see|sees|saw|seen|seeing|hear|heard|hears|hearing|let|lets|letting)$/)) | > (@S < (/^NP-SBJ/ < /^-NONE-$/) > (@VP  < (__ < /^(?i:say|says|said|saying)$/))) ]\nrelabel bad VB\n\n@VP < (NN=bad < relocate) > (@VP < @CONJP > (@VP < MD))\nrelabel bad VB\n\n@VP < (NN=bad < might|will)\nrelabel bad MD\n\n@VP < (NNP=bad < /...(?i:ed)$/) [ > (SINV !> /TTL/) | > (@VP < @CONJP|CC > (SINV !> /TTL/)) ]\nrelabel bad VBD\n\n@VP < (NNP=bad < /...(?i:ed)$/) [ > (S|S-HLN|S-ADV !> /TTL/) | > (@VP < @CONJP|CC > (S|S-HLN|S-ADV !> /TTL/)) | > (@VP < (__ < /^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/)) ]\nrelabel bad VBN\n\n@VP < (NNP=bad < Got|Gotten) [ > (S|S-HLN|S-ADV !> /TTL/) | > (@VP < @CONJP|CC > (S|S-HLN|S-ADV !> /TTL/)) | > (@VP < (__ < /^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/)) ]\nrelabel bad VBN\n\n@VP < (NNP=bad < /..[^Ss](?i:s)$/) [ > (S|S-HLN|SINV !> /TTL/) | > (@VP < @CONJP|CC > (S|SINV|S-HLN !> /TTL/)) ]\nrelabel bad VBZ\n\n@VP !< /^VB/ < (NNP=bad < /(?i:ing)$/)\nrelabel bad VBG\n\n@VP < NNP=bad [ > (S|S-HLN !> /TTL/) | > (@VP < @CONJP|CC > (S|S-HLN !> /TTL/)) ]\nrelabel bad VBP\n\n@VP < (NNP=bad < are) [ > @S | > (@VP < @CONJP|CC > @S) ]\nrelabel bad VBP\n\n/CC|NNP/=bad < /Either|Neither/ !$++ CC\nrelabel bad DT\n\n/neither|either/ > (RB=bad $++ CC)\nrelabel bad CC\n\n/Neither|neither|either/ > (DT=bad $++ CC)\nrelabel bad CC\n\n@VP < (VBD < /^(?i:'d)$/) < (@VP < (VB=badder < seen))\nrelabel badder VBN\n\n@VP < (VBP=bad < /^(?i:should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha|'d)$/) < (@VP < VB)\nrelabel bad MD\n\n@VP < (VBP=bad < /^(?i:'d)$/) < (@VP < VB)\nrelabel bad MD\n\n@VP < POS=bad\nrelabel bad VBZ\n\n@VP < (VBD=bad < heaves)\nrelabel bad VBZ\n\n@VP < (VB=bad < /.{2}[^e]ed$/) > @S\nrelabel bad VBD\n\n@VP < (VB=bad < /^(?i:.{2,}[^e]ed|reset|run|become|hit|remade|gone|rid|put|hurt|become)$/) [ > (@VP < (/^VB/ < /^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/)) | > (@NP < @NP) ]\nrelabel bad VBN\n\n@VP < (VBN=bad < has)\nrelabel bad VBZ\n\n@VP < (VBN=bad < grew|fell|had) [ > @S | > (@VP < CONJP|CC > @S)]\nrelabel bad VBD\n\n@VP < VBN=bad < (NP !< /^-NONE-$/) [ > (S < (@NP !< /^-NONE-$/)) | > (@VP < CONJP|CC > (S < (@NP !< /^-NONE-$/))) ]\nrelabel bad VBD\n\n@VP < VBN=bad [ > (S < (@NP !< /^-NONE-$/) > (__ !> __)) | > (@VP < CONJP|CC > (S < (@NP !< /^-NONE-$/) > (__ !> __))) ]\nrelabel bad VBD\n\n@SBAR [ < (/^-NONE-$/ < /^0$/) | < (IN < that) ] < (@S < (NP-SBJ !< /^-NONE-$/) < (@VP < VBN=bad))\nrelabel bad VBD\n\n@VP < VB=bad [ > (S < (NP-SBJ !< /^-NONE-$/) > (__ !> __)) | > (@VP < CONJP|CC > (S < (NP-SBJ !< /^-NONE-$/) > (__ !> __))) ]\nrelabel bad VBP\n\n@NP < @NP < (@SBAR < @WHNP < (@S < (VP < VB=bad)))\nrelabel bad VBP\n\n@VP < CONJP|CC <1 (VBP $.. VB=bad)\nrelabel bad VBP\n\n@VP < (VBP=bad < has)\nrelabel bad VBZ\n\n@VP < (JJ=bad < own|elaborate) [ > @S | > (@VP < CONJP|CC > @S)]\nrelabel bad VBP\n\n@VP < (JJ=bad < /..ing$/) < (@S < (@NP !< /^-NONE-$/) < (VP < TO))\nrelabel bad VBG\n\n@VP < (JJ=bad < /...ed$/) [ > @S | > (@VP < CONJP|CC > @S)]\nrelabel bad VBD\n\n@VP < (JJ=bad < pressured|known) [ > (@VP < (__ < /^(?i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase)$/)) | > (@VP < CONJP|CC > (@VP < (__ < /^(?i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase)$/))) ]\nrelabel bad VBN\n\n@VP < (JJ=bad < /(?i:..e[dn])$/) > (@VP < (__ < HAVE_AUX_WORD))\nrelabel bad VBN\n\n@VP < (JJ=bad < /.{2}ing$/) [ > @S | > (@VP < CONJP|CC > @S)]\nrelabel bad VBG\n\n@VP < (JJ=bad < to)\nrelabel bad TO\n\n@VP|S < (JJ=bad < all|ALL|All)\nrelabel bad RB\n\n@VP < VBD=bad [ > (@VP < (/^VB/ < /^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/)) | > (@VP < CONJP|CC > (@VP < (/^VB/ < /^(?i:i:am|is|are|was|were|be|being|been|'s|'m|'re|s|ai|r|m|`s|art|ar|wase|has|have|had|having|'s|'ve|'d|s|get|gets|getting|got|gotten)$/))) | > (@NP < @NP) ]\nrelabel bad VBN\n\n@VP < (VBD=bad < /[A-Z]/) > S-ADV\nrelabel bad VBN\n\n@VP < (/^VB/ $. (IN=bad < up|off))\nadjoin (PRT (RP@)) bad\n\n@VP < /^VB/ < (/^(?:ADVP|PRT)\\|(?:ADVP|PRT)$/=bad < (RB|NN=badder < back))\nrelabel bad PRT\nrelabel badder RP\n\n@VP < (/^VB/ < win|wins|winning|won) < (@ADVP=bad < (RB=badder < back))\nrelabel bad PRT\nrelabel badder RP\n\n@VP < (PDT=bad < all)\nrelabel bad RB\n\n@VP < (PRT < (VBP=bad < down))\nrelabel bad RP\n\n@VP < (PRT=bad < (RBS < best))\nrelabel bad ADVP\n\n@VP <1 (VB=bad < plea) <2 (NN=badder < bargain) > (@VP[ < (__ < /^(?i:do|did|does|doing|done|to|na|should|would|wo|could|may|might|ca|can|dare|will|'ll|must|shall|sha)$/) | < (MD < /^(?i:'d)$/) ])\nrelabel bad NN\nrelabel badder VB\n\n@ADJP < UH=bad\nrelabel bad JJ\n\n@ADJP < (JJ < alive) < CC < (RB=bad < well)\nrelabel bad JJ\n\n@ADJP < (JJ=bad < more)\nrelabel bad JJR\n\nKorean > (NNP=x $- (NNP=y < South))\nrelabel x JJ\nrelabel y JJ\n\n@ADJP <1 (NNP=x < /^(?:New|San|Los|Des|St\\.|Washington|Hong)$/) <2 (__ < /^(?:York|Francisco|Angeles|London|Orleans|Zealand|Diego|Moines|Louis|D\\.C\\.|Kong)-based$/) !<3 __\nrelabel x JJ\n\n@ADJP <1 (__ < New|San|Los) <2 (NNP=y < /^(?:York|Francisco|Angeles)-based$/) !<3 __\nrelabel y JJ\n\n@ADJP < (NN=bad < firm|due|permissible)\nrelabel bad JJ\n\n@ADJP < (NNS=bad < due)\nrelabel bad JJ\n\n@ADJP < (NNP=bad < READY)\nrelabel bad JJ\n\n@ADJP < (RB=bad < free|clear|tight|sure|particular|due)\nrelabel bad JJ\n\n@ADJP < (RB=bad < likely) > @VP\nrelabel bad JJ\n\n@ADJP < (VB=bad < /^(?i:stock|No\\.)$/)\nrelabel bad NN\n\n@ADJP < (VBP=bad < fit|close)\nrelabel bad JJ\n\n@ADJP < (VB=bad < secure|keen|quiet)\nrelabel bad JJ\n\n@ADJP < JJ < (IN=bad < that)\nrelabel bad RB\n\n@QP < (IN|JJ|RBR|RP=bad < about)\nrelabel bad RB\n\n@QP < (JJ=bad < as)\nrelabel bad RB\n\n@QP < (JJ|JJS=bad < more|less)\nrelabel bad JJR\n\n@QP < (RP=bad < up $. (TO <to))\nrelabel bad IN\n\n@ADVP < EX=bad\nrelabel bad RB\n\n@ADVP < (NN=bad < that)\nrelabel bad DT\n\n@ADVP < (NNP=bad [ < /.{2}ly$/ | < Overall | < Systemwide ])\nrelabel bad RB\n\n@ADVP < (RP=bad < around|before)\nrelabel bad RB\n\nbefore|after > (RB=bad > @SBAR $+ @S)\nrelabel bad IN\n\n@ADVP=bad <1 PRT !<2 __\nexcise bad bad\n\n@ADVP < (VBD=bad < let) < (RB=badder < alone)\nrelabel bad VB\nrelabel badder JJ\n\n@ADVP < VBD=bad\nrelabel bad VBN\n\n@SBAR < (DT|WDT|NN|NNP|RB=bad < that|because|while|Though|Whether)\nrelabel bad IN\n\n@SQ < VB=bad\nrelabel bad VBP\n\n@SQ < (NNS=bad $. NP-SBJ)\nrelabel bad VBZ\n\n@SQ < (NNP=bad < Does)\nrelabel bad VBZ\n\n@SQ < (NNP=bad < Should)\nrelabel bad MD\n\n@X < (JJS=bad < more|less)\nrelabel bad JJR\n\n@INTJ < (RB=bad < well|WELL|Well)\nrelabel bad UH\n\n@INTJ < (NNP=bad < UH|HUH)\nrelabel bad UH\n\nJJ=bad < /^%$/\nrelabel bad NN\n\nNN|NNP|JJ|IN=bad < and\nrelabel bad CC\n\nVB=bad < even\nrelabel bad RB\n\n/^,$/=bad < /^2$/\nrelabel bad CD\n\n/^,$/=bad < an\nrelabel bad DT\n\n/^,$/=bad < Wa\nrelabel bad NNP\n\n/^,$/=bad < section\nrelabel bad NN\n\n/^,$/=bad < underwriters\nrelabel bad NNS\n\nCD=bad < high-risk\nrelabel bad JJ\n\nRB|RP|NN=bad < for|at\nrelabel bad IN\n\nNN=bad [ < /^.\\.$/ | < Lorillard ]\nrelabel bad NNP\n\nJJS=bad < StatesWest\nrelabel bad NNP\n\nJJR=bad < Richter|Gartner\nrelabel bad NNP\n\nIN|JJ|NN|NNP=bad < /^[Aa][Nn][Dd]$/\nrelabel bad CC\n\n/^(?:ADVP|ADVP-TMP.*)$/=badder < (RB=bad < ago) < @NP\nrelabel bad IN\nrelabel badder PP-TMP\n\nADV-TMP=bad < (ADVP|NP=badder < (IN < ago) < @NP)\nrelabel bad PP-TMP\nrelabel badder PP\n\n/^(?:ADVP|NP)/=badder < (IN < ago) < @NP\nrelabel badder PP-TMP\n\n@NP=badder < (RB=bad < ago) < @NP\nrelabel bad IN\nrelabel badder PP-TMP\n\n/^ADVP-TMP/=badder < (RB < not|Not|so|So) < (RB=jj < long) < (RB=bad < ago)\nadjoin (PP-TMP NP@ (IN ago)) badder\ndelete bad\nrelabel jj JJ\n\n/^ADVP-TMP/=badder <1 (RB|JJ=jj < long) <2 (RB=bad < ago)\nadjoin (PP-TMP NP@ (IN ago)) badder\ndelete bad\nrelabel jj JJ\n\nADJP=badder <1 (NN=baddest < Year) <2 (RB=bad < ago)\nadjoin (NP NN@) baddest\nrelabel badder PP-TMP\nrelabel bad IN\n\n@NP=bad <1 NP <2 (ADVP-TMP=badder < (RB=baddest < ago))\nrelabel bad PP-TMP\nexcise badder badder\nrelabel baddest IN\n\n/^NP/=badder < DT|CD < NN|NNS < (RB|IN=bad < ago)\nadjoin (PP-TMP NP@ (IN ago)) badder\ndelete bad\n\nADVP-TMP=badder < (IN < ago) < @ADVP\nrelabel badder PP-TMP\n\nRB=bad < newsweekly\nrelabel bad NN\n\nRB=bad < stocks\nrelabel bad NNS\n\nNN=bad < PaineWebber\nrelabel bad NNP\n\nNNP=bad < Though\nrelabel bad IN\n\n@PP < (IN < /^(?i:at)$/ $. RBS=adj)\nadjoin (NP RBS@) adj\n\n@SBAR < (/^WP\\$$/=bad $. (@WHNP=dest < NN))\nmove bad >1 dest\n\n@SBAR=sbar < (/^WP\\$$/=wrong $. (S=ins < NP-SBJ=fix < VP))\nmove wrong >1 fix\nrelabel fix WHNP\nmove fix >1 sbar\ninsert (NP-SBJ (-NONE- *T*)) >1 ins\n\n@SBAR <1 @WHNP <2 @S=loc <3 @VP=bad !<4 __\nmove bad >-1 loc\n\n@WHNP < (@WHADVP=bad < (WRB < /^(?i:how)$/) < (JJ < many|much)) < NN|NNS|NNP|NNPS\nrelabel bad WHADJP\n\n@WHNP < (@NP=bad < /^(?:WP\\$|WDT|WRB)$/ $.. @PP|PRN|NP)\nrelabel bad WHNP\n\n@WHNP < (@WHADVP=bad < (WRB < /^(?i:how)$/)) < (JJ < much)\nexcise bad bad\n\n@WHNP < @NP < (@PP=bad < (@WHNP < WDT|WP))\nrelabel bad WHPP\n\n@WHNP < (WP=bad $.. NN|NNS !$.. DT)\nrelabel bad WDT\n\n@WHNP < @NP < (@PP=bad < (@NP=badder < WDT))\nrelabel bad WHPP\nrelabel badder WHNP\n\n@PP <1 (IN|TO $. (@NP=place < ADJP)) <-1 NN|NNS|NNP|NNPS=word\nmove word >-1 place\n\n@PP=head <1 IN|TO=prep <-1 NN|NNS|NNP|NNPS\nadjoinH (PP NP@) head\nmove prep >1 head\n\n@S < (@SBAR < (SBAR < SINV $. (CC $. (SBAR=adj < VBD < S))))\nadjoin (SBAR SINV@) adj\n\n@SINV < (NP-SBJ=subj $. (@VP=base $.. (@VP=say < (/^VB/ < say|says|said))))\nadjoinH (S VP@) base\nmove subj >1 base\nrelabel base S-1\ninsert (S (-NONE- *T*-1)) >-1 say\n\nNP-SBJ=bad < NP-TMP !< NP < PP-TMP\nexcise bad bad\n\n@S < NP-SBJ < (NP=bad < (/^NN/ < Tuesday|yesterday|Yesterday))\nrelabel bad NP-TMP\n\n@S=bad < (VBP $. (NP-SBJ $. VP))\nrelabel bad SINV\n\n@S < (/^NP-SBJ/ $. (VBP|VBZ=aux $. @VP=adj))\nadjoinH (VP VP@) adj\nmove aux >1 adj\n\n@S < (/^NP-SBJ/ $. (VBP|VBZ=aux $. @ADJP=adj))\nadjoinH (VP ADJP@) adj\nmove aux >1 adj\n\n@PP=adj < (IN=prep $. JJ)\nadjoinH (PP NP@) adj\nmove prep >1 adj\n\n@SBARQ <1 @WHADVP <2 VBZ=bad <3 RB=badder <4 @SQ=loc\nmove badder >1 loc\nmove bad >1 loc\n\n@SBARQ <2 @WHADVP <3 MD=bad <4 @SQ=loc\nmove bad >1 loc\n\n@SBARQ <2 @WHNP <3 VBZ=bad <4 @SQ=loc\nmove bad >1 loc\n\n@VP=adj < (VBN=bad < been) < (JJ < unable) !< CC|CONJP\nadjoin (VP (VBN been) ADJP@) adj\ndelete bad\n\n@S < (@NP < (NNS=bad < runs)) < (VP=home !< /^VB/ < (IN=badder < up))\nrelabel bad VBZ\nrelabel badder RP\nmove bad >1 home\nadjoin (PRT RP@) badder\n\n@VP=top < (MD=bottom < will $. /^VB/)\nadjoin (VP (MD will) VP@) top\ndelete bottom\n\n@VP < (MD=bad < /^'d$/)\nrelabel bad VBD\n\n@S < (TO=bottom < to $. (@VP=top < /^VB/))\nadjoin (VP (TO to) VP@) top\ndelete bottom\n\n@S < /^NP-SBJ/ < (VP < (VBD < /^(?i:do|did|does|doing|done)$/) < (@NP=bad < (NN=badder < work)))\nrelabel bad VP\nrelabel badder VB\n\n@SBARQ !< @SQ !< /^-NONE-$/ !< @SBARQ < (@S|SINV=bad < VBP|VBZ|MD|VBD)\nrelabel bad SQ\n\n@SBARQ < (@SINV=bad < (__ < would))\nrelabel bad SQ\n\n@NP=top < @NP=bottom !<2 __\nexcise bottom bottom\n\nNP-SBJ=bad < (RB < Earlier)\nrelabel bad NP-TMP\n\n@NP < (RB=bad < late|early $+ /^NN/)\nrelabel bad JJ\n\n@NP <1 (DT < a|an) <2 (JJ=bad < Hungary) !<3 __\nrelabel bad NNP\n\n@NP <1 (DT < a|an) <2 (JJ=bad < /^(?:official|deterrant|bible|academic|fine|buy-out|perk|installment)$/) !<3 __\nrelabel bad NN\n\n@VP < (/^VB/ < help|helps|helped|helping|start|started|starts|starting|begin|begins|began|beginning) < (@VP=site < VB)\nadjoin (S (NP-SBJ (-NONE- *)) VP@) site\n\n@NP < CD < (NNP < Drugs=bad)\nrelabel bad NNS\n\nwell|Well|WELL [ , /^[:,]$/ | !, __ ] . /^[:,]$/ > (RB=bad > ADVP=badder)\nrelabel bad UH\nrelabel badder INTJ\n\nNNP=bad < Securities|Manufacturers|Enterprises|Securities|Resources|Corporations|Sports|Merchants|Industries|Holdings|Brothers|Airlines|Systems|Motors|Industries|Communications|Facilities|Technologies|Sons|Publications|Products|Nations|Monopolies|Mergers|Machines|INDUSTRIES|Giants|Firearms|Associates|ASSOCIATES\nrelabel bad NNPS\n\n@NP < (NN=bad < chief $++ /^NN/)\nrelabel bad JJ\n\n@NP <- (DT=bad < half)\nrelabel bad NN\n\n@ADVP < (RB=bad < easier|harder|earlier)\nrelabel bad RBR\n\n@ADJP < (RB|JJ=bad < easier|harder|earlier)\nrelabel bad JJR\n\nNN=bad < salespeople\nrelabel bad NNS\n\nNN=bad < Chevrolet\nrelabel bad NNP\n\nNNS=bad < Caltrans\nrelabel bad NNP\n\nNNS=bad < Dirks\nrelabel bad NNP\n\nNN=bad < /^U\\.K\\.$/\nrelabel bad NNP\n\n@PP < (JJR=bad < more|less)\nrelabel bad RBR\n\n@PP < (@ADVP < (JJR=bad < more|less))\nrelabel bad RBR\n\nRB=bad < earlier\nrelabel bad RBR\n\n@NP <- (NN < month|year) < (@QP < (RBR=bad < less|more) < (IN < than))\nrelabel bad JJR\n\n@NP < (NNP=bad < Afghan $+ /^NN/)\nrelabel bad JJ\n\nNNS=bad < headquarters\nrelabel bad NN\n\n@NP < (NN=bad < managing)\nrelabel bad VBG\n\n@NP < (NNS=x < East) < (NNS=y < Germans)\nrelabel x NNPS\nrelabel y NNPS\n\n@NP < DT < (NNS=y < Germans)\nrelabel y NNPS\n\n@NP < (NN=y < /^S&P$/)\nrelabel y NNP\n\nJJ=y < benchmark\nrelabel y NN\n\nJJ=y < Aeroflot\nrelabel y NNP\n\nNNPS=y < ADRs\nrelabel y NNS\n\nNN=y < telecommunications\nrelabel y NNS\n\n@NP < (NN=y < executive $+ (NN|NNS < officer|officers|vice))\nrelabel y JJ\n\n@NP < (CD|NN=y < /^(?:'[0-9]0s|1[1-9][0-9]0s)$/)\nrelabel y NNS\n\nIN|CC|NN|JJ=bad < /^(vs\\.|versus)$/\nrelabel bad FW\n\nNN=bad < /^U\\.S\\.A\\.$/\nrelabel bad NNP\n\n";

    public EnglishPTBTreebankCorrector() {
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        TregexPatternCompiler tpc = new TregexPatternCompiler(tlp.headFinder(), tlp.getBasicCategoryFunction());
        Macros.addAllMacros(tpc, EnglishPTBTreebankCorrector.getBufferedReader(macroStr));
        try {
            String line;
            BufferedReader br = EnglishPTBTreebankCorrector.getBufferedReader(editStr);
            ArrayList<TsurgeonPattern> tsp = new ArrayList<TsurgeonPattern>();
            while ((line = br.readLine()) != null) {
                TregexPattern matchPattern = tpc.compile(line);
                tsp.clear();
                while (EnglishPTBTreebankCorrector.continuing(line = br.readLine())) {
                    TsurgeonPattern p = Tsurgeon.parseOperation(line);
                    tsp.add(p);
                }
                if (tsp.isEmpty()) continue;
                TsurgeonPattern tp = Tsurgeon.collectOperations(tsp);
                this.ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, tp));
            }
        }
        catch (IOException ioe) {
            log.warn(ioe);
        }
    }

    @Override
    public MemoryTreebank transformTrees(Treebank tb) {
        MemoryTreebank mtb = new MemoryTreebank(tb.treeReaderFactory(), tb.encoding());
        for (Tree t : tb) {
            mtb.add(Tsurgeon.processPatternsOnTree(this.ops, t));
        }
        return mtb;
    }

    private static boolean continuing(String str) {
        return str != null && !str.matches("\\s*");
    }

    private static BufferedReader getBufferedReader(String source) {
        return new BufferedReader(new StringReader(source));
    }
}

