/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.CoreTokenFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Pattern;

public class ColumnTabDocumentReaderWriter<IN extends CoreMap>
implements DocumentReaderAndWriter<IN> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ColumnTabDocumentReaderWriter.class);
    private static final long serialVersionUID = 1L;
    private String[] map;
    private Pattern delimiterPattern = Pattern.compile("\t");
    private Pattern whitespacePattern = Pattern.compile("\\s");
    private boolean replaceWhitespace = true;
    private String tokensAnnotationClassName;
    private CoreTokenFactory<IN> tokenFactory;

    @Override
    public void init(SeqClassifierFlags flags) {
        this.tokensAnnotationClassName = flags.tokensAnnotationClassName != null ? flags.tokensAnnotationClassName : "edu.stanford.nlp.ling.CoreAnnotations$TokensAnnotation";
        if (flags.tokenFactory != null) {
            try {
                this.tokenFactory = (CoreTokenFactory)Class.forName(flags.tokenFactory).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.tokenFactory = new CoreLabelTokenFactory();
        }
        this.init(flags, this.tokenFactory, this.tokensAnnotationClassName);
    }

    public void init(Properties props) {
        this.init("", props);
    }

    public void init(String name, Properties props) {
        String prefix = name == null ? "" : name + ".";
        String delimiterRegex = props.getProperty(prefix + "delimiter");
        if (delimiterRegex != null) {
            this.delimiterPattern = Pattern.compile(delimiterRegex);
        }
        this.replaceWhitespace = PropertiesUtils.getBool(props, prefix + "replaceWhitespace", this.replaceWhitespace);
        String mapString = props.getProperty(prefix + "columns");
        this.tokensAnnotationClassName = props.getProperty(prefix + "tokens", "edu.stanford.nlp.ling.CoreAnnotations$TokensAnnotation");
        String tokenFactoryClassName = props.getProperty(prefix + "tokenFactory");
        if (tokenFactoryClassName != null) {
            try {
                this.tokenFactory = (CoreTokenFactory)Class.forName(tokenFactoryClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.tokenFactory = new CoreLabelTokenFactory();
        }
        this.init(mapString, this.tokenFactory, this.tokensAnnotationClassName);
    }

    public void init(String map) {
        this.init(map, new CoreLabelTokenFactory(), "edu.stanford.nlp.ling.CoreAnnotations$TokensAnnotation");
    }

    public void init(SeqClassifierFlags flags, CoreTokenFactory<IN> tokenFactory, String tokensAnnotationClassName) {
        this.map = StringUtils.mapStringToArray(flags.map);
        this.tokenFactory = tokenFactory;
        this.tokensAnnotationClassName = tokensAnnotationClassName;
    }

    public void init(String map, CoreTokenFactory<IN> tokenFactory, String tokensAnnotationClassName) {
        this.map = StringUtils.mapStringToArray(map);
        this.tokenFactory = tokenFactory;
        this.tokensAnnotationClassName = tokensAnnotationClassName;
    }

    @Override
    public Iterator<List<IN>> getIterator(Reader r) {
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        return new BufferedReaderIterator<List<IN>>(new ColumnDocBufferedGetNextTokens(br));
    }

    public Iterator<Annotation> getDocIterator(Reader r) {
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        return new BufferedReaderIterator<Annotation>(new ColumnDocBufferedGetNext(br, false));
    }

    public Iterator<Annotation> getDocIterator(Reader r, boolean includeText) {
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        return new BufferedReaderIterator<Annotation>(new ColumnDocBufferedGetNext(br, false, includeText));
    }

    private static <IN extends CoreMap> String join(Iterable<IN> l, Class textKey, String glue) {
        StringBuilder sb = new StringBuilder();
        for (CoreMap o : l) {
            if (sb.length() > 0) {
                sb.append(glue);
            }
            sb.append(o.get(textKey));
        }
        return sb.toString();
    }

    @Override
    public void printAnswers(List<IN> doc, PrintWriter out2) {
        for (CoreMap wi : doc) {
            String answer = (String)wi.get(CoreAnnotations.AnswerAnnotation.class);
            String goldAnswer = (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String tokenStr = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.TextAnnotation.class));
            out2.println(tokenStr + "\t" + goldAnswer + "\t" + answer);
        }
        out2.println();
    }

    private class ColumnDocBufferedGetNext
    implements GetNextFunction<Annotation> {
        private BufferedReader br;
        boolean includeText = false;
        boolean keepBoundaries = false;
        boolean returnTokensOnEmptyLine = true;
        boolean hasDocId = true;
        boolean hasDocStart = false;
        String docId;
        String newDocId;
        int itemCnt = 0;
        int lineCnt = 0;

        public ColumnDocBufferedGetNext(BufferedReader br) {
            this(br, true, false);
        }

        public ColumnDocBufferedGetNext(BufferedReader br, boolean returnSegmentsAsDocs) {
            this(br, returnSegmentsAsDocs, false);
        }

        public ColumnDocBufferedGetNext(BufferedReader br, boolean returnSegmentsAsDocs, boolean includeText) {
            this.br = br;
            this.includeText = includeText;
            if (returnSegmentsAsDocs) {
                this.keepBoundaries = false;
                this.returnTokensOnEmptyLine = true;
                this.hasDocStart = false;
            } else {
                this.keepBoundaries = true;
                this.returnTokensOnEmptyLine = false;
                this.hasDocStart = true;
            }
        }

        private Annotation createDoc(String docId, List<IN> tokens, List<IntPair> sentenceBoundaries, boolean includeText) {
            try {
                String docText = includeText ? ColumnTabDocumentReaderWriter.join(tokens, CoreAnnotations.TextAnnotation.class, " ") : null;
                Annotation doc = new Annotation(docText);
                doc.set(CoreAnnotations.DocIDAnnotation.class, docId);
                Class<?> tokensClass = Class.forName(ColumnTabDocumentReaderWriter.this.tokensAnnotationClassName);
                doc.set(tokensClass, tokens);
                boolean setTokenCharOffsets = includeText;
                if (setTokenCharOffsets) {
                    int i = 0;
                    for (CoreMap token : tokens) {
                        String tokenText = (String)token.get(CoreAnnotations.TextAnnotation.class);
                        token.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, i);
                        token.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, i += tokenText.length());
                        assert (i <= docText.length());
                        ++i;
                    }
                }
                if (sentenceBoundaries != null) {
                    ArrayList<Annotation> sentences = new ArrayList<Annotation>(sentenceBoundaries.size());
                    for (IntPair p : sentenceBoundaries) {
                        ArrayList sentenceTokens = new ArrayList(tokens.subList(p.getSource(), p.getTarget() + 1));
                        Integer begin = (Integer)((CoreMap)sentenceTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                        int last = sentenceTokens.size() - 1;
                        Integer end = (Integer)((CoreMap)sentenceTokens.get(last)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                        String sentenceText = includeText ? ColumnTabDocumentReaderWriter.join(sentenceTokens, CoreAnnotations.TextAnnotation.class, " ") : null;
                        Annotation sentence = new Annotation(sentenceText);
                        sentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
                        sentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
                        sentence.set(tokensClass, sentenceTokens);
                        sentence.set(CoreAnnotations.TokenBeginAnnotation.class, p.getSource());
                        sentence.set(CoreAnnotations.TokenEndAnnotation.class, p.getTarget() + 1);
                        int sentenceIndex = sentences.size();
                        sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
                        sentences.add(sentence);
                    }
                    doc.set(CoreAnnotations.SentencesAnnotation.class, sentences);
                }
                return doc;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
                return null;
            }
        }

        private void markBoundary(List<IN> words, List<IntPair> boundaries) {
            if (words != null && !words.isEmpty()) {
                int curWordIndex = words.size() - 1;
                if (boundaries.isEmpty()) {
                    boundaries.add(new IntPair(0, curWordIndex));
                } else {
                    int lastWordIndex = boundaries.get(boundaries.size() - 1).getTarget();
                    if (lastWordIndex < curWordIndex) {
                        boundaries.add(new IntPair(lastWordIndex + 1, curWordIndex));
                    }
                }
            }
        }

        @Override
        public Annotation getNext() {
            if (this.itemCnt > 0 && this.itemCnt % 1000 == 0) {
                log.info("[" + this.itemCnt + "," + this.lineCnt + "]");
                if (this.itemCnt % 10000 == 9000) {
                    log.info(new Object[0]);
                }
            }
            try {
                String line;
                ArrayList words = null;
                ArrayList<IntPair> boundaries = null;
                if (this.keepBoundaries) {
                    boundaries = new ArrayList<IntPair>();
                }
                while ((line = this.br.readLine()) != null) {
                    ++this.lineCnt;
                    if ((line = line.trim()).length() != 0) {
                        String[] info = ColumnTabDocumentReaderWriter.this.delimiterPattern.split(line);
                        if (ColumnTabDocumentReaderWriter.this.replaceWhitespace) {
                            for (int i = 0; i < info.length; ++i) {
                                info[i] = ColumnTabDocumentReaderWriter.this.whitespacePattern.matcher(info[i]).replaceAll("_");
                            }
                        }
                        if (this.hasDocId && line.startsWith("* ") && info.length == 1) {
                            this.newDocId = line.substring(2);
                            if (words == null) continue;
                            return this.createDoc(this.docId, words, boundaries, this.includeText);
                        }
                        if (this.hasDocStart && "-DOCSTART-".equals(info[0])) {
                            this.newDocId = "doc" + this.itemCnt;
                            if (words == null) continue;
                            if (this.keepBoundaries) {
                                this.markBoundary(words, boundaries);
                            }
                            return this.createDoc(this.docId, words, boundaries, this.includeText);
                        }
                        if (words == null) {
                            words = new ArrayList();
                            this.docId = this.newDocId;
                            ++this.itemCnt;
                        }
                        Object wi = info.length == ColumnTabDocumentReaderWriter.this.map.length ? ColumnTabDocumentReaderWriter.this.tokenFactory.makeToken(ColumnTabDocumentReaderWriter.this.map, info) : ColumnTabDocumentReaderWriter.this.tokenFactory.makeToken(ColumnTabDocumentReaderWriter.this.map, Arrays.asList(info).subList(0, ColumnTabDocumentReaderWriter.this.map.length).toArray(new String[ColumnTabDocumentReaderWriter.this.map.length]));
                        words.add(wi);
                        continue;
                    }
                    if (this.returnTokensOnEmptyLine && words != null) {
                        if (this.keepBoundaries) {
                            this.markBoundary(words, boundaries);
                        }
                        return this.createDoc(this.docId, words, boundaries, this.includeText);
                    }
                    if (!this.keepBoundaries) continue;
                    this.markBoundary(words, boundaries);
                }
                if (words == null) {
                    log.info("[" + this.itemCnt + "," + this.lineCnt + "]");
                }
                if (this.keepBoundaries) {
                    this.markBoundary(words, boundaries);
                }
                return words == null ? null : this.createDoc(this.docId, words, boundaries, this.includeText);
            }
            catch (IOException ex) {
                log.info("IOException: " + ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private class ColumnDocBufferedGetNextTokens<IN extends CoreMap>
    implements GetNextFunction<List<IN>> {
        ColumnDocBufferedGetNext docGetNext;

        public ColumnDocBufferedGetNextTokens(BufferedReader br) {
            this.docGetNext = new ColumnDocBufferedGetNext(br, true);
        }

        @Override
        public List<IN> getNext() {
            try {
                Annotation m = this.docGetNext.getNext();
                Class<?> tokensAnnotationClass = Class.forName(ColumnTabDocumentReaderWriter.this.tokensAnnotationClassName);
                return m != null ? m.get(tokensAnnotationClass) : null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class BufferedReaderIterator<E>
    extends AbstractIterator<E> {
        E nextItem;
        GetNextFunction<E> getNextFunc;

        public BufferedReaderIterator(GetNextFunction<E> getNextFunc) {
            this.getNextFunc = getNextFunc;
            this.nextItem = getNextFunc.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            if (this.nextItem == null) {
                throw new NoSuchElementException();
            }
            E item = this.nextItem;
            this.nextItem = this.getNextFunc.getNext();
            return item;
        }
    }

    private static interface GetNextFunction<E> {
        public E getNext();
    }
}

