/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class TSVUtils {
    private static final Pattern newline = Pattern.compile("\\\\n");
    private static final Pattern tab = Pattern.compile("\\\\t");

    private TSVUtils() {
    }

    static String unescapeSQL(String input) {
        if (input.startsWith("\"") && input.endsWith("\"")) {
            input = input.substring(1, input.length() - 1);
        }
        return input.replace("\"\"", "\"").replace("\\\\", "\\");
    }

    public static List<String> parseArray(String array) {
        if (array.startsWith("{") && array.endsWith("}")) {
            array = array.substring(1, array.length() - 1);
        }
        array = array.replace("\\\\", "\\");
        char[] input = array.toCharArray();
        ArrayList<String> output = new ArrayList<String>();
        StringBuilder elem = new StringBuilder();
        boolean inQuotes = false;
        boolean escaped = false;
        boolean doubledQuotes = false;
        char lastQuoteChar = '\u0000';
        for (int i = 0; i < input.length; ++i) {
            char next;
            char c = input[i];
            char c2 = next = i == input.length - 1 ? (char)'\u0000' : input[i + 1];
            if (escaped) {
                elem.append(c);
                escaped = false;
                continue;
            }
            if (c == '\"') {
                if (!inQuotes) {
                    inQuotes = true;
                    escaped = false;
                    lastQuoteChar = c;
                    if (next != c) continue;
                    ++i;
                    doubledQuotes = true;
                    continue;
                }
                if (c == lastQuoteChar) {
                    if (next == lastQuoteChar && !doubledQuotes) {
                        escaped = true;
                        continue;
                    }
                    inQuotes = false;
                    escaped = false;
                    if (!doubledQuotes) continue;
                    ++i;
                    doubledQuotes = false;
                    continue;
                }
                elem.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (inQuotes) {
                elem.append(c);
            } else if (c == ',') {
                output.add(elem.toString());
                elem.setLength(0);
            } else {
                elem.append(c);
            }
            escaped = false;
        }
        if (elem.length() > 0) {
            output.add(elem.toString());
        }
        return output;
    }

    public static SemanticGraph parseTree(String conll, List<CoreLabel> tokens) {
        SemanticGraph tree = new SemanticGraph();
        if (conll == null || conll.isEmpty()) {
            return tree;
        }
        String[] treeLines = newline.split(conll);
        IndexedWord[] vertices = new IndexedWord[tokens.size() + 2];
        for (String line : treeLines) {
            String[] fields = tab.split(line);
            int dependentIndex = Integer.parseInt(fields[0]);
            if (vertices[dependentIndex] == null) {
                if (dependentIndex > tokens.size()) {
                    return new SemanticGraph();
                }
                vertices[dependentIndex] = new IndexedWord(tokens.get(dependentIndex - 1));
            }
            IndexedWord dependent = vertices[dependentIndex];
            int governorIndex = Integer.parseInt(fields[1]);
            if (governorIndex > tokens.size()) {
                return new SemanticGraph();
            }
            if (vertices[governorIndex] == null && governorIndex > 0) {
                vertices[governorIndex] = new IndexedWord(tokens.get(governorIndex - 1));
            }
            IndexedWord governor = vertices[governorIndex];
            String relation = fields[2];
            if (governorIndex == 0) {
                tree.addRoot(dependent);
                continue;
            }
            tree.addVertex(dependent);
            if (!tree.containsVertex(governor)) {
                tree.addVertex(governor);
            }
            if ("ref".equals(relation)) continue;
            tree.addEdge(governor, dependent, GrammaticalRelation.valueOf(Language.English, relation), Double.NEGATIVE_INFINITY, false);
        }
        return tree;
    }

    public static SemanticGraph parseJsonTree(String jsonString, List<CoreLabel> tokens) {
        JsonReader json = Json.createReader((Reader)new StringReader(jsonString));
        SemanticGraph tree = new SemanticGraph();
        JsonArray array = json.readArray();
        if (array == null || array.isEmpty()) {
            return tree;
        }
        IndexedWord[] vertices = new IndexedWord[tokens.size() + 2];
        for (int i = 0; i < array.size(); ++i) {
            JsonObject entry = array.getJsonObject(i);
            int dependentIndex = entry.getInt("dependent");
            if (vertices[dependentIndex] == null) {
                if (dependentIndex > tokens.size()) {
                    return new SemanticGraph();
                }
                vertices[dependentIndex] = new IndexedWord(tokens.get(dependentIndex - 1));
            }
            IndexedWord dependent = vertices[dependentIndex];
            int governorIndex = entry.getInt("governor");
            if (governorIndex > tokens.size()) {
                return new SemanticGraph();
            }
            if (vertices[governorIndex] == null && governorIndex > 0) {
                vertices[governorIndex] = new IndexedWord(tokens.get(governorIndex - 1));
            }
            IndexedWord governor = vertices[governorIndex];
            String relation = entry.getString("dep");
            if (governorIndex == 0) {
                tree.addRoot(dependent);
                continue;
            }
            tree.addVertex(dependent);
            if (!tree.containsVertex(governor)) {
                tree.addVertex(governor);
            }
            if ("ref".equals(relation)) continue;
            tree.addEdge(governor, dependent, GrammaticalRelation.valueOf(Language.English, relation), Double.NEGATIVE_INFINITY, false);
        }
        return tree;
    }

    private static Annotation parseSentence(Optional<String> docid, Optional<Integer> sentenceIndex, String gloss, Function<List<CoreLabel>, SemanticGraph> tree, Function<List<CoreLabel>, SemanticGraph> maltTree, List<String> words, List<String> lemmas, List<String> pos, List<String> ner, Optional<String> sentenceid) {
        if (lemmas.size() != words.size()) {
            throw new IllegalArgumentException("Array lengths don't match: " + words.size() + " vs " + lemmas.size() + " (sentence " + sentenceid.orElse("???") + ")");
        }
        if (pos.size() != words.size()) {
            throw new IllegalArgumentException("Array lengths don't match: " + words.size() + " vs " + pos.size() + " (sentence " + sentenceid.orElse("???") + ")");
        }
        if (ner.size() != words.size()) {
            throw new IllegalArgumentException("Array lengths don't match: " + words.size() + " vs " + ner.size() + " (sentence " + sentenceid.orElse("???") + ")");
        }
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(words.size());
        int beginChar = 0;
        for (int i = 0; i < words.size(); ++i) {
            CoreLabel token = new CoreLabel(12);
            token.setWord(words.get(i));
            token.setValue(words.get(i));
            token.setBeginPosition(beginChar);
            token.setEndPosition(beginChar + words.get(i).length());
            beginChar += words.get(i).length() + 1;
            token.setLemma(lemmas.get(i));
            token.setTag(pos.get(i));
            token.setNER(ner.get(i));
            token.set(CoreAnnotations.DocIDAnnotation.class, docid.orElse("???"));
            token.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex.orElse(-1));
            token.set(CoreAnnotations.IndexAnnotation.class, i + 1);
            token.set(CoreAnnotations.TokenBeginAnnotation.class, i);
            token.set(CoreAnnotations.TokenEndAnnotation.class, i + 1);
            tokens.add(token);
        }
        gloss = gloss.replace("\\n", "\n").replace("\\t", "\t");
        ArrayCoreMap sentence = new ArrayCoreMap(16);
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        SemanticGraph graph = tree.apply(tokens);
        sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, graph);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, graph);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, graph);
        SemanticGraph maltGraph = maltTree.apply(tokens);
        sentence.set(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class, maltGraph);
        sentence.set(CoreAnnotations.DocIDAnnotation.class, docid.orElse("???"));
        sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex.orElse(-1));
        sentence.set(CoreAnnotations.TextAnnotation.class, gloss);
        sentence.set(CoreAnnotations.TokenBeginAnnotation.class, 0);
        sentence.set(CoreAnnotations.TokenEndAnnotation.class, tokens.size());
        Annotation doc = new Annotation(gloss);
        doc.set(CoreAnnotations.TokensAnnotation.class, tokens);
        doc.set(CoreAnnotations.SentencesAnnotation.class, Collections.singletonList(sentence));
        doc.set(CoreAnnotations.DocIDAnnotation.class, docid.orElse("???"));
        doc.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex.orElse(-1));
        return doc;
    }

    public static Annotation parseSentence(Optional<String> docid, Optional<String> sentenceIndex, String gloss, String dependencies, String maltDependencies, String words, String lemmas, String posTags, String nerTags, Optional<String> sentenceid) {
        return TSVUtils.parseSentence(docid, sentenceIndex.map(Integer::parseInt), gloss, (List<CoreLabel> tokens) -> TSVUtils.parseTree(dependencies, tokens), (List<CoreLabel> tokens) -> TSVUtils.parseTree(maltDependencies, tokens), TSVUtils.parseArray(words), TSVUtils.parseArray(lemmas), TSVUtils.parseArray(posTags), TSVUtils.parseArray(nerTags), sentenceid);
    }
}

