/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.DocDateAnnotator;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class NERCombinerAnnotator
extends SentenceAnnotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NERCombinerAnnotator.class);
    private final NERClassifierCombiner ner;
    private boolean rulesOnly = false;
    private boolean statisticalOnly = false;
    private final boolean VERBOSE;
    private boolean setDocDate = false;
    private final long maxTime;
    private final int nThreads;
    private final int maxSentenceLength;
    private final boolean applyNumericClassifiers;
    private LanguageInfo.HumanLanguage language = LanguageInfo.HumanLanguage.ENGLISH;
    private boolean useNERSpecificTokenization = true;
    private static HashSet<String> nerSpecificTokenizationExceptions = new HashSet<String>(Arrays.asList("based", "area", "registered", "headquartered", "native", "born", "raised", "backed", "controlled", "owned", "resident", "trained", "educated"));
    private static final String spanishNumberRegexRules = "edu/stanford/nlp/models/kbp/spanish/gazetteers/kbp_regexner_number_sp.tag";
    private TokensRegexNERAnnotator spanishNumberAnnotator;
    private boolean applyFineGrained = true;
    private TokensRegexNERAnnotator fineGrainedNERAnnotator;
    private boolean applyAdditionalRules = true;
    private TokensRegexNERAnnotator additionalRulesNERAnnotator;
    private boolean applyTokensRegexRules = false;
    private TokensRegexAnnotator tokensRegexAnnotator;
    private boolean buildEntityMentions = true;
    private EntityMentionsAnnotator entityMentionsAnnotator;
    private DocDateAnnotator docDateAnnotator;
    public static Function<CoreLabel, Boolean> afterIsEmpty = tok -> tok.containsKey(CoreAnnotations.AfterAnnotation.class) && tok.after().equals("");

    public NERCombinerAnnotator(Properties properties) throws IOException {
        this.rulesOnly = PropertiesUtils.getBool(properties, "ner.rulesOnly", false);
        this.statisticalOnly = PropertiesUtils.getBool(properties, "ner.statisticalOnly", false);
        ArrayList<String> models = new ArrayList<String>();
        if (!this.rulesOnly) {
            String modelNames = properties.getProperty("ner.model");
            if (modelNames == null) {
                modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
            }
            if (!(modelNames = modelNames.trim()).isEmpty()) {
                models.addAll(Arrays.asList(modelNames.split(",")));
            }
            if (models.isEmpty()) {
                log.info("WARNING: no NER models specified");
            }
        }
        this.applyNumericClassifiers = PropertiesUtils.getBool(properties, "ner.applyNumericClassifiers", true) && !this.statisticalOnly;
        boolean useSUTime = PropertiesUtils.getBool(properties, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT) && !this.statisticalOnly;
        NERClassifierCombiner.Language nerLanguage = NERClassifierCombiner.Language.fromString(PropertiesUtils.getString(properties, "ner.language", null), NERClassifierCombiner.NER_LANGUAGE_DEFAULT);
        boolean verbose = PropertiesUtils.getBool(properties, "ner.verbose", false);
        String[] loadPaths = models.toArray(new String[models.size()]);
        Properties combinerProperties = PropertiesUtils.extractSelectedProperties(properties, NERClassifierCombiner.DEFAULT_PASS_DOWN_PROPERTIES);
        if (useSUTime) {
            Properties sutimeProps = PropertiesUtils.extractPrefixedProperties(properties, "sutime.", true);
            PropertiesUtils.overWriteProperties(combinerProperties, sutimeProps);
        }
        NERClassifierCombiner nerCombiner = new NERClassifierCombiner(this.applyNumericClassifiers, nerLanguage, useSUTime, combinerProperties, loadPaths);
        this.nThreads = PropertiesUtils.getInt(properties, "ner.nthreads", PropertiesUtils.getInt(properties, "nthreads", 1));
        this.maxTime = PropertiesUtils.getLong(properties, "ner.maxtime", 0L);
        this.maxSentenceLength = PropertiesUtils.getInt(properties, "ner.maxlen", Integer.MAX_VALUE);
        this.language = LanguageInfo.getLanguageFromString(PropertiesUtils.getString(properties, "ner.language", "en"));
        this.useNERSpecificTokenization = PropertiesUtils.getBool(properties, "ner.useNERSpecificTokenization", true);
        if (this.language.equals((Object)LanguageInfo.HumanLanguage.SPANISH)) {
            Properties spanishNumberRegexNerProperties = new Properties();
            spanishNumberRegexNerProperties.setProperty("spanish.number.regexner.mapping", spanishNumberRegexRules);
            spanishNumberRegexNerProperties.setProperty("spanish.number.regexner.validpospattern", "^(NUM).*");
            spanishNumberRegexNerProperties.setProperty("spanish.number.regexner.ignorecase", "true");
            this.spanishNumberAnnotator = new TokensRegexNERAnnotator("spanish.number.regexner", spanishNumberRegexNerProperties);
        }
        this.setUpFineGrainedNER(properties);
        this.setUpAdditionalRulesNER(properties);
        this.setUpTokensRegexRules(properties);
        this.setUpEntityMentionBuilding(properties);
        this.setUpDocDateAnnotator(properties);
        log.info("Using numeric classifiers: " + this.applyNumericClassifiers);
        log.info("Using SUTime: " + useSUTime);
        log.info("Using fine grained: " + this.applyFineGrained);
        this.VERBOSE = verbose;
        this.ner = nerCombiner;
    }

    public NERCombinerAnnotator() throws IOException, ClassNotFoundException {
        this(true);
    }

    public NERCombinerAnnotator(boolean verbose) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(new Properties()), verbose);
    }

    public NERCombinerAnnotator(boolean verbose, String ... classifiers) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(classifiers), verbose);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose) {
        this(ner, verbose, 1, 0L, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime) {
        this(ner, verbose, nThreads, maxTime, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength) {
        this(ner, verbose, nThreads, maxTime, maxSentenceLength, true, true);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength, boolean fineGrained, boolean entityMentions) {
        this.VERBOSE = verbose;
        this.ner = ner;
        this.maxTime = maxTime;
        this.nThreads = nThreads;
        this.maxSentenceLength = maxSentenceLength;
        this.applyNumericClassifiers = true;
        this.useNERSpecificTokenization = false;
        Properties nerProperties = new Properties();
        nerProperties.setProperty("ner.applyFineGrained", Boolean.toString(fineGrained));
        nerProperties.setProperty("ner.buildEntityMentions", Boolean.toString(entityMentions));
        this.setUpAdditionalRulesNER(nerProperties);
        this.setUpFineGrainedNER(nerProperties);
        this.setUpEntityMentionBuilding(nerProperties);
    }

    private void setUpFineGrainedNER(Properties properties) {
        boolean bl = this.applyFineGrained = PropertiesUtils.getBool(properties, "ner.applyFineGrained", true) && !this.statisticalOnly;
        if (this.applyFineGrained) {
            String fineGrainedPrefix = "ner.fine.regexner";
            Properties fineGrainedProps = PropertiesUtils.extractPrefixedProperties(properties, fineGrainedPrefix + '.', true);
            if (!fineGrainedProps.containsKey("ner.fine.regexner.mapping")) {
                fineGrainedProps.setProperty("ner.fine.regexner.mapping", "ignorecase=true,validpospattern=^(NN|JJ).*,edu/stanford/nlp/models/kbp/english/gazetteers/regexner_caseless.tab;edu/stanford/nlp/models/kbp/english/gazetteers/regexner_cased.tab");
            }
            this.fineGrainedNERAnnotator = new TokensRegexNERAnnotator(fineGrainedPrefix, fineGrainedProps);
        }
    }

    private void setUpAdditionalRulesNER(Properties properties) {
        boolean bl = this.applyAdditionalRules = !properties.getProperty("ner.additional.regexner.mapping", "").isEmpty() && !this.statisticalOnly;
        if (this.applyAdditionalRules) {
            String additionalRulesPrefix = "ner.additional.regexner";
            Properties additionalRulesProps = PropertiesUtils.extractPrefixedProperties(properties, additionalRulesPrefix + '.', true);
            this.additionalRulesNERAnnotator = new TokensRegexNERAnnotator(additionalRulesPrefix, additionalRulesProps);
        }
    }

    private void setUpTokensRegexRules(Properties properties) {
        boolean bl = this.applyTokensRegexRules = !properties.getProperty("ner.additional.tokensregex.rules", "").isEmpty() && !this.statisticalOnly;
        if (this.applyTokensRegexRules) {
            String tokensRegexRulesPrefix = "ner.additional.tokensregex";
            Properties tokensRegexRulesProps = PropertiesUtils.extractPrefixedProperties(properties, tokensRegexRulesPrefix + '.', true);
            this.tokensRegexAnnotator = new TokensRegexAnnotator(tokensRegexRulesPrefix, tokensRegexRulesProps);
        }
    }

    private void setUpEntityMentionBuilding(Properties properties) {
        this.buildEntityMentions = PropertiesUtils.getBool(properties, "ner.buildEntityMentions", true);
        if (this.buildEntityMentions) {
            String entityMentionsPrefix = "ner.entitymentions";
            Properties entityMentionsProps = PropertiesUtils.extractPrefixedProperties(properties, entityMentionsPrefix + '.', true);
            entityMentionsProps.setProperty("ner.entitymentions.language", this.language.name());
            this.entityMentionsAnnotator = new EntityMentionsAnnotator(entityMentionsPrefix, entityMentionsProps);
        }
    }

    private void setUpDocDateAnnotator(Properties properties) throws IOException {
        for (String property : properties.stringPropertyNames()) {
            if (property.length() < 11 || !property.substring(0, 11).equals("ner.docdate")) continue;
            this.setDocDate = true;
            this.docDateAnnotator = new DocDateAnnotator("ner.docdate", properties);
            break;
        }
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    public static void mergeTokens(CoreLabel token, CoreLabel nextToken) {
        token.setWord(token.word() + nextToken.word());
        token.setAfter(nextToken.after());
        token.setEndPosition(nextToken.endPosition());
        token.setValue(token.word() + "-" + token.sentIndex());
        if (token.get(TokenMergeCountAnnotation.class) == null) {
            token.set(TokenMergeCountAnnotation.class, 1);
        } else {
            token.set(TokenMergeCountAnnotation.class, (Integer)token.get(TokenMergeCountAnnotation.class) + 1);
        }
    }

    private static Annotation annotationWithNERTokenization(Annotation originalAnnotation) {
        Annotation copyAnnotation = new Annotation((String)originalAnnotation.get(CoreAnnotations.TextAnnotation.class));
        copyAnnotation.set(CoreAnnotations.SentencesAnnotation.class, new ArrayList());
        for (CoreMap sentence : (List)originalAnnotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            List originalTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            ArrayList<CoreLabel> copyTokens = new ArrayList<CoreLabel>();
            int nextTokenIndex = 0;
            for (CoreLabel currToken : originalTokens) {
                CoreLabel lastProcessedToken;
                ++nextTokenIndex;
                CoreLabel processedToken = new CoreLabel(currToken);
                CoreLabel coreLabel = lastProcessedToken = copyTokens.size() > 0 ? (CoreLabel)copyTokens.get(copyTokens.size() - 1) : null;
                if (lastProcessedToken != null && afterIsEmpty.apply(lastProcessedToken).booleanValue() && currToken.word().equals("-")) {
                    if (nextTokenIndex < originalTokens.size() && !nerSpecificTokenizationExceptions.contains(((CoreLabel)originalTokens.get(nextTokenIndex)).word())) {
                        NERCombinerAnnotator.mergeTokens(lastProcessedToken, currToken);
                        continue;
                    }
                    copyTokens.add(processedToken);
                    continue;
                }
                if (lastProcessedToken != null && lastProcessedToken.word().endsWith("-") && afterIsEmpty.apply(lastProcessedToken).booleanValue() && !nerSpecificTokenizationExceptions.contains(currToken.word())) {
                    NERCombinerAnnotator.mergeTokens(lastProcessedToken, currToken);
                    continue;
                }
                copyTokens.add(processedToken);
            }
            Annotation copySentence = new Annotation((String)sentence.get(CoreAnnotations.TextAnnotation.class));
            copySentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
            copySentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
            copySentence.set(CoreAnnotations.SentenceIndexAnnotation.class, sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
            copySentence.set(CoreAnnotations.TokensAnnotation.class, copyTokens);
            ((List)copyAnnotation.get(CoreAnnotations.SentencesAnnotation.class)).add(copySentence);
        }
        copyAnnotation.set(CoreAnnotations.TokensAnnotation.class, new ArrayList());
        int globalTokenIndex = 0;
        for (CoreMap sentence : (List)copyAnnotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                token.set(CoreAnnotations.TokenBeginAnnotation.class, globalTokenIndex);
                token.set(CoreAnnotations.TokenEndAnnotation.class, globalTokenIndex + 1);
                ((List)copyAnnotation.get(CoreAnnotations.TokensAnnotation.class)).add(token);
                ++globalTokenIndex;
            }
            sentence.set(CoreAnnotations.TokenBeginAnnotation.class, ((CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(0)).get(CoreAnnotations.TokenBeginAnnotation.class));
            sentence.set(CoreAnnotations.TokenEndAnnotation.class, ((CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).size() - 1)).get(CoreAnnotations.TokenEndAnnotation.class));
        }
        return copyAnnotation;
    }

    public static void transferNERAnnotationsToAnnotation(Annotation nerTokenizedAnnotation, Annotation originalAnnotation) {
        if (((List)nerTokenizedAnnotation.get(CoreAnnotations.TokensAnnotation.class)).isEmpty() || ((List)originalAnnotation.get(CoreAnnotations.TokensAnnotation.class)).isEmpty()) {
            return;
        }
        List<Class> nerKeys = Arrays.asList(CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, CoreAnnotations.NamedEntityTagProbsAnnotation.class, CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class, CoreAnnotations.CoarseNamedEntityTagAnnotation.class, TimeAnnotations.TimexAnnotation.class, CoreAnnotations.NumericValueAnnotation.class, CoreAnnotations.NumericTypeAnnotation.class, CoreAnnotations.NumericCompositeValueAnnotation.class, CoreAnnotations.NumericCompositeTypeAnnotation.class);
        List originalTokens = (List)originalAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        List nerTokenizedTokens = (List)nerTokenizedAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        int nerTokenizedIdx = 0;
        int mergeCount = 0;
        int originalIdx = 0;
        while (originalIdx < originalTokens.size()) {
            CoreLabel origToken = (CoreLabel)originalTokens.get(originalIdx);
            CoreLabel nerTokenizedToken = (CoreLabel)nerTokenizedTokens.get(nerTokenizedIdx);
            for (Class c : nerKeys) {
                if (nerTokenizedToken.get(c) == null) continue;
                origToken.set(c, nerTokenizedToken.get(c));
            }
            ++originalIdx;
            if (mergeCount == 0 && nerTokenizedToken.get(TokenMergeCountAnnotation.class) != null) {
                mergeCount = (Integer)nerTokenizedToken.get(TokenMergeCountAnnotation.class);
                continue;
            }
            if (mergeCount > 1) {
                --mergeCount;
                continue;
            }
            mergeCount = 0;
            ++nerTokenizedIdx;
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            log.info("Adding NER Combiner annotation ... ");
        }
        Annotation nerAnnotation = this.useNERSpecificTokenization ? NERCombinerAnnotator.annotationWithNERTokenization(annotation) : annotation;
        if (this.setDocDate) {
            this.docDateAnnotator.annotate(nerAnnotation);
        }
        super.annotate(nerAnnotation);
        this.ner.finalizeAnnotation(nerAnnotation);
        if (this.VERBOSE) {
            log.info("done.");
        }
        if (LanguageInfo.HumanLanguage.SPANISH.equals((Object)this.language) && this.applyNumericClassifiers) {
            this.spanishNumberAnnotator.annotate(nerAnnotation);
        }
        for (CoreLabel token : (List)nerAnnotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (token == null || token.ner() == null || !token.ner().equals("MONEY") && !token.ner().equals("NUMBER")) continue;
            token.remove(TimeAnnotations.TimexAnnotation.class);
        }
        if (!this.statisticalOnly && (this.applyFineGrained || this.applyAdditionalRules || this.applyTokensRegexRules)) {
            if (this.applyFineGrained) {
                this.fineGrainedNERAnnotator.annotate(nerAnnotation);
            }
            if (this.applyAdditionalRules) {
                this.additionalRulesNERAnnotator.annotate(nerAnnotation);
            }
            if (this.applyTokensRegexRules) {
                this.tokensRegexAnnotator.annotate(nerAnnotation);
            }
            for (CoreLabel token : (List)nerAnnotation.get(CoreAnnotations.TokensAnnotation.class)) {
                String fineGrainedTag = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                token.set(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class, fineGrainedTag);
            }
        }
        for (CoreLabel token : (List)nerAnnotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (token.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class) != null) continue;
            Map<String, Double> labelToProb = Collections.singletonMap(token.ner(), -1.0);
            token.set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, labelToProb);
        }
        if (this.useNERSpecificTokenization) {
            NERCombinerAnnotator.transferNERAnnotationsToAnnotation(nerAnnotation, annotation);
        }
        if (this.buildEntityMentions) {
            this.entityMentionsAnnotator.annotate(annotation);
        }
    }

    @Override
    public void doOneSentence(Annotation annotation, CoreMap sentence) {
        List output;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens.size() <= this.maxSentenceLength) {
            try {
                output = this.ner.classifySentenceWithGlobalInformation(tokens, annotation, sentence);
            }
            catch (RuntimeInterruptedException e) {
                output = null;
            }
        } else {
            output = null;
        }
        if (output == null) {
            this.doOneFailedSentence(annotation, sentence);
        } else {
            int sz = tokens.size();
            for (int i = 0; i < sz; ++i) {
                String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normNeTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                Map neTagProbMap = (Map)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
                ((CoreLabel)tokens.get(i)).setNER(neTag);
                ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, neTagProbMap);
                ((CoreLabel)tokens.get(i)).set(CoreAnnotations.CoarseNamedEntityTagAnnotation.class, neTag);
                if (normNeTag != null) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, normNeTag);
                }
                NumberSequenceClassifier.transferAnnotations((CoreLabel)output.get(i), (CoreLabel)tokens.get(i));
            }
            if (this.VERBOSE) {
                boolean first = true;
                StringBuilder sb = new StringBuilder("NERCombinerAnnotator output: [");
                for (CoreLabel w : tokens) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(w.toShorterString("Text", "NamedEntityTag", "NormalizedNamedEntityTag"));
                }
                sb.append(']');
                log.info(sb);
            }
        }
    }

    @Override
    public void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            if (token.ner() != null) continue;
            token.setNER(this.ner.backgroundSymbol());
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        if (this.ner.usesSUTime() || this.ner.appliesNumericClassifiers() || this.applyFineGrained) {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.IsNewlineAnnotation.class)));
        }
        return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.IsNewlineAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        HashSet<Class<? extends CoreAnnotation>> nerRequirementsSatisfied = new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, CoreAnnotations.ValueAnnotation.class, TimeExpression.Annotation.class, TimeExpression.TimeIndexAnnotation.class, CoreAnnotations.DistSimAnnotation.class, CoreAnnotations.NumericCompositeTypeAnnotation.class, TimeAnnotations.TimexAnnotation.class, CoreAnnotations.NumericValueAnnotation.class, TimeExpression.ChildrenAnnotation.class, CoreAnnotations.NumericTypeAnnotation.class, CoreAnnotations.ShapeAnnotation.class, Tags.TagsAnnotation.class, CoreAnnotations.NumerizedTokensAnnotation.class, CoreAnnotations.AnswerAnnotation.class, CoreAnnotations.NumericCompositeValueAnnotation.class, CoreAnnotations.CoarseNamedEntityTagAnnotation.class, CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class));
        if (this.buildEntityMentions) {
            nerRequirementsSatisfied.add(CoreAnnotations.MentionsAnnotation.class);
            nerRequirementsSatisfied.add(CoreAnnotations.EntityTypeAnnotation.class);
            nerRequirementsSatisfied.add(CoreAnnotations.EntityMentionIndexAnnotation.class);
        }
        return nerRequirementsSatisfied;
    }

    public static class TokenMergeCountAnnotation
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }
}

