/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.data.WordLists;
import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.pipeline.LabeledChunkIdentifier;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.AcronymMatcher;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;

public class EntityMentionsAnnotator
implements Annotator {
    private final LabeledChunkIdentifier chunkIdentifier;
    private final boolean doAcronyms;
    private static final boolean matchTokenText = false;
    private final LanguageInfo.HumanLanguage entityMentionsLanguage;
    public static PropertiesUtils.Property[] SUPPORTED_PROPERTIES = new PropertiesUtils.Property[0];
    private Class<? extends CoreAnnotation<String>> nerCoreAnnotationClass = CoreAnnotations.NamedEntityTagAnnotation.class;
    private Class<? extends CoreAnnotation<String>> nerNormalizedCoreAnnotationClass = CoreAnnotations.NormalizedNamedEntityTagAnnotation.class;
    private Class<? extends CoreAnnotation<List<CoreMap>>> mentionsCoreAnnotationClass = CoreAnnotations.MentionsAnnotation.class;
    private static final Redwood.RedwoodChannels log = Redwood.channels(EntityMentionsAnnotator.class);
    private final Predicate<Pair<CoreLabel, CoreLabel>> IS_TOKENS_COMPATIBLE = in -> {
        Number n2;
        Number n1;
        String v2;
        CoreLabel cur = (CoreLabel)in.first;
        CoreLabel prev = (CoreLabel)in.second;
        if (cur == null || prev == null) {
            return false;
        }
        String v1 = (String)cur.get(this.nerNormalizedCoreAnnotationClass);
        if (!Objects.equals(v1, v2 = (String)prev.get(this.nerNormalizedCoreAnnotationClass))) {
            return false;
        }
        String nerTag = (String)cur.get(this.nerCoreAnnotationClass);
        if (("NUMBER".equals(nerTag) || "ORDINAL".equals(nerTag)) && !Objects.equals(n1 = (Number)cur.get(CoreAnnotations.NumericCompositeValueAnnotation.class), n2 = (Number)prev.get(CoreAnnotations.NumericCompositeValueAnnotation.class))) {
            return false;
        }
        if ("TIME".equals(nerTag) || "SET".equals(nerTag) || "DATE".equals(nerTag) || "DURATION".equals(nerTag)) {
            String tid2;
            Timex timex1 = (Timex)cur.get(TimeAnnotations.TimexAnnotation.class);
            Timex timex2 = (Timex)prev.get(TimeAnnotations.TimexAnnotation.class);
            String tid1 = timex1 != null ? timex1.tid() : null;
            String string = tid2 = timex2 != null ? timex2.tid() : null;
            if (!Objects.equals(tid1, tid2)) {
                return false;
            }
        }
        return true;
    };

    public EntityMentionsAnnotator() {
        this.chunkIdentifier = new LabeledChunkIdentifier();
        this.doAcronyms = false;
        this.entityMentionsLanguage = LanguageInfo.getLanguageFromString("en");
    }

    public EntityMentionsAnnotator(String name, Properties props) {
        try {
            if (props.containsKey(name + ".nerCoreAnnotation")) {
                this.nerCoreAnnotationClass = Class.forName(props.getProperty(name + ".nerCoreAnnotation"));
            }
            if (props.containsKey(name + ".nerNormalizedCoreAnnotation")) {
                this.nerNormalizedCoreAnnotationClass = Class.forName(props.getProperty(name + ".nerNormalizedCoreAnnotation"));
            }
            if (props.containsKey(name + ".mentionsCoreAnnotation")) {
                this.mentionsCoreAnnotationClass = Class.forName(props.getProperty(name + ".mentionsCoreAnnotation"));
            }
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage());
        }
        this.chunkIdentifier = new LabeledChunkIdentifier();
        this.doAcronyms = Boolean.parseBoolean(props.getProperty(name + ".acronyms", props.getProperty("acronyms", "false")));
        this.entityMentionsLanguage = LanguageInfo.getLanguageFromString(props.getProperty(name + ".language", "en"));
    }

    private static List<CoreLabel> tokensForCharacters(List<CoreLabel> tokens, int charBegin, int charEnd) {
        assert (charBegin >= 0);
        ArrayList<CoreLabel> segment = Generics.newArrayList();
        for (CoreLabel token : tokens) {
            if (token.endPosition() < charBegin || token.beginPosition() >= charEnd) continue;
            segment.add(token);
        }
        return segment;
    }

    private static Optional<CoreMap> overlapsWithMention(CoreMap needle, List<CoreMap> haystack) {
        List tokens = (List)needle.get(CoreAnnotations.TokensAnnotation.class);
        int charBegin = ((CoreLabel)tokens.get(0)).beginPosition();
        int charEnd = ((CoreLabel)tokens.get(tokens.size() - 1)).endPosition();
        return haystack.stream().filter(mention_ -> {
            List tokens_ = (List)mention_.get(CoreAnnotations.TokensAnnotation.class);
            int charBegin_ = ((CoreLabel)tokens_.get(0)).beginPosition();
            int charEnd_ = ((CoreLabel)tokens_.get(tokens_.size() - 1)).endPosition();
            return charBegin_ <= charEnd && charEnd_ >= charBegin;
        }).findFirst();
    }

    private static boolean kbpIsPronominalMention(CoreLabel word) {
        return WordLists.isKbpPronominalMention(word.word());
    }

    private static List<CoreMap> annotatePronominalMentions(Annotation ann) {
        ArrayList<CoreMap> pronouns = new ArrayList<CoreMap>();
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        for (int sentenceIndex = 0; sentenceIndex < sentences.size(); ++sentenceIndex) {
            CoreMap sentence = (CoreMap)sentences.get(sentenceIndex);
            Integer annoTokenBegin = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            if (annoTokenBegin == null) {
                annoTokenBegin = 0;
            }
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
                CoreLabel token = (CoreLabel)tokens.get(tokenIndex);
                if (!EntityMentionsAnnotator.kbpIsPronominalMention(token)) continue;
                Annotation pronoun = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenIndex, tokenIndex + 1, annoTokenBegin, null, CoreAnnotations.TextAnnotation.class, null);
                pronoun.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
                pronoun.set(CoreAnnotations.NamedEntityTagAnnotation.class, KBPRelationExtractor.NERTag.PERSON.name);
                pronoun.set(CoreAnnotations.EntityTypeAnnotation.class, KBPRelationExtractor.NERTag.PERSON.name);
                String pronounGender = null;
                if (((String)pronoun.get(CoreAnnotations.TextAnnotation.class)).toLowerCase().equals("she")) {
                    pronounGender = "FEMALE";
                    pronoun.set(CoreAnnotations.GenderAnnotation.class, pronounGender);
                } else if (((String)pronoun.get(CoreAnnotations.TextAnnotation.class)).toLowerCase().equals("he")) {
                    pronounGender = "MALE";
                    pronoun.set(CoreAnnotations.GenderAnnotation.class, pronounGender);
                }
                if (pronounGender != null) {
                    for (CoreLabel pronounToken : (List)pronoun.get(CoreAnnotations.TokensAnnotation.class)) {
                        pronounToken.set(CoreAnnotations.GenderAnnotation.class, pronounGender);
                    }
                }
                ((List)sentence.get(CoreAnnotations.MentionsAnnotation.class)).add(pronoun);
                pronouns.add(pronoun);
            }
        }
        return pronouns;
    }

    public static HashMap<String, Double> determineEntityMentionConfidences(CoreMap entityMention) {
        Set labelsWithProbs = ((Map)((CoreLabel)((List)entityMention.get(CoreAnnotations.TokensAnnotation.class)).get(0)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).keySet();
        HashMap<String, Double> entityLabelProbVals = new HashMap<String, Double>();
        for (String labelWithProb : labelsWithProbs) {
            entityLabelProbVals.put(labelWithProb, 1.1);
        }
        for (CoreLabel token : (List)entityMention.get(CoreAnnotations.TokensAnnotation.class)) {
            Map labelProbsForToken = (Map)token.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
            for (String label : labelProbsForToken.keySet()) {
                if (!entityLabelProbVals.containsKey(label) || !((Double)labelProbsForToken.get(label) < entityLabelProbVals.get(label))) continue;
                entityLabelProbVals.put(label, (Double)labelProbsForToken.get(label));
            }
        }
        for (String label : entityLabelProbVals.keySet()) {
            if (!(entityLabelProbVals.get(label) >= 1.1)) continue;
            entityLabelProbVals.put(label, -1.0);
        }
        return entityLabelProbVals;
    }

    @Override
    public void annotate(Annotation annotation) {
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        int sentenceIndex = 0;
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            Integer annoTokenBegin = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            if (annoTokenBegin == null) {
                annoTokenBegin = 0;
            }
            List<CoreMap> chunks = this.chunkIdentifier.getAnnotatedChunks(tokens, annoTokenBegin, CoreAnnotations.TextAnnotation.class, this.nerCoreAnnotationClass, this.IS_TOKENS_COMPATIBLE);
            sentence.set(this.mentionsCoreAnnotationClass, chunks);
            List mentions = (List)sentence.get(this.mentionsCoreAnnotationClass);
            if (mentions != null) {
                for (CoreMap mention : mentions) {
                    List mentionTokens = (List)mention.get(CoreAnnotations.TokensAnnotation.class);
                    String name = (String)CoreMapAttributeAggregator.FIRST_NON_NIL.aggregate(this.nerNormalizedCoreAnnotationClass, mentionTokens);
                    if (name == null) {
                        name = (String)mention.get(CoreAnnotations.TextAnnotation.class);
                    } else {
                        mention.set(this.nerNormalizedCoreAnnotationClass, name);
                    }
                    String type = (String)mention.get(this.nerCoreAnnotationClass);
                    mention.set(CoreAnnotations.EntityTypeAnnotation.class, type);
                    mention.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
                    Timex timex = (Timex)CoreMapAttributeAggregator.FIRST_NON_NIL.aggregate(TimeAnnotations.TimexAnnotation.class, mentionTokens);
                    if (timex != null) {
                        mention.set(TimeAnnotations.TimexAnnotation.class, timex);
                    }
                    if (mention.get(CoreAnnotations.WikipediaEntityAnnotation.class) == null) {
                        for (CoreLabel token : mentionTokens) {
                            if (mention.get(CoreAnnotations.WikipediaEntityAnnotation.class) != null && !"O".equals(mention.get(CoreAnnotations.WikipediaEntityAnnotation.class)) || token.get(CoreAnnotations.WikipediaEntityAnnotation.class) == null || "O".equals(token.get(CoreAnnotations.WikipediaEntityAnnotation.class))) continue;
                            mention.set(CoreAnnotations.WikipediaEntityAnnotation.class, token.get(CoreAnnotations.WikipediaEntityAnnotation.class));
                        }
                    }
                    if (annotation.get(CoreAnnotations.TextAnnotation.class) == null || mention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) == null || mention.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) == null) continue;
                    String entityMentionText = ((String)annotation.get(CoreAnnotations.TextAnnotation.class)).substring((Integer)mention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)mention.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                    mention.set(CoreAnnotations.TextAnnotation.class, entityMentionText);
                }
            }
            ++sentenceIndex;
        }
        if (this.doAcronyms) {
            this.addAcronyms(annotation);
        }
        if (LanguageInfo.HumanLanguage.ENGLISH.equals((Object)this.entityMentionsLanguage)) {
            EntityMentionsAnnotator.annotatePronominalMentions(annotation);
        }
        ArrayList<CoreMap> allEntityMentions = new ArrayList<CoreMap>();
        int entityMentionIndex = 0;
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap entityMention : (List)sentence.get(this.mentionsCoreAnnotationClass)) {
                entityMention.set(CoreAnnotations.EntityMentionIndexAnnotation.class, entityMentionIndex);
                entityMention.set(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class, entityMentionIndex);
                for (CoreLabel entityMentionToken : (List)entityMention.get(CoreAnnotations.TokensAnnotation.class)) {
                    entityMentionToken.set(CoreAnnotations.EntityMentionIndexAnnotation.class, entityMentionIndex);
                }
                allEntityMentions.add(entityMention);
                ++entityMentionIndex;
            }
        }
        for (CoreMap entityMention : allEntityMentions) {
            HashMap<String, Double> entityMentionLabelProbVals = EntityMentionsAnnotator.determineEntityMentionConfidences(entityMention);
            entityMention.set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, entityMentionLabelProbVals);
        }
        annotation.set(this.mentionsCoreAnnotationClass, allEntityMentions);
    }

    private void addAcronyms(Annotation ann) {
        ArrayList allMentionsSoFar = new ArrayList();
        for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
            allMentionsSoFar.addAll((Collection)sentence.get(CoreAnnotations.MentionsAnnotation.class));
        }
        ArrayList organizations = new ArrayList();
        for (CoreMap mention : allMentionsSoFar) {
            if (!"ORGANIZATION".equals(mention.get(this.nerCoreAnnotationClass))) continue;
            organizations.add(mention.get(CoreAnnotations.TokensAnnotation.class));
        }
        if (organizations.size() > 100) {
            return;
        }
        for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
            ArrayList<Annotation> sentenceMentions = new ArrayList<Annotation>();
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            Integer totalTokensOffset = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            for (int i = 0; i < tokens.size(); ++i) {
                CoreLabel token = (CoreLabel)tokens.get(i);
                if (!"O".equals(token.ner()) || !token.word().toUpperCase().equals(token.word()) || token.word().length() < 3) continue;
                for (List org : organizations) {
                    if (!AcronymMatcher.isAcronym(token.word(), org)) continue;
                    token.setNER("ORGANIZATION");
                    Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, i, i + 1, totalTokensOffset, null, null, null);
                    chunk.set(CoreAnnotations.NamedEntityTagAnnotation.class, "ORGANIZATION");
                    sentenceMentions.add(chunk);
                }
            }
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        if (!this.nerCoreAnnotationClass.getCanonicalName().equals(CoreAnnotations.NamedEntityTagAnnotation.class.getCanonicalName())) {
            return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
        }
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(this.mentionsCoreAnnotationClass);
    }
}

