/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.md.CorefMentionFinder;
import edu.stanford.nlp.coref.md.DependencyCorefMentionFinder;
import edu.stanford.nlp.coref.md.HybridCorefMentionFinder;
import edu.stanford.nlp.coref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.TextAnnotationCreator;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class CorefMentionAnnotator
extends TextAnnotationCreator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CorefMentionAnnotator.class);
    private HeadFinder headFinder;
    private CorefMentionFinder md;
    private String mdName;
    private Dictionaries dictionaries;
    private Properties corefProperties;
    private final Set<Class<? extends CoreAnnotation>> mentionAnnotatorRequirements = new HashSet<Class<? extends CoreAnnotation>>();

    public CorefMentionAnnotator(Properties props) {
        try {
            this.corefProperties = props;
            this.dictionaries = new Dictionaries(props);
            this.headFinder = CorefProperties.getHeadFinder(props);
            this.md = this.getMentionFinder(props, this.headFinder);
            log.info("Using mention detector type: " + this.mdName);
            this.mentionAnnotatorRequirements.addAll(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.EntityTypeAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.TextAnnotation.class, CoreAnnotations.ValueAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class));
        }
        catch (Exception e) {
            log.info("Error with building coref mention annotator!");
            log.info(e);
        }
    }

    public static boolean synchCorefMentionEntityMention(Annotation ann, Mention cm, CoreMap em) {
        int currCMTokenIndex;
        int tokenOverlapCount = 0;
        CoreMap cmSentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(cm.sentNum);
        List cmTokens = ((List)cmSentence.get(CoreAnnotations.TokensAnnotation.class)).subList(cm.startIndex, cm.endIndex);
        if (((String)em.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("PERSON")) {
            for (currCMTokenIndex = 0; currCMTokenIndex < cmTokens.size() && ((CoreLabel)cmTokens.get(currCMTokenIndex)).get(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class) != null && ((String)((CoreLabel)cmTokens.get(currCMTokenIndex)).get(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class)).equals("TITLE"); ++currCMTokenIndex) {
            }
        }
        int currEMTokenIndex = 0;
        List emTokens = (List)em.get(CoreAnnotations.TokensAnnotation.class);
        while (currEMTokenIndex < emTokens.size() && currCMTokenIndex < cmTokens.size()) {
            if (emTokens.get(currEMTokenIndex) != cmTokens.get(currCMTokenIndex)) {
                return false;
            }
            ++currCMTokenIndex;
            ++currEMTokenIndex;
            ++tokenOverlapCount;
        }
        if (currCMTokenIndex < cmTokens.size() && ((CoreLabel)cmTokens.get(currCMTokenIndex)).word().equals("'s")) {
            ++currCMTokenIndex;
        }
        return currCMTokenIndex >= cmTokens.size() && currEMTokenIndex >= emTokens.size() && tokenOverlapCount != 0;
    }

    @Override
    public void annotate(Annotation annotation) {
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docID == null) {
            docID = "";
        }
        if (docID.contains("nw") && (CorefProperties.conll(this.corefProperties) || this.corefProperties.getProperty("coref.input.type", "raw").equals("conll")) && CorefProperties.getLanguage(this.corefProperties) == Locale.CHINESE && PropertiesUtils.getBool(this.corefProperties, "coref.specialCaseNewswire")) {
            this.corefProperties.setProperty("removeNestedMentions", "false");
        } else {
            this.corefProperties.setProperty("removeNestedMentions", "true");
        }
        List<List<Mention>> mentions = this.md.findMentions(annotation, this.dictionaries, this.corefProperties);
        annotation.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, new ArrayList());
        int mentionIndex = 0;
        int currIndex = 0;
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            token.set(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class, new ArraySet());
        }
        for (CoreMap sentence : sentences) {
            List<Mention> mentionsForThisSentence = mentions.get(currIndex);
            sentence.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, mentionsForThisSentence);
            ((List)annotation.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)).addAll(mentionsForThisSentence);
            for (Mention corefMention : mentionsForThisSentence) {
                corefMention.sentNum = currIndex;
            }
            ++currIndex;
            for (Mention m : mentionsForThisSentence) {
                m.mentionID = mentionIndex;
                for (int corefMentionTokenIndex = m.startIndex; corefMentionTokenIndex < m.endIndex; ++corefMentionTokenIndex) {
                    CoreLabel currToken = (CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(corefMentionTokenIndex);
                    ((Set)currToken.get(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class)).add(mentionIndex);
                }
                ++mentionIndex;
            }
        }
        HashMap<Integer, Integer> corefMentionToEntityMentionMapping = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> entityMentionToCorefMentionMapping = new HashMap<Integer, Integer>();
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (token.get(CoreAnnotations.EntityMentionIndexAnnotation.class) == null) continue;
            int tokenEntityMentionIndex = (Integer)token.get(CoreAnnotations.EntityMentionIndexAnnotation.class);
            CoreMap tokenEntityMention = (CoreMap)((List)annotation.get(CoreAnnotations.MentionsAnnotation.class)).get(tokenEntityMentionIndex);
            for (Integer candidateCorefMentionIndex : (Set)token.get(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class)) {
                Mention candidateTokenCorefMention = (Mention)((List)annotation.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)).get(candidateCorefMentionIndex);
                if (!CorefMentionAnnotator.synchCorefMentionEntityMention(annotation, candidateTokenCorefMention, tokenEntityMention)) continue;
                entityMentionToCorefMentionMapping.put(tokenEntityMentionIndex, candidateCorefMentionIndex);
                corefMentionToEntityMentionMapping.put(candidateCorefMentionIndex, tokenEntityMentionIndex);
            }
        }
        annotation.set(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class, corefMentionToEntityMentionMapping);
        annotation.set(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class, entityMentionToCorefMentionMapping);
    }

    private CorefMentionFinder getMentionFinder(Properties props, HeadFinder headFinder) throws ClassNotFoundException, IOException {
        switch (CorefProperties.mdType(props)) {
            case DEPENDENCY: {
                this.mdName = "dependency";
                return new DependencyCorefMentionFinder(props);
            }
            case HYBRID: {
                this.mdName = "hybrid";
                this.mentionAnnotatorRequirements.add(TreeCoreAnnotations.TreeAnnotation.class);
                this.mentionAnnotatorRequirements.add(CoreAnnotations.BeginIndexAnnotation.class);
                this.mentionAnnotatorRequirements.add(CoreAnnotations.EndIndexAnnotation.class);
                return new HybridCorefMentionFinder(headFinder, props);
            }
        }
        this.mentionAnnotatorRequirements.add(TreeCoreAnnotations.TreeAnnotation.class);
        this.mentionAnnotatorRequirements.add(CoreAnnotations.BeginIndexAnnotation.class);
        this.mentionAnnotatorRequirements.add(CoreAnnotations.EndIndexAnnotation.class);
        this.mdName = "rule";
        return new RuleBasedCorefMentionFinder(headFinder, props);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return this.mentionAnnotatorRequirements;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CorefCoreAnnotations.CorefMentionsAnnotation.class, CoreAnnotations.ParagraphAnnotation.class, CoreAnnotations.SpeakerAnnotation.class, CoreAnnotations.UtteranceAnnotation.class)));
    }
}

